/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.storage.ldap;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.naming.AuthenticationException;
import javax.naming.NamingException;
import org.jboss.logging.Logger;
import org.keycloak.component.ComponentModel;
import org.keycloak.credential.CredentialAuthentication;
import org.keycloak.credential.CredentialInput;
import org.keycloak.credential.CredentialInputUpdater;
import org.keycloak.credential.CredentialInputValidator;
import org.keycloak.credential.UserCredentialManager;
import org.keycloak.federation.kerberos.KerberosPrincipal;
import org.keycloak.federation.kerberos.impl.KerberosUsernamePasswordAuthenticator;
import org.keycloak.federation.kerberos.impl.SPNEGOAuthenticator;
import org.keycloak.models.CredentialValidationOutput;
import org.keycloak.models.GroupModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.ModelDuplicateException;
import org.keycloak.models.ModelException;
import org.keycloak.models.RealmModel;
import org.keycloak.models.RequiredActionProviderModel;
import org.keycloak.models.RoleModel;
import org.keycloak.models.UserCredentialModel;
import org.keycloak.models.UserManager;
import org.keycloak.models.UserModel;
import org.keycloak.models.UserProvider;
import org.keycloak.models.cache.CachedUserModel;
import org.keycloak.models.cache.UserCache;
import org.keycloak.models.utils.ReadOnlyUserModelDelegate;
import org.keycloak.policy.PasswordPolicyManagerProvider;
import org.keycloak.policy.PolicyError;
import org.keycloak.storage.DatastoreProvider;
import org.keycloak.storage.ReadOnlyException;
import org.keycloak.storage.StorageId;
import org.keycloak.storage.StoreManagers;
import org.keycloak.storage.UserStoragePrivateUtil;
import org.keycloak.storage.UserStorageProvider;
import org.keycloak.storage.UserStorageProviderModel;
import org.keycloak.storage.UserStorageUtil;
import org.keycloak.storage.adapter.InMemoryUserAdapter;
import org.keycloak.storage.adapter.UpdateOnlyChangeUserModelDelegate;
import org.keycloak.storage.ldap.LDAPConfig;
import org.keycloak.storage.ldap.LDAPStorageProviderFactory;
import org.keycloak.storage.ldap.LDAPStorageUserManager;
import org.keycloak.storage.ldap.LDAPUtils;
import org.keycloak.storage.ldap.LDAPWritesOnlyUserModelDelegate;
import org.keycloak.storage.ldap.ReadonlyLDAPUserModelDelegate;
import org.keycloak.storage.ldap.idm.model.LDAPDn;
import org.keycloak.storage.ldap.idm.model.LDAPObject;
import org.keycloak.storage.ldap.idm.query.Condition;
import org.keycloak.storage.ldap.idm.query.internal.LDAPQuery;
import org.keycloak.storage.ldap.idm.query.internal.LDAPQueryConditionsBuilder;
import org.keycloak.storage.ldap.idm.store.ldap.LDAPIdentityStore;
import org.keycloak.storage.ldap.kerberos.LDAPProviderKerberosConfig;
import org.keycloak.storage.ldap.mappers.LDAPMappersComparator;
import org.keycloak.storage.ldap.mappers.LDAPOperationDecorator;
import org.keycloak.storage.ldap.mappers.LDAPStorageMapper;
import org.keycloak.storage.ldap.mappers.LDAPStorageMapperManager;
import org.keycloak.storage.ldap.mappers.PasswordUpdateCallback;
import org.keycloak.storage.user.ImportedUserValidation;
import org.keycloak.storage.user.UserLookupProvider;
import org.keycloak.storage.user.UserQueryMethodsProvider;
import org.keycloak.storage.user.UserRegistrationProvider;
import org.keycloak.userprofile.AttributeGroupMetadata;
import org.keycloak.userprofile.AttributeMetadata;
import org.keycloak.userprofile.UserProfileDecorator;
import org.keycloak.userprofile.UserProfileMetadata;
import org.keycloak.userprofile.UserProfileUtil;
import org.keycloak.utils.StreamsUtil;

public class LDAPStorageProvider
implements UserStorageProvider,
CredentialInputValidator,
CredentialInputUpdater,
CredentialAuthentication,
UserLookupProvider,
UserRegistrationProvider,
UserQueryMethodsProvider,
ImportedUserValidation,
UserProfileDecorator {
    private static final Logger logger = Logger.getLogger(LDAPStorageProvider.class);
    private static final int DEFAULT_MAX_RESULTS = 0x3FFFFFFF;
    protected LDAPStorageProviderFactory factory;
    protected KeycloakSession session;
    protected UserStorageProviderModel model;
    protected LDAPIdentityStore ldapIdentityStore;
    protected UserStorageProvider.EditMode editMode;
    protected LDAPProviderKerberosConfig kerberosConfig;
    protected PasswordUpdateCallback updater;
    protected LDAPStorageMapperManager mapperManager;
    protected LDAPStorageUserManager userManager;
    private LDAPMappersComparator ldapMappersComparator;
    protected final Set<String> supportedCredentialTypes = new HashSet<String>();

    public LDAPStorageProvider(LDAPStorageProviderFactory factory, KeycloakSession session, ComponentModel model, LDAPIdentityStore ldapIdentityStore) {
        this.factory = factory;
        this.session = session;
        this.model = new UserStorageProviderModel(model);
        this.ldapIdentityStore = ldapIdentityStore;
        this.kerberosConfig = new LDAPProviderKerberosConfig(model);
        this.editMode = ldapIdentityStore.getConfig().getEditMode();
        this.mapperManager = new LDAPStorageMapperManager(this);
        this.userManager = new LDAPStorageUserManager(this);
        this.supportedCredentialTypes.add("password");
        if (this.kerberosConfig.isAllowKerberosAuthentication()) {
            this.supportedCredentialTypes.add("kerberos");
        }
        this.ldapMappersComparator = new LDAPMappersComparator(this.getLdapIdentityStore().getConfig());
    }

    public void setUpdater(PasswordUpdateCallback updater) {
        this.updater = updater;
    }

    public KeycloakSession getSession() {
        return this.session;
    }

    public LDAPIdentityStore getLdapIdentityStore() {
        return this.ldapIdentityStore;
    }

    public UserStorageProvider.EditMode getEditMode() {
        return this.editMode;
    }

    public UserStorageProviderModel getModel() {
        return this.model;
    }

    public LDAPProviderKerberosConfig getKerberosConfig() {
        return this.kerberosConfig;
    }

    public LDAPStorageMapperManager getMapperManager() {
        return this.mapperManager;
    }

    public LDAPStorageUserManager getUserManager() {
        return this.userManager;
    }

    public UserModel validate(RealmModel realm, UserModel local) {
        LDAPObject ldapObject = this.loadAndValidateUser(realm, local);
        if (ldapObject == null) {
            return null;
        }
        return this.proxy(realm, local, ldapObject, false);
    }

    protected UserModel proxy(RealmModel realm, UserModel local, LDAPObject ldapObject, boolean newUser) {
        StoreManagers datastoreProvider;
        UserModel existing = this.userManager.getManagedProxiedUser(local.getId());
        if (existing != null) {
            return existing;
        }
        if (local instanceof CachedUserModel && (existing = this.userManager.getManagedProxiedUser((local = (datastoreProvider = (StoreManagers)this.session.getProvider(DatastoreProvider.class)).userStorageManager().getUserById(realm, local.getId())).getId())) != null) {
            return existing;
        }
        Object proxied = local;
        this.checkDNChanged(realm, local, ldapObject);
        switch (this.editMode) {
            case READ_ONLY: {
                if (this.model.isImportEnabled()) {
                    proxied = new ReadonlyLDAPUserModelDelegate(local);
                    break;
                }
                proxied = new ReadOnlyUserModelDelegate(local);
                break;
            }
            case WRITABLE: 
            case UNSYNCED: {
                if (this.model.isImportEnabled() || newUser) break;
                ReadOnlyUserModelDelegate readOnlyDelegate = new ReadOnlyUserModelDelegate(local, ModelException::new);
                proxied = new LDAPWritesOnlyUserModelDelegate((UserModel)readOnlyDelegate, this);
            }
        }
        AtomicReference<UserModel> proxy = new AtomicReference<UserModel>((UserModel)proxied);
        realm.getComponentsStream(this.model.getId(), LDAPStorageMapper.class.getName()).sorted(this.ldapMappersComparator.sortAsc()).forEachOrdered(mapperModel -> {
            LDAPStorageMapper ldapMapper = this.mapperManager.getMapper((ComponentModel)mapperModel);
            proxy.set(ldapMapper.proxy(ldapObject, (UserModel)proxy.get(), realm));
        });
        proxied = proxy.get();
        if (!this.model.isImportEnabled()) {
            proxied = new UpdateOnlyChangeUserModelDelegate(proxied);
        }
        this.userManager.setManagedProxiedUser((UserModel)proxied, ldapObject);
        return proxied;
    }

    private void checkDNChanged(RealmModel realm, UserModel local, LDAPObject ldapObject) {
        String ldapDn;
        String dnFromDB = local.getFirstAttribute("LDAP_ENTRY_DN");
        String string = ldapDn = ldapObject.getDn() == null ? null : ldapObject.getDn().toString();
        if (ldapDn != null && !ldapDn.equals(dnFromDB)) {
            logger.debugf("Updated LDAP DN of user '%s' to '%s'", (Object)local.getUsername(), (Object)ldapDn);
            local.setSingleAttribute("LDAP_ENTRY_DN", ldapDn);
            UserCache userCache = UserStorageUtil.userCache((KeycloakSession)this.session);
            if (userCache != null) {
                userCache.evict(realm, local);
            }
        }
    }

    public boolean supportsCredentialAuthenticationFor(String type) {
        return type.equals("kerberos") && this.kerberosConfig.isAllowKerberosAuthentication();
    }

    public Stream<UserModel> searchForUserByUserAttributeStream(RealmModel realm, String attrName, String attrValue) {
        List<Object> ldapObjects;
        if ("LDAP_ID".equals(attrName)) {
            LDAPObject ldapObject = this.loadLDAPUserByUuid(realm, attrValue);
            ldapObjects = ldapObject == null ? Collections.emptyList() : Collections.singletonList(ldapObject);
        } else if ("LDAP_ENTRY_DN".equals(attrName)) {
            LDAPObject ldapObject = this.loadLDAPUserByDN(realm, LDAPDn.fromString(attrValue));
            ldapObjects = ldapObject == null ? Collections.emptyList() : Collections.singletonList(ldapObject);
        } else {
            try (LDAPQuery ldapQuery = LDAPUtils.createQueryForUserSearch(this, realm);){
                LDAPQueryConditionsBuilder conditionsBuilder = new LDAPQueryConditionsBuilder();
                Condition attrCondition = conditionsBuilder.equal(attrName, attrValue);
                ldapQuery.addWhereCondition(attrCondition);
                ldapObjects = ldapQuery.getResultList();
            }
        }
        return ldapObjects.stream().map(ldapUser -> this.importUserFromLDAP(this.session, realm, (LDAPObject)ldapUser));
    }

    public boolean synchronizeRegistrations() {
        return "true".equalsIgnoreCase((String)this.model.getConfig().getFirst((Object)"syncRegistrations")) && this.editMode == UserStorageProvider.EditMode.WRITABLE;
    }

    public UserModel addUser(RealmModel realm, String username) {
        UserModel user;
        if (!this.synchronizeRegistrations()) {
            return null;
        }
        if (this.model.isImportEnabled()) {
            user = UserStoragePrivateUtil.userLocalStorage((KeycloakSession)this.session).addUser(realm, username);
            user.setFederationLink(this.model.getId());
        } else {
            user = new InMemoryUserAdapter(this.session, realm, new StorageId(this.model.getId(), username).getId());
            user.setUsername(username);
        }
        LDAPObject ldapUser = LDAPUtils.addUserToLDAP(this, realm, user, ldapObject -> {
            LDAPUtils.checkUuid(ldapObject, this.ldapIdentityStore.getConfig());
            user.setSingleAttribute("LDAP_ID", ldapObject.getUuid());
            user.setSingleAttribute("LDAP_ENTRY_DN", ldapObject.getDn().toString());
        });
        UserModel proxy = this.proxy(realm, user, ldapUser, true);
        proxy.grantRole(realm.getDefaultRole());
        realm.getDefaultGroupsStream().forEach(arg_0 -> ((UserModel)proxy).joinGroup(arg_0));
        realm.getRequiredActionProvidersStream().filter(RequiredActionProviderModel::isEnabled).filter(RequiredActionProviderModel::isDefaultAction).map(RequiredActionProviderModel::getAlias).forEachOrdered(arg_0 -> ((UserModel)proxy).addRequiredAction(arg_0));
        return proxy;
    }

    public boolean removeUser(RealmModel realm, UserModel user) {
        if (this.editMode == UserStorageProvider.EditMode.READ_ONLY || this.editMode == UserStorageProvider.EditMode.UNSYNCED) {
            logger.warnf("User '%s' can't be deleted in LDAP as editMode is '%s'. Deleting user just from Keycloak DB, but he will be re-imported from LDAP again once searched in Keycloak", (Object)user.getUsername(), (Object)this.editMode.toString());
            return true;
        }
        LDAPObject ldapObject = this.loadAndValidateUser(realm, user);
        if (ldapObject == null) {
            logger.warnf("User '%s' can't be deleted from LDAP as it doesn't exist here", (Object)user.getUsername());
            return false;
        }
        this.ldapIdentityStore.remove(ldapObject);
        this.userManager.removeManagedUserEntry(user.getId());
        return true;
    }

    public UserModel getUserById(RealmModel realm, String id) {
        UserModel alreadyLoadedInSession = this.userManager.getManagedProxiedUser(id);
        if (alreadyLoadedInSession != null) {
            return alreadyLoadedInSession;
        }
        StorageId storageId = new StorageId(id);
        return this.getUserByUsername(realm, storageId.getExternalId());
    }

    public Stream<UserModel> searchForUserStream(RealmModel realm, Map<String, String> params, Integer firstResult, Integer maxResults) {
        Stream<LDAPObject> result;
        String search = params.get("keycloak.session.realm.users.query.search");
        Stream<LDAPObject> stream = result = search != null ? this.searchLDAP(realm, search, firstResult, maxResults) : this.searchLDAPByAttributes(realm, params, firstResult, maxResults);
        if (this.model.isImportEnabled()) {
            result = result.filter(this.filterLocalUsers(realm));
        }
        return StreamsUtil.paginatedStream(result.map(ldapObject -> this.importUserFromLDAP(this.session, realm, (LDAPObject)ldapObject, false)).filter(Objects::nonNull), (Integer)firstResult, (Integer)maxResults);
    }

    public Stream<UserModel> getGroupMembersStream(RealmModel realm, GroupModel group, Integer firstResult, Integer maxResults) {
        int first = firstResult == null ? 0 : firstResult;
        int max = maxResults == null ? 0x3FFFFFFF : maxResults;
        return realm.getComponentsStream(this.model.getId(), LDAPStorageMapper.class.getName()).sorted(this.ldapMappersComparator.sortAsc()).map(mapperModel -> this.mapperManager.getMapper((ComponentModel)mapperModel).getGroupMembers(realm, group, first, max)).filter(((Predicate<List>)List::isEmpty).negate()).map(Collection::stream).findFirst().orElse(Stream.empty());
    }

    public Stream<UserModel> getRoleMembersStream(RealmModel realm, RoleModel role, Integer firstResult, Integer maxResults) {
        int first = firstResult == null ? 0 : firstResult;
        int max = maxResults == null ? 0x3FFFFFFF : maxResults;
        return realm.getComponentsStream(this.model.getId(), LDAPStorageMapper.class.getName()).sorted(this.ldapMappersComparator.sortAsc()).map(mapperModel -> this.mapperManager.getMapper((ComponentModel)mapperModel).getRoleMembers(realm, role, first, max)).filter(((Predicate<List>)List::isEmpty).negate()).map(Collection::stream).findFirst().orElse(Stream.empty());
    }

    public List<UserModel> loadUsersByUsernames(List<String> usernames, RealmModel realm) {
        ArrayList<UserModel> result = new ArrayList<UserModel>();
        for (String username : usernames) {
            UserModel kcUser = this.session.users().getUserByUsername(realm, username);
            if (kcUser == null) {
                logger.warnf("User '%s' referenced by membership wasn't found in LDAP", (Object)username);
                continue;
            }
            if (this.model.isImportEnabled() && !this.model.getId().equals(kcUser.getFederationLink())) {
                logger.warnf("Incorrect federation provider of user '%s'", (Object)kcUser.getUsername());
                continue;
            }
            result.add(kcUser);
        }
        return result;
    }

    private Stream<LDAPObject> loadUsersByDNsChunk(RealmModel realm, String rdnAttr, Collection<LDAPDn> dns) {
        try (LDAPQuery ldapQuery = LDAPUtils.createQueryForUserSearch(this, realm);){
            LDAPQueryConditionsBuilder conditionsBuilder = new LDAPQueryConditionsBuilder();
            HashSet<LDAPDn> dnSet = new HashSet<LDAPDn>(dns);
            Condition[] conditions = (Condition[])dns.stream().map(dn -> conditionsBuilder.equal(rdnAttr, dn.getFirstRdn().getAttrValue(rdnAttr))).toArray(Condition[]::new);
            ldapQuery.addWhereCondition(conditionsBuilder.orCondition(conditions));
            Stream<LDAPObject> stream = ldapQuery.getResultList().stream().filter(ldapUser -> dnSet.contains(ldapUser.getDn()));
            return stream;
        }
    }

    public Stream<UserModel> loadUsersByDNs(RealmModel realm, Collection<LDAPDn> dns, int firstResult, int maxResults) {
        String rdnAttr = this.ldapIdentityStore.getConfig().getRdnLdapAttribute();
        LDAPDn usersDn = LDAPDn.fromString(this.ldapIdentityStore.getConfig().getUsersDn());
        int chunkSize = this.ldapIdentityStore.getConfig().getMaxConditions();
        return StreamsUtil.chunkedStream(dns.stream().filter(dn -> dn.getFirstRdn().getAttrValue(rdnAttr) != null && dn.isDescendantOf(usersDn)), (int)chunkSize).map(chunk -> this.loadUsersByDNsChunk(realm, rdnAttr, (Collection<LDAPDn>)chunk)).flatMap(Function.identity()).skip(firstResult).limit(maxResults).map(ldapUser -> this.importUserFromLDAP(this.session, realm, (LDAPObject)ldapUser));
    }

    private Stream<LDAPObject> loadUsersByUniqueAttributeChunk(RealmModel realm, String uidName, Collection<String> uids) {
        try (LDAPQuery ldapQuery = LDAPUtils.createQueryForUserSearch(this, realm);){
            LDAPQueryConditionsBuilder conditionsBuilder = new LDAPQueryConditionsBuilder();
            Condition[] conditions = (Condition[])uids.stream().map(uid -> conditionsBuilder.equal(uidName, uid)).toArray(Condition[]::new);
            ldapQuery.addWhereCondition(conditionsBuilder.orCondition(conditions));
            Stream<LDAPObject> stream = ldapQuery.getResultList().stream();
            return stream;
        }
    }

    public Stream<UserModel> loadUsersByUniqueAttribute(RealmModel realm, String uidName, Collection<String> uids, int firstResult, int maxResults) {
        int chunkSize = this.ldapIdentityStore.getConfig().getMaxConditions();
        return StreamsUtil.chunkedStream(uids.stream(), (int)chunkSize).map(chunk -> this.loadUsersByUniqueAttributeChunk(realm, uidName, (Collection<String>)chunk)).flatMap(Function.identity()).skip(firstResult).limit(maxResults).map(ldapUser -> this.importUserFromLDAP(this.session, realm, (LDAPObject)ldapUser));
    }

    private Condition createSearchCondition(LDAPQueryConditionsBuilder conditionsBuilder, String name, boolean equals, String value) {
        if (equals) {
            return conditionsBuilder.equal(name, value);
        }
        String[] values = value.split("\\Q*\\E+", -1);
        String start = null;
        String end = null;
        String[] middle = null;
        if (!values[0].isEmpty()) {
            start = values[0];
        }
        if (values.length > 1 && !values[values.length - 1].isEmpty()) {
            end = values[values.length - 1];
        }
        if (values.length > 2) {
            middle = Arrays.copyOfRange(values, 1, values.length - 1);
        }
        if (start == null && middle == null && end == null) {
            return conditionsBuilder.present(name);
        }
        return conditionsBuilder.substring(name, start, middle, end);
    }

    private Stream<LDAPObject> searchLDAPByAttributes(RealmModel realm, Map<String, String> attributes, Integer firstResult, Integer maxResults) {
        Set managedAttrs = realm.getComponentsStream(this.model.getId(), LDAPStorageMapper.class.getName()).map(this.mapperManager::getMapper).map(LDAPStorageMapper::getUserAttributes).flatMap(Collection::stream).collect(Collectors.toSet());
        boolean exact = Boolean.parseBoolean(attributes.get("keycloak.session.realm.users.query.exact"));
        try (LDAPQuery ldapQuery = LDAPUtils.createQueryForUserSearch(this, realm);){
            LDAPQueryConditionsBuilder conditionsBuilder = new LDAPQueryConditionsBuilder();
            for (Map.Entry<String, String> entry : attributes.entrySet()) {
                String attrName = entry.getKey();
                if ("LDAP_ID".equals(attrName)) {
                    String uuidLDAPAttributeName = this.ldapIdentityStore.getConfig().getUuidLDAPAttributeName();
                    Condition usernameCondition = conditionsBuilder.equal(uuidLDAPAttributeName, entry.getValue());
                    ldapQuery.addWhereCondition(usernameCondition);
                    continue;
                }
                if ("LDAP_ENTRY_DN".equals(attrName)) {
                    ldapQuery.setSearchDn(entry.getValue());
                    ldapQuery.setSearchScope(0);
                    continue;
                }
                if (managedAttrs.contains(attrName)) {
                    switch (attrName) {
                        case "username": 
                        case "email": 
                        case "firstName": 
                        case "lastName": {
                            if (exact) {
                                ldapQuery.addWhereCondition(conditionsBuilder.equal(attrName, entry.getValue()));
                                break;
                            }
                            ldapQuery.addWhereCondition(conditionsBuilder.substring(attrName, null, new String[]{entry.getValue()}, null));
                            break;
                        }
                        default: {
                            ldapQuery.addWhereCondition(conditionsBuilder.equal(attrName, entry.getValue()));
                            break;
                        }
                    }
                    continue;
                }
                if (attrName.equals("keycloak.session.realm.users.query.exact") || attrName.equals("keycloak.session.realm.users.query.include_service_account") || "enabled".equals(attrName) && Boolean.parseBoolean(entry.getValue())) continue;
                logger.debugf("Searching in LDAP using unmapped attribute [%s], returning empty stream", (Object)attrName);
                Object object = Stream.empty();
                return object;
            }
            Stream<LDAPObject> stream = this.paginatedSearchLDAP(ldapQuery, firstResult, maxResults);
            return stream;
        }
    }

    /*
     * WARNING - void declaration
     */
    private Stream<LDAPObject> searchLDAP(RealmModel realm, String search, Integer firstResult, Integer maxResults) {
        try (LDAPQuery ldapQuery = LDAPUtils.createQueryForUserSearch(this, realm);){
            LDAPQueryConditionsBuilder conditionsBuilder = new LDAPQueryConditionsBuilder();
            for (String string : search.split("\\s+")) {
                void var10_13;
                boolean equals = false;
                LinkedList<Condition> conditions = new LinkedList<Condition>();
                if (string.startsWith("\"") && string.endsWith("\"")) {
                    String string2 = string.substring(1, string.length() - 1);
                    equals = true;
                } else if (!string.endsWith("*")) {
                    String string3 = string + "*";
                }
                conditions.add(this.createSearchCondition(conditionsBuilder, "username", equals, (String)var10_13));
                conditions.add(this.createSearchCondition(conditionsBuilder, "email", equals, (String)var10_13));
                conditions.add(this.createSearchCondition(conditionsBuilder, "firstName", equals, (String)var10_13));
                conditions.add(this.createSearchCondition(conditionsBuilder, "lastName", equals, (String)var10_13));
                ldapQuery.addWhereCondition(conditionsBuilder.orCondition((Condition[])conditions.toArray(Condition[]::new)));
            }
            Stream<LDAPObject> stream = this.paginatedSearchLDAP(ldapQuery, firstResult, maxResults);
            return stream;
        }
    }

    protected LDAPObject loadAndValidateUser(RealmModel realm, UserModel local) {
        LDAPObject existing = this.userManager.getManagedLDAPUser(local.getId());
        if (existing != null) {
            return existing;
        }
        String uuidLdapAttribute = local.getFirstAttribute("LDAP_ID");
        LDAPObject ldapUser = this.loadLDAPUserByUuid(realm, uuidLdapAttribute);
        if (ldapUser == null) {
            return null;
        }
        LDAPUtils.checkUuid(ldapUser, this.ldapIdentityStore.getConfig());
        if (ldapUser.getUuid().equals(local.getFirstAttribute("LDAP_ID"))) {
            return ldapUser;
        }
        logger.warnf("LDAP User invalid. ID doesn't match. ID from LDAP [%s], LDAP ID from local DB: [%s]", (Object)ldapUser.getUuid(), (Object)local.getFirstAttribute("LDAP_ID"));
        return null;
    }

    public UserModel getUserByUsername(RealmModel realm, String username) {
        LDAPObject ldapUser = this.loadLDAPUserByUsername(realm, username);
        if (ldapUser == null) {
            return null;
        }
        return this.importUserFromLDAP(this.session, realm, ldapUser);
    }

    protected UserModel importUserFromLDAP(KeycloakSession session, RealmModel realm, LDAPObject ldapUser) {
        return this.importUserFromLDAP(session, realm, ldapUser, true);
    }

    private void doImportUser(RealmModel realm, UserModel user, LDAPObject ldapUser) {
        user.setEnabled(true);
        realm.getComponentsStream(this.model.getId(), LDAPStorageMapper.class.getName()).sorted(this.ldapMappersComparator.sortDesc()).forEachOrdered(mapperModel -> {
            if (logger.isTraceEnabled()) {
                logger.tracef("Using mapper %s during import user from LDAP", mapperModel);
            }
            LDAPStorageMapper ldapMapper = this.mapperManager.getMapper((ComponentModel)mapperModel);
            ldapMapper.onImportUserFromLDAP(ldapUser, user, realm, true);
        });
        String userDN = ldapUser.getDn().toString();
        if (this.model.isImportEnabled()) {
            user.setFederationLink(this.model.getId());
        }
        user.setSingleAttribute("LDAP_ID", ldapUser.getUuid());
        user.setSingleAttribute("LDAP_ENTRY_DN", userDN);
        if (this.getLdapIdentityStore().getConfig().isTrustEmail()) {
            user.setEmailVerified(true);
        }
        if (this.kerberosConfig.isAllowKerberosAuthentication() && this.kerberosConfig.getKerberosPrincipalAttribute() != null) {
            String kerberosPrincipal = ldapUser.getAttributeAsString(this.kerberosConfig.getKerberosPrincipalAttribute());
            if (kerberosPrincipal == null) {
                logger.warnf("Kerberos principal attribute not found on LDAP user [%s]. Configured kerberos principal attribute name is [%s]", (Object)ldapUser.getDn(), (Object)this.kerberosConfig.getKerberosPrincipalAttribute());
            } else {
                KerberosPrincipal kerberosPrinc = new KerberosPrincipal(kerberosPrincipal);
                user.setSingleAttribute("KERBEROS_PRINCIPAL", kerberosPrinc.toString());
            }
        }
        logger.debugf("Imported new user from LDAP to Keycloak DB. Username: [%s], Email: [%s], LDAP_ID: [%s], LDAP Entry DN: [%s]", new Object[]{user.getUsername(), user.getEmail(), ldapUser.getUuid(), userDN});
    }

    protected UserModel importUserFromLDAP(KeycloakSession session, RealmModel realm, LDAPObject ldapUser, boolean forcedImport) {
        String ldapUsername = LDAPUtils.getUsername(ldapUser, this.ldapIdentityStore.getConfig());
        LDAPUtils.checkUuid(ldapUser, this.ldapIdentityStore.getConfig());
        UserModel imported = null;
        UserModel existingLocalUser = null;
        UserProvider userProvider = UserStoragePrivateUtil.userLocalStorage((KeycloakSession)session);
        try {
            if (this.model.isImportEnabled()) {
                existingLocalUser = userProvider.searchForUserByUserAttributeStream(realm, "LDAP_ID", ldapUser.getUuid()).findFirst().orElse(null);
                if (existingLocalUser != null) {
                    imported = existingLocalUser;
                    if (UserStorageUtil.userCache((KeycloakSession)session) != null) {
                        UserStorageUtil.userCache((KeycloakSession)session).evict(realm, existingLocalUser);
                    }
                    if (!forcedImport) {
                        return null;
                    }
                } else {
                    imported = userProvider.addUser(realm, ldapUsername);
                }
            } else {
                InMemoryUserAdapter adapter = new InMemoryUserAdapter(session, realm, new StorageId(this.model.getId(), ldapUsername).getId());
                adapter.addDefaults();
                imported = adapter;
            }
            this.doImportUser(realm, imported, ldapUser);
        }
        catch (ModelDuplicateException e) {
            logger.warnf((Throwable)e, "Duplicated user importing from LDAP. LDAP Entry DN: [%s], LDAP_ID: [%s]", (Object)ldapUser.getDn(), (Object)ldapUser.getUuid());
            if (!forcedImport && existingLocalUser == null) {
                if (this.model.isImportEnabled() && imported != null) {
                    userProvider.removeUser(realm, imported);
                }
                return null;
            }
            throw e;
        }
        UserModel proxy = this.proxy(realm, imported, ldapUser, false);
        return proxy;
    }

    protected LDAPObject queryByEmail(RealmModel realm, String email) {
        try (LDAPQuery ldapQuery = LDAPUtils.createQueryForUserSearch(this, realm);){
            LDAPQueryConditionsBuilder conditionsBuilder = new LDAPQueryConditionsBuilder();
            Condition emailCondition = conditionsBuilder.equal("email", email);
            ldapQuery.addWhereCondition(emailCondition);
            LDAPObject lDAPObject = ldapQuery.getFirstResult();
            return lDAPObject;
        }
    }

    public UserModel getUserByEmail(RealmModel realm, String email) {
        LDAPObject ldapUser = this.queryByEmail(realm, email);
        if (ldapUser == null) {
            return null;
        }
        String ldapUsername = LDAPUtils.getUsername(ldapUser, this.ldapIdentityStore.getConfig());
        UserModel user = UserStoragePrivateUtil.userLocalStorage((KeycloakSession)this.session).getUserByUsername(realm, ldapUsername);
        if (user != null) {
            LDAPUtils.checkUuid(ldapUser, this.ldapIdentityStore.getConfig());
            if (ldapUser.getUuid().equals(user.getFirstAttribute("LDAP_ID"))) {
                return this.proxy(realm, user, ldapUser, false);
            }
            throw new ModelDuplicateException("User with username '" + ldapUsername + "' already exists in Keycloak. It conflicts with LDAP user with email '" + email + "'");
        }
        return this.importUserFromLDAP(this.session, realm, ldapUser);
    }

    public void preRemove(RealmModel realm) {
    }

    public void preRemove(RealmModel realm, RoleModel role) {
    }

    public void preRemove(RealmModel realm, GroupModel group) {
    }

    public boolean validPassword(RealmModel realm, UserModel user, String password) {
        if (this.kerberosConfig.isAllowKerberosAuthentication() && this.kerberosConfig.isUseKerberosForPasswordAuthentication()) {
            KerberosUsernamePasswordAuthenticator authenticator = this.factory.createKerberosUsernamePasswordAuthenticator(this.kerberosConfig);
            String kerberosUsername = user.getFirstAttribute("KERBEROS_PRINCIPAL");
            if (kerberosUsername == null) {
                kerberosUsername = user.getUsername();
            }
            return authenticator.validUser(kerberosUsername, password);
        }
        LDAPObject ldapUser = this.loadAndValidateUser(realm, user);
        if (ldapUser == null) {
            return false;
        }
        try {
            this.ldapIdentityStore.validatePassword(ldapUser, password);
            return true;
        }
        catch (AuthenticationException ae) {
            AtomicReference<Boolean> processed = new AtomicReference<Boolean>(false);
            realm.getComponentsStream(this.model.getId(), LDAPStorageMapper.class.getName()).sorted(this.ldapMappersComparator.sortDesc()).forEachOrdered(mapperModel -> {
                if (logger.isTraceEnabled()) {
                    logger.tracef("Using mapper %s during import user from LDAP", mapperModel);
                }
                LDAPStorageMapper ldapMapper = this.mapperManager.getMapper((ComponentModel)mapperModel);
                processed.set((Boolean)processed.get() != false || ldapMapper.onAuthenticationFailure(ldapUser, user, ae, realm));
            });
            return processed.get();
        }
    }

    public boolean updateCredential(RealmModel realm, UserModel user, CredentialInput input) {
        if (!"password".equals(input.getType()) || !(input instanceof UserCredentialModel)) {
            return false;
        }
        if (this.editMode == UserStorageProvider.EditMode.READ_ONLY) {
            throw new ReadOnlyException("Federated storage is not writable");
        }
        if (this.editMode == UserStorageProvider.EditMode.WRITABLE) {
            PolicyError error;
            LDAPIdentityStore ldapIdentityStore = this.getLdapIdentityStore();
            String password = input.getChallengeResponse();
            LDAPObject ldapUser = this.loadAndValidateUser(realm, user);
            if (ldapUser == null) {
                logger.warnf("User '%s' can't be updated in LDAP as it doesn't exist there", (Object)user.getUsername());
                return false;
            }
            if (ldapIdentityStore.getConfig().isValidatePasswordPolicy() && (error = ((PasswordPolicyManagerProvider)this.session.getProvider(PasswordPolicyManagerProvider.class)).validate(realm, user, password)) != null) {
                throw new ModelException(error.getMessage(), error.getParameters());
            }
            try {
                LDAPOperationDecorator operationDecorator = null;
                if (this.updater != null) {
                    operationDecorator = this.updater.beforePasswordUpdate(user, ldapUser, (UserCredentialModel)input);
                }
                ldapIdentityStore.updatePassword(ldapUser, password, operationDecorator);
                if (this.updater != null) {
                    this.updater.passwordUpdated(user, ldapUser, (UserCredentialModel)input);
                }
                return true;
            }
            catch (ModelException me) {
                if (this.updater != null) {
                    this.updater.passwordUpdateFailed(user, ldapUser, (UserCredentialModel)input, me);
                    return false;
                }
                throw me;
            }
        }
        return false;
    }

    public void disableCredentialType(RealmModel realm, UserModel user, String credentialType) {
    }

    public Stream<String> getDisableableCredentialTypesStream(RealmModel realm, UserModel user) {
        return Stream.empty();
    }

    public Set<String> getSupportedCredentialTypes() {
        return new HashSet<String>(this.supportedCredentialTypes);
    }

    public boolean supportsCredentialType(String credentialType) {
        return this.getSupportedCredentialTypes().contains(credentialType);
    }

    public boolean isConfiguredFor(RealmModel realm, UserModel user, String credentialType) {
        return this.getSupportedCredentialTypes().contains(credentialType);
    }

    public boolean isValid(RealmModel realm, UserModel user, CredentialInput input) {
        if (!(input instanceof UserCredentialModel)) {
            return false;
        }
        if (input.getType().equals("password") && !((UserCredentialManager)user.credentialManager()).isConfiguredLocally("password")) {
            return this.validPassword(realm, user, input.getChallengeResponse());
        }
        return false;
    }

    public CredentialValidationOutput authenticate(RealmModel realm, CredentialInput cred) {
        if (!(cred instanceof UserCredentialModel)) {
            return CredentialValidationOutput.fallback();
        }
        UserCredentialModel credential = (UserCredentialModel)cred;
        if (credential.getType().equals("kerberos") && this.kerberosConfig.isAllowKerberosAuthentication()) {
            SPNEGOAuthenticator spnegoAuthenticator = (SPNEGOAuthenticator)credential.getNote("authenticatedSpnegoContext");
            if (spnegoAuthenticator != null) {
                logger.debugf("SPNEGO authentication already performed by previous provider. Provider '%s' will try to lookup user with principal kerberos principal '%s'", (Object)this, (Object)spnegoAuthenticator.getAuthenticatedKerberosPrincipal());
            } else {
                String spnegoToken = credential.getChallengeResponse();
                spnegoAuthenticator = this.factory.createSPNEGOAuthenticator(spnegoToken, this.kerberosConfig);
                spnegoAuthenticator.authenticate();
            }
            HashMap<String, String> state = new HashMap<String, String>();
            if (spnegoAuthenticator.isAuthenticated()) {
                KerberosPrincipal kerberosPrincipal = spnegoAuthenticator.getAuthenticatedKerberosPrincipal();
                UserModel user = this.findOrCreateAuthenticatedUser(realm, kerberosPrincipal);
                if (user == null) {
                    logger.debugf("Kerberos/SPNEGO authentication succeeded with kerberos principal [%s], but couldn't find or create user with federation provider [%s]", (Object)kerberosPrincipal.toString(), (Object)this.model.getName());
                    credential.setNote("authenticatedSpnegoContext", (Object)spnegoAuthenticator);
                    return CredentialValidationOutput.fallback();
                }
                String delegationCredential = spnegoAuthenticator.getSerializedDelegationCredential();
                if (delegationCredential != null) {
                    state.put("gss_delegation_credential", delegationCredential);
                }
                return new CredentialValidationOutput(user, CredentialValidationOutput.Status.AUTHENTICATED, state);
            }
            if (spnegoAuthenticator.getResponseToken() != null) {
                logger.tracef("SPNEGO Handshake will continue", new Object[0]);
                state.put("SpnegoResponseToken", spnegoAuthenticator.getResponseToken());
                return new CredentialValidationOutput(null, CredentialValidationOutput.Status.CONTINUE, state);
            }
            logger.tracef("SPNEGO Handshake not successful", new Object[0]);
            return CredentialValidationOutput.fallback();
        }
        return CredentialValidationOutput.fallback();
    }

    public void close() {
    }

    protected UserModel findOrCreateAuthenticatedUser(RealmModel realm, KerberosPrincipal kerberosPrincipal) {
        UserModel user;
        String kerberosPrincipalAttrName = this.kerberosConfig.getKerberosPrincipalAttribute();
        if (kerberosPrincipalAttrName != null) {
            logger.tracef("Trying to find user with kerberos principal [%s] in local storage.", (Object)kerberosPrincipal.toString());
            user = UserStoragePrivateUtil.userLocalStorage((KeycloakSession)this.session).searchForUserByUserAttributeStream(realm, "KERBEROS_PRINCIPAL", kerberosPrincipal.toString()).findFirst().orElse(null);
        } else {
            logger.tracef("Trying to find user in local storage based on username [%s]. Full kerberos principal [%s]", (Object)kerberosPrincipal.getPrefix(), (Object)kerberosPrincipal);
            user = UserStoragePrivateUtil.userLocalStorage((KeycloakSession)this.session).getUserByUsername(realm, kerberosPrincipal.getPrefix());
        }
        if (user != null) {
            logger.debugf("Kerberos authenticated user [%s] found in Keycloak storage", (Object)user.getUsername());
            if (!this.model.getId().equals(user.getFederationLink())) {
                logger.warnf("User with username [%s] already exists, but is not linked to provider [%s]. Kerberos principal is [%s]", (Object)user.getUsername(), (Object)this.model.getName(), (Object)kerberosPrincipal);
                return null;
            }
            LDAPObject ldapObject = this.loadAndValidateUser(realm, user);
            if (kerberosPrincipalAttrName != null && ldapObject != null && !kerberosPrincipal.toString().equalsIgnoreCase(ldapObject.getAttributeAsString(kerberosPrincipalAttrName))) {
                logger.warnf("User with username [%s] aready exists and is linked to provider [%s] but is not valid. Authenticated kerberos principal is [%s], but LDAP user has different kerberos principal [%s]", new Object[]{user.getUsername(), this.model.getName(), kerberosPrincipal, ldapObject.getAttributeAsString(kerberosPrincipalAttrName)});
                ldapObject = null;
            }
            if (ldapObject != null) {
                return this.proxy(realm, user, ldapObject, false);
            }
            logger.warnf("User with username [%s] aready exists and is linked to provider [%s] but is not valid. Stale LDAP_ID on local user is: %s", (Object)user.getUsername(), (Object)this.model.getName(), (Object)user.getFirstAttribute("LDAP_ID"));
            logger.warn((Object)"Will re-create user");
            UserCache userCache = UserStorageUtil.userCache((KeycloakSession)this.session);
            if (userCache != null) {
                userCache.evict(realm, user);
            }
            new UserManager(this.session).removeUser(realm, user, UserStoragePrivateUtil.userLocalStorage((KeycloakSession)this.session));
        }
        if (kerberosPrincipalAttrName != null) {
            logger.debugf("Trying to find kerberos authenticated user [%s] in LDAP. Kerberos principal attribute is [%s]", (Object)kerberosPrincipal.toString(), (Object)kerberosPrincipalAttrName);
            try (LDAPQuery ldapQuery = LDAPUtils.createQueryForUserSearch(this, realm);){
                LDAPQueryConditionsBuilder conditionsBuilder = new LDAPQueryConditionsBuilder();
                Condition krbPrincipalCondition = conditionsBuilder.equal(kerberosPrincipalAttrName, kerberosPrincipal.toString());
                ldapQuery.addWhereCondition(krbPrincipalCondition);
                LDAPObject ldapUser = ldapQuery.getFirstResult();
                if (ldapUser == null) {
                    logger.warnf("Not found LDAP user with kerberos principal [%s]. Kerberos principal attribute is [%s].", (Object)kerberosPrincipal.toString(), (Object)kerberosPrincipalAttrName);
                    UserModel userModel = null;
                    return userModel;
                }
                UserModel userModel = this.importUserFromLDAP(this.session, realm, ldapUser);
                return userModel;
            }
        }
        logger.debugf("Kerberos authenticated user [%s] not in Keycloak storage. Creating him", (Object)kerberosPrincipal.toString());
        return this.getUserByUsername(realm, kerberosPrincipal.getPrefix());
    }

    public LDAPObject loadLDAPUserByUsername(RealmModel realm, String username) {
        try (LDAPQuery ldapQuery = LDAPUtils.createQueryForUserSearch(this, realm);){
            LDAPQueryConditionsBuilder conditionsBuilder = new LDAPQueryConditionsBuilder();
            String usernameMappedAttribute = this.ldapIdentityStore.getConfig().getUsernameLdapAttribute();
            Condition usernameCondition = conditionsBuilder.equal(usernameMappedAttribute, username);
            ldapQuery.addWhereCondition(usernameCondition);
            LDAPObject ldapUser = ldapQuery.getFirstResult();
            if (ldapUser == null) {
                LDAPObject lDAPObject = null;
                return lDAPObject;
            }
            LDAPObject lDAPObject = ldapUser;
            return lDAPObject;
        }
    }

    public LDAPObject loadLDAPUserByUuid(RealmModel realm, String uuid) {
        if (uuid == null) {
            return null;
        }
        try (LDAPQuery ldapQuery = LDAPUtils.createQueryForUserSearch(this, realm);){
            LDAPQueryConditionsBuilder conditionsBuilder = new LDAPQueryConditionsBuilder();
            String uuidLDAPAttributeName = this.ldapIdentityStore.getConfig().getUuidLDAPAttributeName();
            Condition usernameCondition = conditionsBuilder.equal(uuidLDAPAttributeName, uuid);
            ldapQuery.addWhereCondition(usernameCondition);
            LDAPObject lDAPObject = ldapQuery.getFirstResult();
            return lDAPObject;
        }
    }

    public LDAPObject loadLDAPUserByDN(RealmModel realm, LDAPDn dn) {
        if (dn == null || !dn.isDescendantOf(LDAPDn.fromString(this.ldapIdentityStore.getConfig().getUsersDn()))) {
            return null;
        }
        try (LDAPQuery ldapQuery = LDAPUtils.createQueryForUserSearch(this, realm);){
            ldapQuery.setSearchDn(dn.getLdapName());
            ldapQuery.setSearchScope(0);
            LDAPObject lDAPObject = ldapQuery.getFirstResult();
            return lDAPObject;
        }
    }

    private Predicate<LDAPObject> filterLocalUsers(RealmModel realm) {
        return ldapObject -> UserStoragePrivateUtil.userLocalStorage((KeycloakSession)this.session).getUserByUsername(realm, LDAPUtils.getUsername(ldapObject, this.ldapIdentityStore.getConfig())) == null;
    }

    private Stream<LDAPObject> paginatedSearchLDAP(LDAPQuery ldapQuery, Integer firstResult, Integer maxResults) {
        LDAPConfig ldapConfig = ldapQuery.getLdapProvider().getLdapIdentityStore().getConfig();
        if (ldapConfig.isPagination()) {
            int limit = maxResults != null && maxResults >= 0 ? (firstResult != null && firstResult > 0 ? Integer.min(ldapConfig.getBatchSizeForSync(), Integer.sum(firstResult, maxResults)) : Integer.min(ldapConfig.getBatchSizeForSync(), maxResults)) : (firstResult != null && firstResult > 0 ? Integer.min(ldapConfig.getBatchSizeForSync(), firstResult) : ldapConfig.getBatchSizeForSync());
            return Stream.iterate(ldapQuery, query -> {
                if (query.getPaginationContext() == null) {
                    try {
                        query.initPagination();
                        return true;
                    }
                    catch (NamingException e) {
                        throw new ModelException("Querying of LDAP failed " + query, (Throwable)e);
                    }
                }
                return query.getPaginationContext().hasNextPage();
            }, query -> query).flatMap(query -> {
                query.setLimit(limit);
                List<LDAPObject> ldapObjects = query.getResultList();
                if (ldapObjects.isEmpty()) {
                    return Stream.empty();
                }
                return ldapObjects.stream();
            });
        }
        return ldapQuery.getResultList().stream();
    }

    public String toString() {
        return "LDAPStorageProvider - " + this.getModel().getName();
    }

    public List<AttributeMetadata> decorateUserProfile(String providerId, UserProfileMetadata metadata) {
        int guiOrder = (int)metadata.getAttributes().stream().map(AttributeMetadata::getName).distinct().count();
        RealmModel realm = this.session.getContext().getRealm();
        List attributes = realm.getComponentsStream(this.model.getId(), LDAPStorageMapper.class.getName()).sorted(this.ldapMappersComparator.sortAsc()).flatMap(mapperModel -> {
            LDAPStorageMapper ldapMapper = this.mapperManager.getMapper((ComponentModel)mapperModel);
            return ldapMapper.getUserAttributes().stream();
        }).toList();
        ArrayList<AttributeMetadata> metadatas = new ArrayList<AttributeMetadata>();
        for (String attrName : attributes) {
            AttributeMetadata attributeMetadata = UserProfileUtil.createAttributeMetadata((String)attrName, (UserProfileMetadata)metadata, (int)guiOrder++, (String)this.getModel().getName());
            if (attributeMetadata == null) continue;
            metadatas.add(attributeMetadata);
        }
        HashSet<String> metadataAttributes = new HashSet<String>(List.of("LDAP_ID", "LDAP_ENTRY_DN"));
        if (this.getKerberosConfig().isAllowKerberosAuthentication()) {
            metadataAttributes.add("KERBEROS_PRINCIPAL");
        }
        AttributeGroupMetadata metadataGroup = UserProfileUtil.lookupUserMetadataGroup((KeycloakSession)this.session);
        for (String attrName : metadataAttributes) {
            AttributeMetadata attributeAdded = UserProfileUtil.createAttributeMetadata((String)attrName, (UserProfileMetadata)metadata, (AttributeGroupMetadata)metadataGroup, (int)guiOrder++, (String)this.getModel().getName());
            if (attributeAdded == null) {
                --guiOrder;
                continue;
            }
            metadatas.add(attributeAdded);
        }
        if (this.getEditMode() == UserStorageProvider.EditMode.READ_ONLY) {
            Stream.concat(metadata.getAttributes().stream(), metadatas.stream()).forEach(attrMetadata -> attrMetadata.addWriteCondition(AttributeMetadata.ALWAYS_FALSE));
        }
        return metadatas;
    }
}

