/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.quarkus.runtime.configuration.mappers;

import io.smallrye.config.ConfigSourceInterceptorContext;
import io.smallrye.config.ConfigValue;
import java.util.Optional;
import org.keycloak.config.ExportOptions;
import org.keycloak.config.Option;
import org.keycloak.config.OptionBuilder;
import org.keycloak.config.OptionCategory;
import org.keycloak.quarkus.runtime.cli.PropertyException;
import org.keycloak.quarkus.runtime.configuration.Configuration;
import org.keycloak.quarkus.runtime.configuration.mappers.PropertyMapper;

public final class ExportPropertyMappers {
    private static final String EXPORTER_PROPERTY = "kc.spi-export-exporter";
    private static final String SINGLE_FILE = "singleFile";
    private static final String DIR = "dir";
    private static final Option<String> EXPORTER_PLACEHOLDER = new OptionBuilder("exporter", String.class).category(OptionCategory.EXPORT).description("Placeholder for determining export mode").buildTime(false).hidden().build();

    private ExportPropertyMappers() {
    }

    public static PropertyMapper<?>[] getMappers() {
        return new PropertyMapper[]{PropertyMapper.fromOption(EXPORTER_PLACEHOLDER).to(EXPORTER_PROPERTY).transformer(ExportPropertyMappers::transformExporter).paramLabel("file").build(), PropertyMapper.fromOption(ExportOptions.FILE).to("kc.spi-export-single-file-file").paramLabel("file").build(), PropertyMapper.fromOption(ExportOptions.DIR).to("kc.spi-export-dir-dir").paramLabel(DIR).build(), PropertyMapper.fromOption(ExportOptions.REALM).to("kc.spi-export-single-file-realm-name").isEnabled(ExportPropertyMappers::isSingleFileProvider).paramLabel("realm").build(), PropertyMapper.fromOption(ExportOptions.REALM).to("kc.spi-export-dir-realm-name").isEnabled(ExportPropertyMappers::isDirProvider).paramLabel("realm").build(), PropertyMapper.fromOption(ExportOptions.USERS).to("kc.spi-export-dir-users-export-strategy").isEnabled(ExportPropertyMappers::isDirProvider).paramLabel("strategy").build(), PropertyMapper.fromOption(ExportOptions.USERS_PER_FILE).to("kc.spi-export-dir-users-per-file").isEnabled(ExportPropertyMappers::isDirProvider).paramLabel("number").build()};
    }

    public static void validateConfig() {
        if (Configuration.getOptionalValue(EXPORTER_PROPERTY).isEmpty() && System.getProperty("keycloak.migration.provider") == null) {
            throw new PropertyException("Must specify either --dir or --file options.");
        }
    }

    private static boolean isSingleFileProvider() {
        return ExportPropertyMappers.isProvider(SINGLE_FILE);
    }

    private static boolean isDirProvider() {
        return ExportPropertyMappers.isProvider(DIR);
    }

    private static boolean isProvider(String provider) {
        return Configuration.getOptionalValue(EXPORTER_PROPERTY).filter(provider::equals).isPresent();
    }

    private static Optional<String> transformExporter(Optional<String> option, ConfigSourceInterceptorContext context) {
        ConfigValue exporter = context.proceed(EXPORTER_PROPERTY);
        if (exporter != null) {
            return Optional.of(exporter.getValue());
        }
        Optional<String> file = Configuration.getOptionalValue("kc.spi-export-single-file-file").map(f -> SINGLE_FILE);
        Optional<String> dir = Configuration.getOptionalValue("kc.spi-export-dir-dir").or(() -> Configuration.getOptionalValue("kc.dir")).map(f -> DIR);
        boolean xor = file.isPresent() ^ dir.isPresent();
        return xor ? file.or(() -> dir) : Optional.empty();
    }
}

