/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.saml.processing.core.saml.v2.util;

import java.security.cert.X509Certificate;
import java.util.List;
import java.util.function.Function;
import org.keycloak.dom.saml.v2.metadata.EntitiesDescriptorType;
import org.keycloak.dom.saml.v2.metadata.EntityDescriptorType;
import org.keycloak.dom.saml.v2.metadata.IDPSSODescriptorType;
import org.keycloak.dom.saml.v2.metadata.KeyDescriptorType;
import org.keycloak.dom.saml.v2.metadata.KeyTypes;
import org.keycloak.dom.saml.v2.metadata.SPSSODescriptorType;
import org.keycloak.dom.saml.v2.metadata.SSODescriptorType;
import org.keycloak.saml.common.constants.JBossSAMLURIConstants;
import org.keycloak.saml.common.exceptions.ConfigurationException;
import org.keycloak.saml.common.exceptions.ParsingException;
import org.keycloak.saml.common.exceptions.ProcessingException;
import org.keycloak.saml.common.util.StaxParserUtil;
import org.keycloak.saml.processing.core.parsers.saml.SAMLParser;
import org.keycloak.saml.processing.core.util.XMLSignatureUtil;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class SAMLMetadataUtil {
    public static X509Certificate getCertificate(KeyDescriptorType keyDescriptor) throws ConfigurationException, ProcessingException {
        X509Certificate cert = null;
        Element keyInfo = keyDescriptor.getKeyInfo();
        if (keyInfo != null) {
            NodeList x509DataNodes = keyInfo.getElementsByTagName("X509Data");
            if (x509DataNodes == null || x509DataNodes.getLength() == 0) {
                x509DataNodes = keyInfo.getElementsByTagNameNS(JBossSAMLURIConstants.XMLDSIG_NSURI.get(), "X509Data");
            }
            if (x509DataNodes == null || x509DataNodes.getLength() == 0) {
                x509DataNodes = keyInfo.getElementsByTagName("ds:X509Data");
            }
            if (x509DataNodes != null && x509DataNodes.getLength() > 0) {
                Node x509DataNode = x509DataNodes.item(0);
                NodeList children = x509DataNode.getChildNodes();
                int len = children != null ? children.getLength() : 0;
                for (int i = 0; i < len; ++i) {
                    Node nl = children.item(i);
                    if (!nl.getNodeName().contains("X509Certificate")) continue;
                    Node certNode = nl.getFirstChild();
                    String certNodeValue = certNode.getNodeValue();
                    cert = XMLSignatureUtil.getX509CertificateFromKeyInfoString(certNodeValue.replaceAll("\\s", ""));
                    break;
                }
            }
        }
        return cert;
    }

    public static X509Certificate getCertificate(KeyTypes use, SSODescriptorType ssoDescriptorType) {
        if (ssoDescriptorType != null) {
            for (KeyDescriptorType keyDescriptorType : ssoDescriptorType.getKeyDescriptor()) {
                KeyTypes keyUse = keyDescriptorType.getUse();
                if (keyUse != null && (use == null || !keyUse.value().equals(use.value()))) continue;
                try {
                    return SAMLMetadataUtil.getCertificate(keyDescriptorType);
                }
                catch (Exception e) {
                    throw new RuntimeException("Could not parse KeyDescriptor X509 certificate from metadata [" + ssoDescriptorType.getID() + "].");
                }
            }
        }
        return null;
    }

    public static EntityDescriptorType parseEntityDescriptorType(String descriptor) throws ParsingException {
        Object parsedObject = SAMLParser.getInstance().parse(StaxParserUtil.getXMLEventReader(descriptor));
        EntityDescriptorType entityType = EntitiesDescriptorType.class.isInstance(parsedObject) ? (EntityDescriptorType)((EntitiesDescriptorType)parsedObject).getEntityDescriptor().get(0) : (EntityDescriptorType)parsedObject;
        return entityType;
    }

    public static IDPSSODescriptorType locateIDPSSODescriptorType(EntityDescriptorType entityType) {
        return SAMLMetadataUtil.locateSSODescriptorType(entityType, SAMLMetadataUtil::getIDPSSODescriptorType);
    }

    public static SPSSODescriptorType locateSPSSODescriptorType(EntityDescriptorType entityType) {
        return SAMLMetadataUtil.locateSSODescriptorType(entityType, SAMLMetadataUtil::getSPSSODescriptorType);
    }

    private static IDPSSODescriptorType getIDPSSODescriptorType(EntityDescriptorType.EDTDescriptorChoiceType type) {
        return type.getIdpDescriptor();
    }

    private static SPSSODescriptorType getSPSSODescriptorType(EntityDescriptorType.EDTDescriptorChoiceType type) {
        return type.getSpDescriptor();
    }

    private static <T> T locateSSODescriptorType(EntityDescriptorType entityType, Function<EntityDescriptorType.EDTDescriptorChoiceType, T> getter) {
        List choiceType = entityType.getChoiceType();
        T descriptor = null;
        if (!choiceType.isEmpty()) {
            for (EntityDescriptorType.EDTChoiceType edtChoiceType : entityType.getChoiceType()) {
                List descriptors = edtChoiceType.getDescriptors();
                if (descriptors.isEmpty() || ((EntityDescriptorType.EDTDescriptorChoiceType)descriptors.get(0)).getIdpDescriptor() == null) continue;
                descriptor = getter.apply((EntityDescriptorType.EDTDescriptorChoiceType)descriptors.get(0));
            }
        }
        return descriptor;
    }
}

