/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.servlet.core;

import io.undertow.server.HttpServerExchange;
import io.undertow.servlet.api.ThreadSetupHandler;
import io.undertow.servlet.core.SecurityActions;

public class ContextClassLoaderSetupAction
implements ThreadSetupHandler {
    private final ClassLoader classLoader;

    public ContextClassLoaderSetupAction(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    @Override
    public <T, C> ThreadSetupHandler.Action<T, C> create(final ThreadSetupHandler.Action<T, C> action) {
        return new ThreadSetupHandler.Action<T, C>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public T call(HttpServerExchange exchange, C context) throws Exception {
                ClassLoader old = SecurityActions.getContextClassLoader();
                SecurityActions.setContextClassLoader(ContextClassLoaderSetupAction.this.classLoader);
                try {
                    Object t = action.call(exchange, context);
                    return t;
                }
                finally {
                    SecurityActions.setContextClassLoader(old);
                }
            }
        };
    }
}

