/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.xsite.events;

import java.lang.invoke.MethodHandles;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import net.jcip.annotations.GuardedBy;
import org.infinispan.commons.util.concurrent.CompletableFutures;
import org.infinispan.factories.ComponentRegistry;
import org.infinispan.factories.GlobalComponentRegistry;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.factories.annotations.Start;
import org.infinispan.factories.annotations.Stop;
import org.infinispan.factories.impl.ComponentRef;
import org.infinispan.factories.scopes.Scope;
import org.infinispan.factories.scopes.Scopes;
import org.infinispan.metrics.impl.MetricsRegistry;
import org.infinispan.notifications.Listener;
import org.infinispan.notifications.cachemanagerlistener.CacheManagerNotifier;
import org.infinispan.notifications.cachemanagerlistener.annotation.CacheStarted;
import org.infinispan.notifications.cachemanagerlistener.annotation.SiteViewChanged;
import org.infinispan.notifications.cachemanagerlistener.annotation.ViewChanged;
import org.infinispan.notifications.cachemanagerlistener.event.CacheStartedEvent;
import org.infinispan.notifications.cachemanagerlistener.event.SitesViewChangedEvent;
import org.infinispan.notifications.cachemanagerlistener.event.ViewChangedEvent;
import org.infinispan.remoting.inboundhandler.DeliverOrder;
import org.infinispan.remoting.transport.Transport;
import org.infinispan.util.ByteString;
import org.infinispan.util.concurrent.BlockingManager;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;
import org.infinispan.xsite.XSiteBackup;
import org.infinispan.xsite.XSiteCacheMapper;
import org.infinispan.xsite.XSiteNamedCache;
import org.infinispan.xsite.commands.XSiteLocalEventCommand;
import org.infinispan.xsite.commands.remote.XSiteRemoteEventCommand;
import org.infinispan.xsite.events.XSiteEvent;
import org.infinispan.xsite.events.XSiteEventSender;
import org.infinispan.xsite.events.XSiteEventType;
import org.infinispan.xsite.events.XSiteEventsManager;
import org.infinispan.xsite.events.XSiteViewMetrics;
import org.infinispan.xsite.statetransfer.XSiteStateTransferManager;

@Listener
@Scope(value=Scopes.GLOBAL)
public class XSiteEventsManagerImpl
implements XSiteEventsManager {
    private static final int[] BACK_OFF_DELAYS = new int[]{200, 500, 1000, 2000, 5000};
    private static final Log log = LogFactory.getLog(MethodHandles.lookup().lookupClass());
    @Inject
    Transport transport;
    @Inject
    CacheManagerNotifier notifier;
    @Inject
    GlobalComponentRegistry globalRegistry;
    @Inject
    XSiteCacheMapper xSiteCacheMapper;
    @Inject
    MetricsRegistry metricsRegistry;
    private Executor backOffExecutor;
    private final XSiteViewMetrics xSiteViewMetrics = new XSiteViewMetrics(this::getMetricsRegistry, this::getTransport);

    @Start
    public void start() {
        this.notifier.addListener(this);
    }

    @Stop
    public void stop() {
        this.notifier.removeListener(this);
        this.xSiteViewMetrics.stop();
    }

    @Inject
    public void createExecutor(BlockingManager blockingManager) {
        this.backOffExecutor = blockingManager.asExecutor("x-site-evt-backoff");
    }

    @Override
    public CompletionStage<Void> onLocalEvents(List<XSiteEvent> events) {
        log.debugf("Local events received: %s", events);
        try (XSiteEventSender holder = new XSiteEventSender(this::sendWithBackOff);){
            block11: for (XSiteEvent e : events) {
                switch (e.getType()) {
                    case SITE_CONNECTED: {
                        this.onRemoteSiteConnected(e.getSiteName(), holder);
                        continue block11;
                    }
                    case STATE_REQUEST: 
                    case INITIAL_STATE_REQUEST: {
                        this.onRemoteSiteStateRequest(e.getSiteName(), e.getCacheName(), e.getType() == XSiteEventType.INITIAL_STATE_REQUEST);
                        continue block11;
                    }
                }
                log.debugf("Unknown event received: %s", e);
            }
        }
        catch (Exception e) {
            return CompletableFuture.failedFuture(e);
        }
        return CompletableFutures.completedNull();
    }

    @Override
    public CompletionStage<Void> onRemoteEvents(List<XSiteEvent> events) {
        log.debugf("Remote events received: %s", events);
        if (this.transport.isCoordinator()) {
            return this.onLocalEvents(events);
        }
        try {
            log.debugf("Forwarding events to coordinator: %s", events);
            this.transport.sendTo(this.transport.getCoordinator(), new XSiteLocalEventCommand(events), DeliverOrder.PER_SENDER_NO_FC);
        }
        catch (Exception e) {
            return CompletableFuture.failedFuture(e);
        }
        return CompletableFutures.completedNull();
    }

    @SiteViewChanged
    public void onSiteViewChanged(SitesViewChangedEvent event) {
        this.xSiteViewMetrics.updateAllBasedOnNewView(event.getSites());
        if (!this.transport.isPrimaryRelayNode()) {
            return;
        }
        log.debugf("On site view changed event: %s", event);
        event.getJoiners().stream().filter(this::isRemoteSite).forEach(this::sendNewConnectionEvent);
    }

    @CacheStarted
    public void onCacheStarted(CacheStartedEvent event) {
        log.debugf("On cache started (is coordinator? %s): %s", this.transport.isCoordinator(), event.getCacheName());
        this.xSiteCacheMapper.sitesNameFromCache(event.getCacheName()).filter(this::isRemoteSite).forEach(this::registerMetricForSite);
        if (!this.transport.isCoordinator()) {
            return;
        }
        try (XSiteEventSender sender = new XSiteEventSender(this::sendWithBackOff);){
            this.xSiteCacheMapper.findRemoteCachesWithAsyncBackup(event.getCacheName()).forEach(i -> sender.addEventToSite(i.siteName(), XSiteEvent.createInitialStateRequest(this.localSite(), i.cacheName())));
        }
        catch (Exception e) {
            log.debugf(e, "Unable to send state request for cache %s", event.getCacheName());
        }
    }

    @ViewChanged
    public void onViewChanged(ViewChangedEvent event) {
        if (this.transport.isSiteCoordinator()) {
            this.xSiteViewMetrics.updateAllBasedOnNewView(this.transport.getSitesView());
        } else {
            this.xSiteViewMetrics.markAllUnknown();
        }
    }

    private void registerMetricForSite(String siteName) {
        Set<String> siteView = this.transport.isSiteCoordinator() ? this.transport.getSitesView() : null;
        this.xSiteViewMetrics.onNewSiteFound(siteName, siteView);
    }

    private void onRemoteSiteConnected(ByteString site, XSiteEventSender sender) {
        Iterator it = this.xSiteCacheMapper.remoteCachesFromSite(site).iterator();
        while (it.hasNext()) {
            sender.addEventToSite(site, XSiteEvent.createRequestState(this.localSite(), (ByteString)it.next()));
        }
    }

    private void sendNewConnectionEvent(String remoteSite) {
        XSiteRemoteEventCommand cmd = new XSiteRemoteEventCommand(List.of(XSiteEvent.createConnectEvent(this.localSite())));
        XSiteBackup backup = new XSiteBackup(remoteSite, false, 10000L);
        log.debugf("Sending connection event to %s: %s", backup, cmd);
        this.sendWithBackOff(backup, cmd);
    }

    private void onRemoteSiteStateRequest(ByteString remoteSite, ByteString localCacheName, boolean initialState) {
        ComponentRegistry cacheRegistry = this.globalRegistry.getNamedComponentRegistry(localCacheName);
        if (cacheRegistry == null) {
            log.debugf("State Transfer request from site '%s' and cache '%s' failed. Cache does no exist.", remoteSite, localCacheName);
            return;
        }
        ComponentRef<XSiteStateTransferManager> xsiteStateManagerRef = cacheRegistry.getXSiteStateTransferManager();
        if (!xsiteStateManagerRef.isRunning()) {
            log.debugf("State Transfer request from site '%s' and cache '%s' failed. Cache is not started.", remoteSite, localCacheName);
            return;
        }
        xsiteStateManagerRef.running().startAutomaticStateTransferTo(remoteSite, initialState);
    }

    private ByteString localSite() {
        return XSiteNamedCache.cachedByteString(this.transport.localSiteName());
    }

    private void sendWithBackOff(XSiteBackup backup, XSiteRemoteEventCommand cmd) {
        if (this.transport.localSiteName().equals(backup.getSiteName())) {
            return;
        }
        new BackOffSender(cmd, backup).run();
    }

    private Executor delayExecutor(int step) {
        return CompletableFuture.delayedExecutor(BACK_OFF_DELAYS[step], TimeUnit.MILLISECONDS, this.backOffExecutor);
    }

    private MetricsRegistry getMetricsRegistry() {
        return this.metricsRegistry;
    }

    private Transport getTransport() {
        return this.transport;
    }

    private boolean isRemoteSite(String siteName) {
        return !Objects.equals(siteName, this.transport.localSiteName());
    }

    private class BackOffSender
    implements Runnable,
    Function<Throwable, Void> {
        private final XSiteRemoteEventCommand cmd;
        private final XSiteBackup backup;
        @GuardedBy(value="this")
        private int backoffStep;

        private BackOffSender(XSiteRemoteEventCommand cmd, XSiteBackup backup) {
            this.cmd = cmd;
            this.backup = backup;
        }

        @Override
        public void run() {
            log.debugf("Sending %s to %s", this.cmd, this.backup);
            XSiteEventsManagerImpl.this.transport.backupRemotely(this.backup, this.cmd).exceptionally(this);
        }

        @Override
        public Void apply(Throwable throwable) {
            int step = this.nextBackOffStep();
            if (step >= BACK_OFF_DELAYS.length) {
                log.debugf(throwable, "Failed to send %s to %s", this.cmd, this.cmd);
                return null;
            }
            log.debugf(throwable, "Sending %s to %s with delay of %s milliseconds", this.cmd, this.backup, BACK_OFF_DELAYS[step]);
            XSiteEventsManagerImpl.this.delayExecutor(step).execute(this);
            return null;
        }

        private synchronized int nextBackOffStep() {
            return this.backoffStep++;
        }
    }
}

