/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.multimap.impl;

import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import org.infinispan.AdvancedCache;
import org.infinispan.Cache;
import org.infinispan.container.impl.InternalEntryFactory;
import org.infinispan.factories.ComponentRegistry;
import org.infinispan.functional.FunctionalMap;
import org.infinispan.functional.impl.FunctionalMapImpl;
import org.infinispan.functional.impl.ReadWriteMapImpl;
import org.infinispan.multimap.impl.SetBucket;
import org.infinispan.multimap.impl.function.set.SAddFunction;
import org.infinispan.multimap.impl.function.set.SGetFunction;
import org.infinispan.multimap.impl.function.set.SPopFunction;
import org.infinispan.multimap.impl.function.set.SRemoveFunction;
import org.infinispan.multimap.impl.function.set.SSetFunction;

public class EmbeddedSetCache<K, V> {
    public static final String ERR_KEY_CAN_T_BE_NULL = "key can't be null";
    public static final String ERR_VALUE_CAN_T_BE_NULL = "value can't be null";
    protected final FunctionalMap.ReadWriteMap<K, SetBucket<V>> readWriteMap;
    protected final AdvancedCache<K, SetBucket<V>> cache;
    protected final InternalEntryFactory entryFactory;

    public EmbeddedSetCache(Cache<K, SetBucket<V>> cache) {
        this.cache = cache.getAdvancedCache();
        FunctionalMapImpl functionalMap = FunctionalMapImpl.create(this.cache);
        this.readWriteMap = ReadWriteMapImpl.create((FunctionalMapImpl)functionalMap);
        this.entryFactory = (InternalEntryFactory)ComponentRegistry.of(this.cache).getInternalEntryFactory().running();
    }

    public CompletionStage<SetBucket<V>> get(K key) {
        return this.readWriteMap.eval(key, new SGetFunction());
    }

    public CompletionStage<Set<V>> getAsSet(K key) {
        return this.readWriteMap.eval(key, new SGetFunction()).thenApply(v -> v.toSet());
    }

    public CompletionStage<Long> add(K key, V value) {
        Objects.requireNonNull(key, ERR_KEY_CAN_T_BE_NULL);
        Objects.requireNonNull(value, ERR_VALUE_CAN_T_BE_NULL);
        return this.readWriteMap.eval(key, new SAddFunction(Arrays.asList(value)));
    }

    public CompletionStage<Long> add(K key, Collection<V> values) {
        Objects.requireNonNull(key, ERR_KEY_CAN_T_BE_NULL);
        Objects.requireNonNull(values, ERR_VALUE_CAN_T_BE_NULL);
        return this.readWriteMap.eval(key, new SAddFunction(values));
    }

    public CompletionStage<Long> remove(K key, V value) {
        Objects.requireNonNull(key, ERR_KEY_CAN_T_BE_NULL);
        Objects.requireNonNull(value, ERR_VALUE_CAN_T_BE_NULL);
        return this.readWriteMap.eval(key, new SRemoveFunction(Arrays.asList(value)));
    }

    public CompletionStage<Long> remove(K key, Collection<V> values) {
        Objects.requireNonNull(key, ERR_KEY_CAN_T_BE_NULL);
        Objects.requireNonNull(values, ERR_VALUE_CAN_T_BE_NULL);
        return this.readWriteMap.eval(key, new SRemoveFunction(values));
    }

    public CompletableFuture<Map<K, SetBucket<V>>> getAll(Set<K> keys) {
        Objects.requireNonNull(keys, ERR_KEY_CAN_T_BE_NULL);
        return this.cache.getAllAsync(keys);
    }

    public CompletionStage<Long> size(K key) {
        Objects.requireNonNull(key, ERR_KEY_CAN_T_BE_NULL);
        return this.cache.getAsync(key).thenApply(b -> b == null ? 0L : (long)b.size());
    }

    public CompletionStage<Long> set(K key, Collection<V> values) {
        Objects.requireNonNull(key, ERR_KEY_CAN_T_BE_NULL);
        Objects.requireNonNull(values, ERR_VALUE_CAN_T_BE_NULL);
        return this.readWriteMap.eval(key, new SSetFunction(values));
    }

    public CompletionStage<Collection<V>> pop(K key, Long count, boolean remove) {
        Objects.requireNonNull(key, ERR_KEY_CAN_T_BE_NULL);
        return this.readWriteMap.eval(key, new SPopFunction(count != null ? count : 1L, remove));
    }

    public CompletionStage<Boolean> contains(K key, V element) {
        Objects.requireNonNull(key, ERR_KEY_CAN_T_BE_NULL);
        return this.cache.getAsync(key).thenApply(b -> b == null ? false : b.contains(element));
    }
}

