/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.protocol.oidc.mappers;

import org.keycloak.Config;
import org.keycloak.models.ClientSessionContext;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.KeycloakSessionFactory;
import org.keycloak.models.ProtocolMapperModel;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserSessionModel;
import org.keycloak.models.utils.ModelToRepresentation;
import org.keycloak.models.utils.RepresentationToModel;
import org.keycloak.protocol.ProtocolMapper;
import org.keycloak.protocol.oidc.mappers.OIDCAttributeMapperHelper;
import org.keycloak.representations.AccessToken;
import org.keycloak.representations.AccessTokenResponse;
import org.keycloak.representations.IDToken;
import org.keycloak.representations.idm.ProtocolMapperRepresentation;

public abstract class AbstractOIDCProtocolMapper
implements ProtocolMapper {
    public static final String TOKEN_MAPPER_CATEGORY = "Token mapper";

    public String getProtocol() {
        return "openid-connect";
    }

    public void close() {
    }

    public final ProtocolMapper create(KeycloakSession session) {
        throw new RuntimeException("UNSUPPORTED METHOD");
    }

    public void init(Config.Scope config) {
    }

    public void postInit(KeycloakSessionFactory factory) {
    }

    public AccessToken transformUserInfoToken(AccessToken token, ProtocolMapperModel mappingModel, KeycloakSession session, UserSessionModel userSession, ClientSessionContext clientSessionCtx) {
        if (!OIDCAttributeMapperHelper.includeInUserInfo(mappingModel)) {
            return token;
        }
        this.setClaim((IDToken)token, mappingModel, userSession, session, clientSessionCtx);
        return token;
    }

    boolean getShouldUseLightweightToken(KeycloakSession session) {
        Object attributeValue = session.getAttribute("client.use.lightweight.access.token.enabled");
        return Boolean.parseBoolean(session.getContext().getClient().getAttribute("client.use.lightweight.access.token.enabled")) || attributeValue != null && (Boolean)attributeValue != false;
    }

    public AccessToken transformAccessToken(AccessToken token, ProtocolMapperModel mappingModel, KeycloakSession session, UserSessionModel userSession, ClientSessionContext clientSessionCtx) {
        boolean includeInAccessToken;
        boolean shouldUseLightweightToken = this.getShouldUseLightweightToken(session);
        boolean bl = includeInAccessToken = shouldUseLightweightToken ? OIDCAttributeMapperHelper.includeInLightweightAccessToken(mappingModel) : OIDCAttributeMapperHelper.includeInAccessToken(mappingModel);
        if (!includeInAccessToken) {
            return token;
        }
        this.setClaim((IDToken)token, mappingModel, userSession, session, clientSessionCtx);
        return token;
    }

    public IDToken transformIDToken(IDToken token, ProtocolMapperModel mappingModel, KeycloakSession session, UserSessionModel userSession, ClientSessionContext clientSessionCtx) {
        if (!OIDCAttributeMapperHelper.includeInIDToken(mappingModel)) {
            return token;
        }
        this.setClaim(token, mappingModel, userSession, session, clientSessionCtx);
        return token;
    }

    public AccessTokenResponse transformAccessTokenResponse(AccessTokenResponse accessTokenResponse, ProtocolMapperModel mappingModel, KeycloakSession session, UserSessionModel userSession, ClientSessionContext clientSessionCtx) {
        if (!OIDCAttributeMapperHelper.includeInAccessTokenResponse(mappingModel)) {
            return accessTokenResponse;
        }
        this.setClaim(accessTokenResponse, mappingModel, userSession, session, clientSessionCtx);
        return accessTokenResponse;
    }

    public AccessToken transformIntrospectionToken(AccessToken token, ProtocolMapperModel mappingModel, KeycloakSession session, UserSessionModel userSession, ClientSessionContext clientSessionCtx) {
        if (!OIDCAttributeMapperHelper.includeInIntrospection(mappingModel)) {
            return token;
        }
        this.setClaim((IDToken)token, mappingModel, userSession, session, clientSessionCtx);
        return token;
    }

    @Deprecated
    protected void setClaim(IDToken token, ProtocolMapperModel mappingModel, UserSessionModel userSession) {
    }

    protected void setClaim(IDToken token, ProtocolMapperModel mappingModel, UserSessionModel userSession, KeycloakSession keycloakSession, ClientSessionContext clientSessionCtx) {
        this.setClaim(token, mappingModel, userSession);
    }

    protected void setClaim(AccessTokenResponse accessTokenResponse, ProtocolMapperModel mappingModel, UserSessionModel userSession, KeycloakSession keycloakSession, ClientSessionContext clientSessionCtx) {
    }

    public ProtocolMapperModel getEffectiveModel(KeycloakSession session, RealmModel realm, ProtocolMapperModel protocolMapperModel) {
        ProtocolMapperModel copy = RepresentationToModel.toModel((ProtocolMapperRepresentation)ModelToRepresentation.toRepresentation((ProtocolMapperModel)protocolMapperModel));
        if (copy.getConfig().get("id.token.claim") != null) {
            copy.getConfig().put("userinfo.token.claim", String.valueOf(OIDCAttributeMapperHelper.includeInUserInfo(protocolMapperModel)));
        }
        if (copy.getConfig().get("access.token.claim") != null) {
            copy.getConfig().put("introspection.token.claim", String.valueOf(OIDCAttributeMapperHelper.includeInIntrospection(protocolMapperModel)));
        }
        return copy;
    }
}

