/*
 * Decompiled with CFR 0.152.
 */
package twitter4j;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import twitter4j.Authorization;
import twitter4j.HttpClient;
import twitter4j.HttpParameter;
import twitter4j.HttpResponse;
import twitter4j.HttpResponseEvent;
import twitter4j.HttpResponseListener;
import twitter4j.JSONImplFactory;
import twitter4j.JSONObject;
import twitter4j.ObjectFactory;
import twitter4j.RateLimitStatusEvent;
import twitter4j.TwitterAPIMonitor;
import twitter4j.TwitterException;
import twitter4j.v1.RateLimitStatus;

class APIResourceBase
implements HttpResponseListener {
    private final HttpClient http;
    protected final ObjectFactory factory;
    protected final String restBaseURL;
    protected static final HttpParameter includeMyRetweet = new HttpParameter("include_my_retweet", true);
    private final Authorization auth;
    private final boolean mbeanEnabled;
    private final String IMPLICIT_PARAMS_STR;
    private final HttpParameter[] IMPLICIT_PARAMS;
    private final List<Consumer<RateLimitStatusEvent>> rateLimitStatusListeners;
    private final List<Consumer<RateLimitStatusEvent>> rateLimitReachedListeners;

    APIResourceBase(HttpClient http, ObjectFactory factory, String restBaseURL, Authorization auth, boolean mbeanEnabled, HttpParameter[] IMPLICIT_PARAMS, String IMPLICIT_PARAMS_STR, List<Consumer<RateLimitStatusEvent>> rateLimitStatusListeners, List<Consumer<RateLimitStatusEvent>> rateLimitReachedListeners) {
        this.http = http;
        this.factory = factory;
        this.restBaseURL = restBaseURL;
        this.auth = auth;
        this.mbeanEnabled = mbeanEnabled;
        this.IMPLICIT_PARAMS = IMPLICIT_PARAMS;
        this.IMPLICIT_PARAMS_STR = IMPLICIT_PARAMS_STR;
        this.rateLimitStatusListeners = rateLimitStatusListeners;
        this.rateLimitReachedListeners = rateLimitReachedListeners;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected HttpResponse get(String url) throws TwitterException {
        if (this.IMPLICIT_PARAMS_STR.length() > 0) {
            url = url.contains("?") ? url + "&" + this.IMPLICIT_PARAMS_STR : url + "?" + this.IMPLICIT_PARAMS_STR;
        }
        if (!this.mbeanEnabled) {
            return this.http.get(url, null, this.auth, this);
        }
        HttpResponse response = null;
        long start = System.currentTimeMillis();
        try {
            response = this.http.get(url, null, this.auth, this);
        }
        finally {
            long elapsedTime = System.currentTimeMillis() - start;
            TwitterAPIMonitor.getInstance().methodCalled(url, elapsedTime, this.isOk(response));
        }
        return response;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected HttpResponse get(String url, HttpParameter ... params) throws TwitterException {
        if (!this.mbeanEnabled) {
            return this.http.get(url, this.mergeImplicitParams(params), this.auth, this);
        }
        HttpResponse response = null;
        long start = System.currentTimeMillis();
        try {
            response = this.http.get(url, this.mergeImplicitParams(params), this.auth, this);
        }
        finally {
            long elapsedTime = System.currentTimeMillis() - start;
            TwitterAPIMonitor.getInstance().methodCalled(url, elapsedTime, this.isOk(response));
        }
        return response;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected HttpResponse post(String url) throws TwitterException {
        if (!this.mbeanEnabled) {
            return this.http.post(url, this.IMPLICIT_PARAMS, this.auth, this);
        }
        HttpResponse response = null;
        long start = System.currentTimeMillis();
        try {
            response = this.http.post(url, this.IMPLICIT_PARAMS, this.auth, this);
        }
        finally {
            long elapsedTime = System.currentTimeMillis() - start;
            TwitterAPIMonitor.getInstance().methodCalled(url, elapsedTime, this.isOk(response));
        }
        return response;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected HttpResponse post(String url, HttpParameter ... params) throws TwitterException {
        if (!this.mbeanEnabled) {
            return this.http.post(url, this.mergeImplicitParams(params), this.auth, this);
        }
        HttpResponse response = null;
        long start = System.currentTimeMillis();
        try {
            response = this.http.post(url, this.mergeImplicitParams(params), this.auth, this);
        }
        finally {
            long elapsedTime = System.currentTimeMillis() - start;
            TwitterAPIMonitor.getInstance().methodCalled(url, elapsedTime, this.isOk(response));
        }
        return response;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected HttpResponse delete(String url) throws TwitterException {
        if (!this.mbeanEnabled) {
            return this.http.delete(url, null, this.auth, this);
        }
        HttpResponse response = null;
        long start = System.currentTimeMillis();
        try {
            response = this.http.delete(url, null, this.auth, this);
        }
        finally {
            long elapsedTime = System.currentTimeMillis() - start;
            TwitterAPIMonitor.getInstance().methodCalled(url, elapsedTime, this.isOk(response));
        }
        return response;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected HttpResponse post(String url, JSONObject json) throws TwitterException {
        if (!this.mbeanEnabled) {
            return this.http.post(url, new HttpParameter[]{new HttpParameter(json)}, this.auth, this);
        }
        HttpResponse response = null;
        long start = System.currentTimeMillis();
        try {
            response = this.http.post(url, new HttpParameter[]{new HttpParameter(json)}, this.auth, this);
        }
        catch (Throwable throwable) {
            long elapsedTime = System.currentTimeMillis() - start;
            TwitterAPIMonitor.getInstance().methodCalled(url, elapsedTime, this.isOk(response));
            throw throwable;
        }
        long elapsedTime = System.currentTimeMillis() - start;
        TwitterAPIMonitor.getInstance().methodCalled(url, elapsedTime, this.isOk(response));
        return response;
    }

    protected HttpParameter[] mergeParameters(HttpParameter[] params1, HttpParameter[] params2) {
        if (params1 != null && params2 != null) {
            HttpParameter[] params = new HttpParameter[params1.length + params2.length];
            System.arraycopy(params1, 0, params, 0, params1.length);
            System.arraycopy(params2, 0, params, params1.length, params2.length);
            return params;
        }
        if (null == params1 && null == params2) {
            return new HttpParameter[0];
        }
        if (params1 != null) {
            return params1;
        }
        return params2;
    }

    protected HttpParameter[] mergeParameters(HttpParameter[] params1, HttpParameter params2) {
        if (params1 != null && params2 != null) {
            HttpParameter[] params = new HttpParameter[params1.length + 1];
            System.arraycopy(params1, 0, params, 0, params1.length);
            params[params.length - 1] = params2;
            return params;
        }
        if (null == params1 && null == params2) {
            return new HttpParameter[0];
        }
        if (params1 != null) {
            return params1;
        }
        return new HttpParameter[]{params2};
    }

    protected HttpParameter[] mergeImplicitParams(HttpParameter ... params) {
        return this.mergeParameters(params, this.IMPLICIT_PARAMS);
    }

    protected boolean isOk(HttpResponse response) {
        return response != null && response.getStatusCode() < 300;
    }

    @Override
    public void httpResponseReceived(HttpResponseEvent event) {
        block8: {
            int statusCode;
            RateLimitStatus rateLimitStatus;
            if (this.rateLimitStatusListeners.size() == 0 && this.rateLimitReachedListeners.size() == 0) break block8;
            HttpResponse res = event.getResponse();
            TwitterException te = event.getTwitterException();
            if (te != null) {
                rateLimitStatus = te.getRateLimitStatus();
                statusCode = te.getStatusCode();
            } else {
                rateLimitStatus = JSONImplFactory.createRateLimitStatusFromResponseHeader(res);
                statusCode = res.getStatusCode();
            }
            if (rateLimitStatus != null) {
                RateLimitStatusEvent statusEvent = new RateLimitStatusEvent(this, rateLimitStatus, event.isAuthenticated());
                if (statusCode == 420 || statusCode == 503 || statusCode == 429) {
                    for (Consumer<RateLimitStatusEvent> listener : this.rateLimitStatusListeners) {
                        listener.accept(statusEvent);
                    }
                    for (Consumer<RateLimitStatusEvent> listener : this.rateLimitReachedListeners) {
                        listener.accept(statusEvent);
                    }
                } else {
                    for (Consumer<RateLimitStatusEvent> listener : this.rateLimitStatusListeners) {
                        listener.accept(statusEvent);
                    }
                }
            }
        }
    }

    protected void checkFileValidity(File image) throws TwitterException {
        if (!image.exists()) {
            throw new TwitterException(new FileNotFoundException(image + " is not found."));
        }
        if (!image.isFile()) {
            throw new TwitterException(new IOException(image + " is not a file."));
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        APIResourceBase that = (APIResourceBase)o;
        return this.mbeanEnabled == that.mbeanEnabled && Objects.equals(this.http, that.http) && Objects.equals(this.factory, that.factory) && Objects.equals(this.restBaseURL, that.restBaseURL) && Objects.equals(this.auth, that.auth) && Objects.equals(this.IMPLICIT_PARAMS_STR, that.IMPLICIT_PARAMS_STR) && Arrays.equals(this.IMPLICIT_PARAMS, that.IMPLICIT_PARAMS) && Objects.equals(this.rateLimitStatusListeners, that.rateLimitStatusListeners) && Objects.equals(this.rateLimitReachedListeners, that.rateLimitReachedListeners);
    }

    public int hashCode() {
        int result = Objects.hash(this.http, this.factory, this.restBaseURL, this.auth, this.mbeanEnabled, this.IMPLICIT_PARAMS_STR, this.rateLimitStatusListeners, this.rateLimitReachedListeners);
        result = 31 * result + Arrays.hashCode(this.IMPLICIT_PARAMS);
        return result;
    }
}

