/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.protocol.oidc.endpoints;

import jakarta.ws.rs.core.CacheControl;
import jakarta.ws.rs.core.Response;
import java.io.InputStream;
import org.keycloak.common.Version;
import org.keycloak.headers.SecurityHeadersProvider;
import org.keycloak.models.KeycloakSession;
import org.keycloak.services.util.CacheControlUtil;

public class IframeUtil {
    public static Response returnIframeFromResources(String fileName, String version, KeycloakSession session) {
        CacheControl cacheControl;
        if (version != null) {
            if (!version.equals(Version.RESOURCES_VERSION)) {
                return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
            }
            cacheControl = CacheControlUtil.getDefaultCacheControl();
        } else {
            cacheControl = CacheControlUtil.noCache();
        }
        InputStream resource = IframeUtil.class.getResourceAsStream(fileName);
        if (resource != null) {
            ((SecurityHeadersProvider)session.getProvider(SecurityHeadersProvider.class)).options().allowAnyFrameAncestor();
            return Response.ok((Object)resource).cacheControl(cacheControl).build();
        }
        return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
    }
}

