/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.authorization.jpa.entities;

import jakarta.persistence.Access;
import jakarta.persistence.AccessType;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.FetchType;
import jakarta.persistence.Id;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.NamedQueries;
import jakarta.persistence.NamedQuery;
import jakarta.persistence.Table;
import jakarta.persistence.Transient;
import jakarta.persistence.UniqueConstraint;
import org.hibernate.bytecode.enhance.internal.bytebuddy.InlineDirtyCheckerEqualsHelper;
import org.hibernate.bytecode.enhance.internal.tracker.DirtyTracker;
import org.hibernate.bytecode.enhance.internal.tracker.NoopCollectionTracker;
import org.hibernate.bytecode.enhance.internal.tracker.SimpleFieldTracker;
import org.hibernate.bytecode.enhance.spi.CollectionTracker;
import org.hibernate.bytecode.enhance.spi.EnhancementInfo;
import org.hibernate.engine.spi.EntityEntry;
import org.hibernate.engine.spi.ManagedEntity;
import org.hibernate.engine.spi.PersistentAttributeInterceptable;
import org.hibernate.engine.spi.PersistentAttributeInterceptor;
import org.hibernate.engine.spi.SelfDirtinessTracker;
import org.hibernate.internal.util.collections.ArrayHelper;
import org.keycloak.authorization.jpa.entities.PolicyEntity;
import org.keycloak.authorization.jpa.entities.ResourceEntity;
import org.keycloak.authorization.jpa.entities.ResourceServerEntity;
import org.keycloak.authorization.jpa.entities.ScopeEntity;

@Entity
@Table(name="RESOURCE_SERVER_PERM_TICKET", uniqueConstraints={@UniqueConstraint(columnNames={"OWNER", "REQUESTER", "RESOURCE_SERVER_ID", "RESOURCE_ID", "SCOPE_ID"})})
@NamedQueries(value={@NamedQuery(name="findPermissionIdByResource", query="select p.id from PermissionTicketEntity p inner join p.resource r where p.resourceServer.id = :serverId and (r.resourceServer = :serverId and r.id = :resourceId)"), @NamedQuery(name="findPermissionIdByScope", query="select p.id from PermissionTicketEntity p inner join p.scope s where p.resourceServer.id = :serverId and (s.resourceServer.id = :serverId and s.id = :scopeId)"), @NamedQuery(name="findPermissionTicketIdByServerId", query="select p.id from PermissionTicketEntity p where  p.resourceServer.id = :serverId "), @NamedQuery(name="findGrantedResources", query="select distinct(r.id) from ResourceEntity r inner join PermissionTicketEntity p on r.id = p.resource.id where p.grantedTimestamp is not null and p.requester = :requester order by r.id"), @NamedQuery(name="findGrantedResourcesByName", query="select distinct(r.id) from ResourceEntity r inner join PermissionTicketEntity p on r.id = p.resource.id where p.grantedTimestamp is not null and p.requester = :requester and lower(r.name) like :resourceName order by r.id"), @NamedQuery(name="findGrantedOwnerResources", query="select distinct(r.id) from ResourceEntity r inner join PermissionTicketEntity p on r.id = p.resource.id where p.grantedTimestamp is not null and p.owner = :owner order by r.id")})
@EnhancementInfo(version="6.2.18.Final")
public class PermissionTicketEntity
implements ManagedEntity,
PersistentAttributeInterceptable,
SelfDirtinessTracker {
    @Id
    @Column(name="ID", length=36)
    @Access(value=AccessType.PROPERTY)
    String id;
    @Column(name="OWNER")
    String owner;
    @Column(name="REQUESTER")
    String requester;
    @Column(name="CREATED_TIMESTAMP")
    Long createdTimestamp;
    @Column(name="GRANTED_TIMESTAMP")
    Long grantedTimestamp;
    @ManyToOne(optional=false, fetch=FetchType.LAZY)
    @JoinColumn(name="RESOURCE_ID")
    ResourceEntity resource;
    @ManyToOne(optional=true, fetch=FetchType.LAZY)
    @JoinColumn(name="SCOPE_ID")
    ScopeEntity scope;
    @ManyToOne(optional=false, fetch=FetchType.LAZY)
    @JoinColumn(name="RESOURCE_SERVER_ID")
    ResourceServerEntity resourceServer;
    @ManyToOne(optional=true, fetch=FetchType.LAZY)
    @JoinColumn(name="POLICY_ID")
    PolicyEntity policy;
    @Transient
    private transient EntityEntry $$_hibernate_entityEntryHolder;
    @Transient
    private transient ManagedEntity $$_hibernate_previousManagedEntity;
    @Transient
    private transient ManagedEntity $$_hibernate_nextManagedEntity;
    @Transient
    private transient PersistentAttributeInterceptor $$_hibernate_attributeInterceptor;
    @Transient
    private transient DirtyTracker $$_hibernate_tracker;

    public String getId() {
        return this.$$_hibernate_read_id();
    }

    public void setId(String id) {
        this.$$_hibernate_write_id(id);
    }

    public String getOwner() {
        return this.$$_hibernate_read_owner();
    }

    public void setOwner(String owner) {
        this.$$_hibernate_write_owner(owner);
    }

    public ResourceEntity getResource() {
        return this.$$_hibernate_read_resource();
    }

    public void setResource(ResourceEntity resource) {
        this.$$_hibernate_write_resource(resource);
    }

    public ScopeEntity getScope() {
        return this.$$_hibernate_read_scope();
    }

    public void setScope(ScopeEntity scope) {
        this.$$_hibernate_write_scope(scope);
    }

    public ResourceServerEntity getResourceServer() {
        return this.$$_hibernate_read_resourceServer();
    }

    public void setResourceServer(ResourceServerEntity resourceServer) {
        this.$$_hibernate_write_resourceServer(resourceServer);
    }

    public void setRequester(String requester) {
        this.$$_hibernate_write_requester(requester);
    }

    public String getRequester() {
        return this.$$_hibernate_read_requester();
    }

    public Long getCreatedTimestamp() {
        return this.$$_hibernate_read_createdTimestamp();
    }

    public void setCreatedTimestamp(Long createdTimestamp) {
        this.$$_hibernate_write_createdTimestamp(createdTimestamp);
    }

    public Long getGrantedTimestamp() {
        return this.$$_hibernate_read_grantedTimestamp();
    }

    public void setGrantedTimestamp(long grantedTimestamp) {
        this.$$_hibernate_write_grantedTimestamp(grantedTimestamp);
    }

    public boolean isGranted() {
        return this.$$_hibernate_read_grantedTimestamp() != null;
    }

    public PolicyEntity getPolicy() {
        return this.$$_hibernate_read_policy();
    }

    public void setPolicy(PolicyEntity policy) {
        this.$$_hibernate_write_policy(policy);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PermissionTicketEntity that = (PermissionTicketEntity)o;
        return this.getId().equals(that.getId());
    }

    public int hashCode() {
        return this.getId().hashCode();
    }

    public Object $$_hibernate_getEntityInstance() {
        return this;
    }

    public EntityEntry $$_hibernate_getEntityEntry() {
        return this.$$_hibernate_entityEntryHolder;
    }

    public void $$_hibernate_setEntityEntry(EntityEntry entityEntry) {
        this.$$_hibernate_entityEntryHolder = entityEntry;
    }

    public ManagedEntity $$_hibernate_getPreviousManagedEntity() {
        return this.$$_hibernate_previousManagedEntity;
    }

    public void $$_hibernate_setPreviousManagedEntity(ManagedEntity managedEntity) {
        this.$$_hibernate_previousManagedEntity = managedEntity;
    }

    public ManagedEntity $$_hibernate_getNextManagedEntity() {
        return this.$$_hibernate_nextManagedEntity;
    }

    public void $$_hibernate_setNextManagedEntity(ManagedEntity managedEntity) {
        this.$$_hibernate_nextManagedEntity = managedEntity;
    }

    public PersistentAttributeInterceptor $$_hibernate_getInterceptor() {
        return this.$$_hibernate_attributeInterceptor;
    }

    public void $$_hibernate_setInterceptor(PersistentAttributeInterceptor persistentAttributeInterceptor) {
        this.$$_hibernate_attributeInterceptor = persistentAttributeInterceptor;
    }

    public void $$_hibernate_trackChange(String string) {
        if (this.$$_hibernate_tracker == null) {
            this.$$_hibernate_tracker = new SimpleFieldTracker();
        }
        this.$$_hibernate_tracker.add(string);
    }

    public String[] $$_hibernate_getDirtyAttributes() {
        String[] stringArray = this;
        stringArray = null;
        stringArray = this.$$_hibernate_tracker == null ? ArrayHelper.EMPTY_STRING_ARRAY : this.$$_hibernate_tracker.get();
        return stringArray;
    }

    public boolean $$_hibernate_hasDirtyAttributes() {
        PermissionTicketEntity permissionTicketEntity = this;
        boolean bl = false;
        bl = this.$$_hibernate_tracker != null && !this.$$_hibernate_tracker.isEmpty();
        return bl;
    }

    public void $$_hibernate_clearDirtyAttributes() {
        if (this.$$_hibernate_tracker != null) {
            this.$$_hibernate_tracker.clear();
        }
    }

    public void $$_hibernate_suspendDirtyTracking(boolean bl) {
        if (this.$$_hibernate_tracker == null) {
            this.$$_hibernate_tracker = new SimpleFieldTracker();
        }
        this.$$_hibernate_tracker.suspend(bl);
    }

    public CollectionTracker $$_hibernate_getCollectionTracker() {
        PermissionTicketEntity permissionTicketEntity = this;
        permissionTicketEntity = null;
        permissionTicketEntity = NoopCollectionTracker.INSTANCE;
        return permissionTicketEntity;
    }

    public String $$_hibernate_read_id() {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.id = (String)this.$$_hibernate_getInterceptor().readObject((Object)this, "id", (Object)this.id);
        }
        return this.id;
    }

    public void $$_hibernate_write_id(String string) {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.id = (String)this.$$_hibernate_getInterceptor().writeObject((Object)this, "id", (Object)this.id, (Object)string);
            return;
        }
        this.id = string;
    }

    public String $$_hibernate_read_owner() {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.owner = (String)this.$$_hibernate_getInterceptor().readObject((Object)this, "owner", (Object)this.owner);
        }
        return this.owner;
    }

    public void $$_hibernate_write_owner(String string) {
        if (!InlineDirtyCheckerEqualsHelper.areEquals((PersistentAttributeInterceptable)this, (String)"owner", (Object)string, (Object)this.owner)) {
            this.$$_hibernate_trackChange("owner");
        }
        if (this.$$_hibernate_getInterceptor() != null) {
            this.owner = (String)this.$$_hibernate_getInterceptor().writeObject((Object)this, "owner", (Object)this.owner, (Object)string);
            return;
        }
        this.owner = string;
    }

    public String $$_hibernate_read_requester() {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.requester = (String)this.$$_hibernate_getInterceptor().readObject((Object)this, "requester", (Object)this.requester);
        }
        return this.requester;
    }

    public void $$_hibernate_write_requester(String string) {
        if (!InlineDirtyCheckerEqualsHelper.areEquals((PersistentAttributeInterceptable)this, (String)"requester", (Object)string, (Object)this.requester)) {
            this.$$_hibernate_trackChange("requester");
        }
        if (this.$$_hibernate_getInterceptor() != null) {
            this.requester = (String)this.$$_hibernate_getInterceptor().writeObject((Object)this, "requester", (Object)this.requester, (Object)string);
            return;
        }
        this.requester = string;
    }

    public Long $$_hibernate_read_createdTimestamp() {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.createdTimestamp = (Long)this.$$_hibernate_getInterceptor().readObject((Object)this, "createdTimestamp", (Object)this.createdTimestamp);
        }
        return this.createdTimestamp;
    }

    public void $$_hibernate_write_createdTimestamp(Long l) {
        if (!InlineDirtyCheckerEqualsHelper.areEquals((PersistentAttributeInterceptable)this, (String)"createdTimestamp", (Object)l, (Object)this.createdTimestamp)) {
            this.$$_hibernate_trackChange("createdTimestamp");
        }
        if (this.$$_hibernate_getInterceptor() != null) {
            this.createdTimestamp = (Long)this.$$_hibernate_getInterceptor().writeObject((Object)this, "createdTimestamp", (Object)this.createdTimestamp, (Object)l);
            return;
        }
        this.createdTimestamp = l;
    }

    public Long $$_hibernate_read_grantedTimestamp() {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.grantedTimestamp = (Long)this.$$_hibernate_getInterceptor().readObject((Object)this, "grantedTimestamp", (Object)this.grantedTimestamp);
        }
        return this.grantedTimestamp;
    }

    public void $$_hibernate_write_grantedTimestamp(Long l) {
        if (!InlineDirtyCheckerEqualsHelper.areEquals((PersistentAttributeInterceptable)this, (String)"grantedTimestamp", (Object)l, (Object)this.grantedTimestamp)) {
            this.$$_hibernate_trackChange("grantedTimestamp");
        }
        if (this.$$_hibernate_getInterceptor() != null) {
            this.grantedTimestamp = (Long)this.$$_hibernate_getInterceptor().writeObject((Object)this, "grantedTimestamp", (Object)this.grantedTimestamp, (Object)l);
            return;
        }
        this.grantedTimestamp = l;
    }

    public ResourceEntity $$_hibernate_read_resource() {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.resource = (ResourceEntity)this.$$_hibernate_getInterceptor().readObject((Object)this, "resource", (Object)this.resource);
        }
        return this.resource;
    }

    public void $$_hibernate_write_resource(ResourceEntity resourceEntity) {
        if (!InlineDirtyCheckerEqualsHelper.areEquals((PersistentAttributeInterceptable)this, (String)"resource", (Object)resourceEntity, (Object)this.resource)) {
            this.$$_hibernate_trackChange("resource");
        }
        if (this.$$_hibernate_getInterceptor() != null) {
            this.resource = (ResourceEntity)this.$$_hibernate_getInterceptor().writeObject((Object)this, "resource", (Object)this.resource, (Object)resourceEntity);
            return;
        }
        this.resource = resourceEntity;
    }

    public ScopeEntity $$_hibernate_read_scope() {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.scope = (ScopeEntity)this.$$_hibernate_getInterceptor().readObject((Object)this, "scope", (Object)this.scope);
        }
        return this.scope;
    }

    public void $$_hibernate_write_scope(ScopeEntity scopeEntity) {
        if (!InlineDirtyCheckerEqualsHelper.areEquals((PersistentAttributeInterceptable)this, (String)"scope", (Object)scopeEntity, (Object)this.scope)) {
            this.$$_hibernate_trackChange("scope");
        }
        if (this.$$_hibernate_getInterceptor() != null) {
            this.scope = (ScopeEntity)this.$$_hibernate_getInterceptor().writeObject((Object)this, "scope", (Object)this.scope, (Object)scopeEntity);
            return;
        }
        this.scope = scopeEntity;
    }

    public ResourceServerEntity $$_hibernate_read_resourceServer() {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.resourceServer = (ResourceServerEntity)this.$$_hibernate_getInterceptor().readObject((Object)this, "resourceServer", (Object)this.resourceServer);
        }
        return this.resourceServer;
    }

    public void $$_hibernate_write_resourceServer(ResourceServerEntity resourceServerEntity) {
        if (!InlineDirtyCheckerEqualsHelper.areEquals((PersistentAttributeInterceptable)this, (String)"resourceServer", (Object)resourceServerEntity, (Object)this.resourceServer)) {
            this.$$_hibernate_trackChange("resourceServer");
        }
        if (this.$$_hibernate_getInterceptor() != null) {
            this.resourceServer = (ResourceServerEntity)this.$$_hibernate_getInterceptor().writeObject((Object)this, "resourceServer", (Object)this.resourceServer, (Object)resourceServerEntity);
            return;
        }
        this.resourceServer = resourceServerEntity;
    }

    public PolicyEntity $$_hibernate_read_policy() {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.policy = (PolicyEntity)this.$$_hibernate_getInterceptor().readObject((Object)this, "policy", (Object)this.policy);
        }
        return this.policy;
    }

    public void $$_hibernate_write_policy(PolicyEntity policyEntity) {
        if (!InlineDirtyCheckerEqualsHelper.areEquals((PersistentAttributeInterceptable)this, (String)"policy", (Object)policyEntity, (Object)this.policy)) {
            this.$$_hibernate_trackChange("policy");
        }
        if (this.$$_hibernate_getInterceptor() != null) {
            this.policy = (PolicyEntity)this.$$_hibernate_getInterceptor().writeObject((Object)this, "policy", (Object)this.policy, (Object)policyEntity);
            return;
        }
        this.policy = policyEntity;
    }
}

