/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.sql.SQLException;
import oracle.jdbc.driver.InsensitiveScrollableResultSet;
import oracle.jdbc.driver.OracleStatement;
import oracle.jdbc.driver.PhysicalConnection;
import oracle.jdbc.internal.Monitor;

class SensitiveScrollableResultSet
extends InsensitiveScrollableResultSet {
    protected long beginLastFetchedIndex;
    protected long endLastFetchedIndex;

    SensitiveScrollableResultSet(PhysicalConnection conn, OracleStatement stmt) throws SQLException {
        super(conn, stmt);
        if (this.fetchedRowCount > 0L) {
            this.beginLastFetchedIndex = 0L;
            this.endLastFetchedIndex = this.fetchedRowCount - 1L;
        } else {
            this.beginLastFetchedIndex = -1L;
            this.endLastFetchedIndex = -1L;
        }
    }

    @Override
    public int getType() throws SQLException {
        this.ensureOpen("getType");
        return 1005;
    }

    @Override
    public boolean next() throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            if (super.next()) {
                this.handleRefetch();
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
    }

    @Override
    public boolean first() throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            if (super.first()) {
                this.handleRefetch();
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
    }

    @Override
    public boolean last() throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            if (super.last()) {
                this.handleRefetch();
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
    }

    @Override
    public boolean absolute(int row) throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            if (super.absolute(row)) {
                this.handleRefetch();
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
    }

    @Override
    public boolean relative(int rows) throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            if (super.relative(rows)) {
                this.handleRefetch();
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
    }

    @Override
    public boolean previous() throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            if (super.previous()) {
                this.handleRefetch();
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
    }

    @Override
    int refreshRows(long firstRow, int numberOfRows) throws SQLException {
        int n = super.refreshRows(firstRow, numberOfRows);
        if (n != 0) {
            this.beginLastFetchedIndex = firstRow;
            this.endLastFetchedIndex = firstRow + (long)n - 1L;
        }
        return n;
    }

    @Override
    void removeCurrentRowFromCache() throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            long index = this.currentRow;
            super.removeCurrentRowFromCache();
            if (!this.isEmptyResultSet()) {
                if (index < this.beginLastFetchedIndex) {
                    --this.beginLastFetchedIndex;
                }
                if (index <= this.endLastFetchedIndex) {
                    --this.endLastFetchedIndex;
                }
                if (!this.isAfterLast()) {
                    this.handleRefetch();
                }
            }
        }
    }

    protected boolean handleRefetch() throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            if (this.beginLastFetchedIndex <= this.currentRow && this.currentRow <= this.endLastFetchedIndex) {
                boolean bl = false;
                return bl;
            }
            this.refreshRow();
            boolean bl = true;
            return bl;
        }
    }
}

