/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.io.IOException;
import java.sql.SQLException;
import java.util.logging.Level;
import oracle.jdbc.diagnostics.SecurityLabel;
import oracle.jdbc.driver.CRC64;
import oracle.jdbc.driver.T4CConnection;
import oracle.jdbc.driver.T4CTTIoer11;

class T4CTTIoer19
extends T4CTTIoer11 {
    private static final String CLASS_NAME = T4CTTIoer19.class.getName();
    long oercn2;
    long oerrcd2;
    private static final String _Copyright_2014_Oracle_All_Rights_Reserved_ = null;
    public static final boolean TRACE = false;

    T4CTTIoer19(T4CConnection conn) {
        super(conn);
    }

    @Override
    void init() {
        super.init();
        this.oerrcd2 = 0L;
        this.oercn2 = 0L;
    }

    @Override
    int unmarshal() throws IOException, SQLException {
        return this.unmarshal(false);
    }

    @Override
    int unmarshal(boolean ignoreORA1403) throws IOException, SQLException {
        this.unmarshalAttributes();
        if (this.oerrcd2 != 0L) {
            if (this.oerrcd2 == 1403L && !ignoreORA1403) {
                this.unmarshalErrorMessageAndIgnore();
            } else {
                this.unmarshalErrorMessage();
            }
        }
        return this.currCursorID;
    }

    @Override
    void unmarshalAttributes() throws IOException, SQLException {
        super.unmarshalAttributes();
        this.oerrcd2 = this.meg.unmarshalUB4();
        this.oercn2 = this.meg.unmarshalSB8();
    }

    @Override
    void print() throws SQLException {
        super.print();
        if (this.oerrcd2 != 0L) {
            this.debugp(Level.FINEST, SecurityLabel.UNKNOWN, CLASS_NAME, "print", "**** Error Message: {0}", null, null, () -> {
                try {
                    return new Object[]{this.meg.conv.CharBytesToString(this.errorMsg, this.errorLength[0], true)};
                }
                catch (SQLException e) {
                    return new Object[]{"Got an exception generating the error message: " + e.getMessage()};
                }
            });
        }
    }

    @Override
    long getCurRowNumber() throws SQLException {
        return this.oercn2;
    }

    @Override
    long getRetCode() {
        return this.oerrcd2;
    }

    @Override
    long updateChecksum(long localCheckSum) throws SQLException {
        localCheckSum = super.updateChecksum(localCheckSum);
        localCheckSum = CRC64.updateChecksum(localCheckSum, this.oerrcd2);
        localCheckSum = CRC64.updateChecksum(localCheckSum, this.oercn2);
        return localCheckSum;
    }
}

