/*
 * Decompiled with CFR 0.152.
 */
package oracle.sql;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.SQLInput;
import java.sql.SQLOutput;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CompletionStage;
import java.util.logging.Level;
import oracle.jdbc.OracleTypeMetaData;
import oracle.jdbc.diagnostics.CommonDiagnosable;
import oracle.jdbc.diagnostics.SecurityLabel;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.internal.CompletionStageUtil;
import oracle.jdbc.internal.Monitor;
import oracle.jdbc.internal.OracleConnection;
import oracle.jdbc.internal.OracleStruct;
import oracle.jdbc.internal.OracleTypeMetaData;
import oracle.jdbc.oracore.OracleType;
import oracle.jdbc.oracore.OracleTypeADT;
import oracle.sql.ArrayDescriptor;
import oracle.sql.AttributeDescriptor;
import oracle.sql.ConcreteProxyUtil;
import oracle.sql.Datum;
import oracle.sql.OpaqueDescriptor;
import oracle.sql.OracleJdbc2SQLInput;
import oracle.sql.OracleSQLOutput;
import oracle.sql.SQLName;
import oracle.sql.STRUCT;
import oracle.sql.TypeDescriptor;

public class StructDescriptor
extends TypeDescriptor
implements OracleTypeMetaData.Struct,
Serializable {
    private static final String CLASS_NAME = StructDescriptor.class.getName();
    static final boolean DEBUG = false;
    static final long serialVersionUID = 1013921343538311063L;

    public static StructDescriptor createDescriptor(String name, Connection conn) throws SQLException {
        return StructDescriptor.createDescriptor(name, conn, false, false);
    }

    private static boolean isValidObject(String name, Connection conn) throws SQLException {
        oracle.jdbc.OracleConnection ojoc = (oracle.jdbc.OracleConnection)conn;
        while (ojoc.unwrap() != null) {
            ojoc = ojoc.unwrap();
        }
        TypeDescriptor td = TypeDescriptor.getTypeDescriptor(name, ojoc = ConcreteProxyUtil.unwrapConnectionProxy(ojoc));
        return td.getTypeCode() == 2002 || td.getTypeCode() == 2008;
    }

    private static CompletionStage<Boolean> isValidObjectAsync(String name, Connection conn) {
        oracle.jdbc.OracleConnection ojoc = (oracle.jdbc.OracleConnection)conn;
        while (ojoc.unwrap() != null) {
            ojoc = ojoc.unwrap();
        }
        ojoc = ConcreteProxyUtil.unwrapConnectionProxy(ojoc);
        return TypeDescriptor.getTypeDescriptorAsync(name, ojoc).thenApply(CompletionStageUtil.normalCompletionHandler(td -> td.getTypeCode() == 2002 || td.getTypeCode() == 2008));
    }

    public static StructDescriptor createDescriptor(String name, Connection conn, boolean recurse, boolean force) throws SQLException {
        if (name == null || name.length() == 0 || conn == null || !StructDescriptor.isValidObject(name, conn)) {
            throw (SQLException)DatabaseError.createSqlException(60, "Invalid arguments").fillInStackTrace();
        }
        conn = ConcreteProxyUtil.unwrapConnectionProxy((oracle.jdbc.OracleConnection)conn);
        SQLName sqlName = new SQLName(name, (oracle.jdbc.OracleConnection)conn);
        String qualifiedName = sqlName.getName();
        StructDescriptor descriptor = null;
        if (!force && (descriptor = (StructDescriptor)((oracle.jdbc.OracleConnection)conn).getDescriptor(qualifiedName)) == null) {
            short dbVersion = ((oracle.jdbc.OracleConnection)conn).physicalConnectionWithin().getVersionNumber();
            descriptor = dbVersion >= 12000 ? new StructDescriptor(name, conn) : new StructDescriptor(sqlName, conn);
            if (recurse) {
                descriptor.initNamesRecursively();
            }
            ((oracle.jdbc.OracleConnection)conn).putDescriptor(qualifiedName, descriptor);
        }
        return descriptor;
    }

    public static CompletionStage<StructDescriptor> createDescriptorAsync(String name, Connection conn) {
        if (name == null || name.length() == 0 || conn == null) {
            return CompletableFuture.failedStage((SQLException)DatabaseError.createSqlException(60, "Invalid arguments").fillInStackTrace());
        }
        return StructDescriptor.isValidObjectAsync(name, conn).thenCompose(CompletionStageUtil.normalCompletionHandler(isValid -> {
            SQLName sqlName;
            String qualifiedName;
            if (!isValid.booleanValue()) {
                throw (SQLException)DatabaseError.createSqlException(60, "Invalid arguments").fillInStackTrace();
            }
            oracle.jdbc.OracleConnection unwrappedConn = ConcreteProxyUtil.unwrapConnectionProxy((oracle.jdbc.OracleConnection)conn);
            StructDescriptor cachedDescriptor = (StructDescriptor)unwrappedConn.getDescriptor(qualifiedName = (sqlName = new SQLName(name, unwrappedConn)).getName());
            if (cachedDescriptor != null) {
                return CompletableFuture.completedStage(cachedDescriptor);
            }
            StructDescriptor descriptor = new StructDescriptor(name, unwrappedConn, false);
            return descriptor.initPicklerAsync().thenApply(CompletionStageUtil.normalCompletionHandler(nil -> {
                unwrappedConn.putDescriptor(qualifiedName, descriptor);
                return descriptor;
            }));
        }));
    }

    public static StructDescriptor createDescriptor(SQLName sqlName, Connection conn, boolean recurse, boolean force) throws SQLException {
        conn = ConcreteProxyUtil.unwrapConnectionProxy((oracle.jdbc.OracleConnection)conn);
        String qualifiedName = sqlName.getName();
        StructDescriptor descriptor = null;
        if (!force && (descriptor = (StructDescriptor)((oracle.jdbc.OracleConnection)conn).getDescriptor(qualifiedName)) == null) {
            descriptor = new StructDescriptor(sqlName, conn);
            if (recurse) {
                descriptor.initNamesRecursively();
            }
            ((oracle.jdbc.OracleConnection)conn).putDescriptor(qualifiedName, descriptor);
        }
        return descriptor;
    }

    public static StructDescriptor createDescriptor(SQLName name, Connection conn) throws SQLException {
        return StructDescriptor.createDescriptor(name, conn, false, false);
    }

    public static StructDescriptor createDescriptor(OracleTypeADT otype) throws SQLException {
        String fullName = otype.getFullName();
        oracle.jdbc.OracleConnection conn = otype.getConnection();
        StructDescriptor descriptor = (StructDescriptor)(conn = ConcreteProxyUtil.unwrapConnectionProxy(conn)).getDescriptor(fullName);
        if (descriptor == null) {
            SQLName sqlName = new SQLName(otype.getSchemaName(), otype.getSimpleName(), otype.getConnection());
            descriptor = new StructDescriptor(sqlName, otype, (Connection)conn);
            conn.putDescriptor(fullName, descriptor);
        }
        return descriptor;
    }

    public static StructDescriptor createDescriptor(SQLName sqlName, byte[] typoid, int version, byte[] tds, OracleConnection conn) throws SQLException {
        OracleTypeADT pickler = new OracleTypeADT(sqlName, typoid, version, tds, conn);
        return new StructDescriptor(sqlName, pickler, (Connection)conn);
    }

    public StructDescriptor(OracleTypeADT type, Connection conn) throws SQLException {
        super((short)108, type, conn);
    }

    public StructDescriptor(String name, Connection conn) throws SQLException {
        this(name, conn, true);
    }

    private StructDescriptor(String name, Connection conn, boolean constructInitialized) throws SQLException {
        super((short)108, name, conn);
        if (constructInitialized) {
            this.initPickler();
        }
    }

    public StructDescriptor(SQLName name, Connection conn) throws SQLException {
        super((short)108, name, conn);
        this.initPickler();
    }

    public StructDescriptor(SQLName name, OracleTypeADT type, Connection conn) throws SQLException {
        super((short)108, name, type, conn);
        this.toid = type.getTOID();
    }

    StructDescriptor(byte[] _toid, int _toidVersion, Connection conn) throws SQLException {
        super((short)108);
        this.toid = _toid;
        this.toidVersion = _toidVersion;
        this.setPhysicalConnectionOf(conn);
        this.initPickler();
    }

    StructDescriptor(AttributeDescriptor[] _ados, Connection conn) throws SQLException {
        super((short)108);
        this.attributesDescriptor = _ados;
        this.setPhysicalConnectionOf(conn);
        this.isTransient = true;
        this.initPickler();
        this.isInstanciable = Boolean.TRUE;
    }

    private void initPickler() throws SQLException {
        String typeName = null;
        try {
            if (this.isTransient) {
                typeName = this.getName();
                this.pickler = new OracleTypeADT(this.attributesDescriptor, this.connection);
            } else {
                typeName = this.typeNameByUser == null ? this.getName() : this.typeNameByUser;
                this.pickler = new OracleTypeADT(typeName, (Connection)this.connection);
                ((OracleTypeADT)this.pickler).init(this.connection);
                this.toid = ((OracleTypeADT)this.pickler).getTOID();
            }
            this.pickler.setDescriptor(this);
        }
        catch (SQLException sqlException) {
            throw sqlException;
        }
        catch (Exception e) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 60, "Unable to resolve type \"" + typeName + "\"").fillInStackTrace();
        }
    }

    private CompletionStage<Void> initPicklerAsync() {
        CompletionStage<Object> initializationStage;
        String typeName = null;
        try {
            if (this.isTransient) {
                typeName = this.getName();
                this.pickler = new OracleTypeADT(this.attributesDescriptor, this.connection);
                this.pickler.setDescriptor(this);
                return CompletionStageUtil.VOID_COMPLETED_FUTURE;
            }
            typeName = this.typeNameByUser == null ? this.getName() : this.typeNameByUser;
            this.pickler = new OracleTypeADT(typeName, (Connection)this.connection);
            initializationStage = ((OracleTypeADT)this.pickler).initAsync(this.connection).thenApply(CompletionStageUtil.normalCompletionHandler(nil -> {
                this.toid = ((OracleTypeADT)this.pickler).getTOID();
                this.pickler.setDescriptor(this);
                return nil;
            }));
        }
        catch (Exception e) {
            initializationStage = CompletableFuture.failedStage(e);
        }
        return initializationStage.exceptionally(completionError -> {
            SQLException thrownException;
            Throwable error = CompletionStageUtil.unwrapCompletionException(completionError);
            this.debug(Level.FINEST, SecurityLabel.UNKNOWN, CLASS_NAME, "initPicklerAsync", "exception caught and thrown : {0}", (String)null, error, (Object)error.getMessage());
            if (error instanceof SQLException) {
                thrownException = (SQLException)error;
            } else {
                try {
                    thrownException = (SQLException)DatabaseError.createSqlException(60, "Unable to resolve type \"" + this.getName() + "\"").fillInStackTrace();
                }
                catch (SQLException getNameException) {
                    throw new CompletionException(getNameException);
                }
            }
            throw new CompletionException(thrownException);
        });
    }

    @Override
    public OracleTypeMetaData.Kind getKind() {
        return OracleTypeMetaData.Kind.STRUCT;
    }

    @Override
    public int getTypeCode() throws SQLException {
        int typeCode = this.getOracleTypeADT().getTypeCode();
        return typeCode;
    }

    @Override
    public int getTypeVersion() throws SQLException {
        int typeVersion = this.getOracleTypeADT().getTypeVersion();
        return typeVersion;
    }

    void setAttributesDescriptor(AttributeDescriptor[] _attributesDescriptor) {
        this.attributesDescriptor = _attributesDescriptor;
    }

    public AttributeDescriptor[] getAttributesDescriptor() {
        return this.attributesDescriptor;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public byte[] toBytes(OracleStruct s, Datum sDatum, boolean keepLocalCopy) throws SQLException {
        byte[] bytes = s.shareBytes();
        if (bytes == null) {
            if (s.getDatumArray() != null) {
                bytes = this.pickler.linearize(sDatum);
                if (keepLocalCopy) return bytes;
                s.setShareBytes(null);
                return bytes;
            } else {
                if (s.getObjectArray() == null) throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 1).fillInStackTrace();
                Datum[] datumArray = this.toOracleArray(s.getObjectArray());
                if (datumArray == null) {
                    s.setNullDatumArray();
                } else {
                    s.setDatumArray(datumArray);
                }
                bytes = this.pickler.linearize(sDatum);
                if (keepLocalCopy) return bytes;
                s.setNullDatumArray();
                s.setShareBytes(null);
            }
            return bytes;
        } else {
            if (s.getImageLength() == 0L) return bytes;
            if (s.getImageOffset() == 0L) {
                if (s.getImageLength() == (long)bytes.length) return bytes;
            }
            byte[] image = new byte[(int)s.getImageLength()];
            System.arraycopy(bytes, (int)s.getImageOffset(), image, 0, (int)s.getImageLength());
            s.setImage(image, 0L, 0L);
            return image;
        }
    }

    public Datum[] toOracleArray(OracleStruct s, Datum sDatum, boolean keepLocalCopy) throws SQLException {
        Datum[] datumArray = s.getDatumArray();
        Datum[] ret = null;
        if (datumArray == null) {
            if (s.getObjectArray() != null) {
                datumArray = this.toOracleArray(s.getObjectArray());
            } else if (s.shareBytes() != null) {
                if ((s.shareBytes()[0] & 0x80) <= 0 && ((OracleTypeADT)this.pickler).isEmbeddedADT()) {
                    this.pickler = OracleTypeADT.shallowClone((OracleTypeADT)this.pickler);
                }
                this.pickler.unlinearize(s.shareBytes(), s.getImageOffset(), sDatum, 1, null);
                datumArray = s.getDatumArray();
                if (!keepLocalCopy) {
                    s.setNullDatumArray();
                }
            } else {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 1).fillInStackTrace();
            }
        }
        if (keepLocalCopy) {
            if (datumArray == null) {
                s.setNullDatumArray();
            } else {
                s.setDatumArray(datumArray);
            }
            ret = (Datum[])datumArray.clone();
        } else {
            ret = datumArray;
        }
        return ret;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Object[] toArray(OracleStruct s, Datum sDatum, Map map, boolean saveLocalCopy) throws SQLException {
        Object[] objArray = null;
        if (s.getObjectArray() != null) return (Object[])s.getObjectArray().clone();
        if (s.getDatumArray() != null) {
            Datum[] datumArray = s.getDatumArray();
            objArray = new Object[datumArray.length];
            int i = 0;
            while (i < datumArray.length) {
                if (datumArray[i] != null) {
                    objArray[i] = datumArray[i] instanceof STRUCT ? ((STRUCT)datumArray[i]).toJdbc(map) : datumArray[i].toJdbc();
                }
                ++i;
            }
            return objArray;
        }
        if (s.shareBytes() == null) throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 1).fillInStackTrace();
        if ((s.shareBytes()[0] & 0x80) <= 0 && ((OracleTypeADT)this.pickler).isEmbeddedADT()) {
            this.pickler = OracleTypeADT.shallowClone((OracleTypeADT)this.pickler);
        }
        this.pickler.unlinearize(s.shareBytes(), s.getImageOffset(), sDatum, 2, map);
        objArray = s.getObjectArray();
        s.setNullObjectArray();
        return objArray;
    }

    @Override
    public int getLength() throws SQLException {
        return this.getFieldTypes().length;
    }

    public OracleTypeADT getOracleTypeADT() throws SQLException {
        if (this.pickler == null) {
            this.initPickler();
        }
        OracleTypeADT ret = (OracleTypeADT)this.pickler;
        return ret;
    }

    private OracleType[] getFieldTypes() throws SQLException {
        return ((OracleTypeADT)this.pickler).getAttrTypes();
    }

    public SQLInput toJdbc2SQLInput(STRUCT s, Map map) throws SQLException {
        return this.toJdbc2SQLInput(s, s, map);
    }

    public SQLInput toJdbc2SQLInput(OracleStruct s, Datum sDatum, Map map) throws SQLException {
        return new OracleJdbc2SQLInput(this.toOracleArray(s, sDatum, false), map, this.connection);
    }

    public SQLOutput toJdbc2SQLOutput() throws SQLException {
        return new OracleSQLOutput(this, this.connection);
    }

    public Datum[] toOracleArray(Object[] attributes) throws SQLException {
        Datum[] datum = null;
        if (attributes != null) {
            OracleType[] oracleTypes = this.getFieldTypes();
            int oracleTypesLen = oracleTypes.length;
            if (attributes.length > oracleTypesLen) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 49, null).fillInStackTrace();
            }
            datum = new Datum[attributes.length];
            OracleConnection iconn = this.connection;
            for (int i = 0; i < attributes.length; ++i) {
                datum[i] = oracleTypes[i].toDatumInternal(attributes[i], iconn);
            }
        }
        return datum;
    }

    public Datum[] toOracleArray(Map attributes) throws SQLException {
        Datum[] datum = null;
        int nonNullAttrCount = 0;
        if (attributes != null) {
            OracleType[] oracleTypes = this.getFieldTypes();
            int oracleTypesLen = oracleTypes.length;
            int attributesSize = attributes.size();
            datum = new Datum[oracleTypesLen];
            OracleConnection iconn = this.connection;
            for (int i = 0; i < oracleTypesLen; ++i) {
                Object o = attributes.get(((OracleTypeADT)this.pickler).getAttributeName(i + 1));
                datum[i] = oracleTypes[i].toDatum(o, iconn);
                if (o == null && !attributes.containsKey(((OracleTypeADT)this.pickler).getAttributeName(i + 1))) continue;
                ++nonNullAttrCount;
            }
            if (nonNullAttrCount < attributesSize) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 68, null).fillInStackTrace();
            }
        }
        return datum;
    }

    @Override
    public ResultSetMetaData getMetaData() throws SQLException {
        return this.connection.newStructMetaData(this);
    }

    @Override
    public boolean isFinalType() throws SQLException {
        return this.getOracleTypeADT().isFinalType();
    }

    @Override
    public boolean isSubtype() throws SQLException {
        return this.getOracleTypeADT().isSubType();
    }

    @Override
    public boolean isInHierarchyOf(String checkThisName) throws SQLException {
        StructDescriptor currentDescriptor = this;
        String currentName = currentDescriptor.getName();
        boolean ret = false;
        if (checkThisName.equals(currentName)) {
            ret = true;
        } else {
            while (true) {
                if ((currentName = currentDescriptor.getSupertypeName()) == null) {
                    ret = false;
                    break;
                }
                if (checkThisName.equals(currentName)) {
                    ret = true;
                    break;
                }
                currentDescriptor = StructDescriptor.createDescriptor(currentName, (Connection)this.connection);
            }
        }
        return ret;
    }

    @Override
    public boolean isInstantiable() throws SQLException {
        if (this.isInstanciable == null) {
            this.isInstanciable = this.getOracleTypeADT().isInstanciable();
        }
        return this.isInstanciable;
    }

    public boolean isJavaObject() throws SQLException {
        return this.getOracleTypeADT().isJavaObject();
    }

    @Override
    public String getSupertypeName() throws SQLException {
        String ret = null;
        if (this.isSubtype()) {
            if (this.supertype == null) {
                this.supertype = this.getOracleTypeADT().getSuperTypeName();
            }
            ret = this.supertype;
        }
        return ret;
    }

    @Override
    public int getLocalAttributeCount() throws SQLException {
        int ret;
        if (!this.isSubtype()) {
            ret = this.getOracleTypeADT().getAttrTypes().length;
        } else {
            if (this.numLocalAttrs == -1) {
                this.numLocalAttrs = this.getOracleTypeADT().getNumberOfLocalAttributes();
            }
            ret = this.numLocalAttrs;
        }
        return ret;
    }

    @Override
    public String[] getSubtypeNames() throws SQLException {
        if (this.subtypes == null) {
            this.subtypes = this.getOracleTypeADT().getSubtypeNames();
        }
        return this.subtypes;
    }

    public String getJavaClassName() throws SQLException {
        String ret = null;
        if (this.isJavaObject()) {
            ret = StructDescriptor.getJavaObjectClassName(this.connection, this);
        }
        return ret;
    }

    public String getAttributeJavaName(int column) throws SQLException {
        String ret = null;
        if (this.isJavaObject()) {
            if (this.attrJavaNames == null) {
                this.initMetaData3();
            }
            ret = this.attrJavaNames[column];
        }
        return ret;
    }

    public String[] getAttributeJavaNames() throws SQLException {
        String[] ret = null;
        if (this.isJavaObject()) {
            if (this.attrJavaNames == null) {
                this.initMetaData3();
            }
            ret = this.attrJavaNames;
        } else {
            ret = new String[]{};
        }
        return ret;
    }

    public String getLanguage() throws SQLException {
        String ret = null;
        ret = this.isJavaObject() ? "JAVA" : "SQL";
        return ret;
    }

    public static String getJavaObjectClassName(Connection conn, StructDescriptor desc) throws SQLException {
        return StructDescriptor.getJavaObjectClassName(conn, desc.getSchemaName(), desc.getTypeName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getJavaObjectClassName(Connection conn, String schema, String typename) throws SQLException {
        String ret;
        block9: {
            PreparedStatement pstmt = null;
            ResultSet rset = null;
            ret = null;
            OracleConnection physicalConnection = ((oracle.jdbc.OracleConnection)conn).physicalConnectionWithin();
            physicalConnection.beginNonRequestCalls();
            if (((oracle.jdbc.OracleConnection)conn).isProxySession()) {
                schema = TypeDescriptor.convToUpperCase(schema);
            }
            try {
                pstmt = conn.prepareStatement("select external_name from all_sqlj_types where owner = :1 and type_name = :2");
                pstmt.setString(1, schema);
                pstmt.setString(2, typename);
                rset = pstmt.executeQuery();
                if (rset.next()) {
                    ret = rset.getString(1);
                    break block9;
                }
                throw (SQLException)DatabaseError.createSqlException(100).fillInStackTrace();
            }
            catch (SQLException e) {
                CommonDiagnosable.getInstance().debug(Level.FINEST, SecurityLabel.UNKNOWN, CLASS_NAME, "getJavaObjectClassName", "SQL exception caught : {0} ", (String)null, e, (Object)e.getMessage());
            }
            finally {
                if (rset != null) {
                    rset.close();
                }
                if (pstmt != null) {
                    pstmt.close();
                }
                physicalConnection.endNonRequestCalls();
            }
        }
        return ret;
    }

    public String descType() throws SQLException {
        StringBuffer strBuf = new StringBuffer();
        return this.descType(strBuf, 0);
    }

    String descType(StringBuffer strBuf, int level) throws SQLException {
        Object level_one = "";
        for (int i = 0; i < level; ++i) {
            level_one = (String)level_one + "  ";
        }
        String level_two = (String)level_one + "  ";
        strBuf.append((String)level_one);
        strBuf.append(this.getTypeName());
        strBuf.append("\n");
        strBuf.append((String)level_one);
        strBuf.append("Subtype=" + this.getOracleTypeADT().isSubType());
        strBuf.append(" JavaObject=" + this.getOracleTypeADT().isJavaObject());
        strBuf.append(" FinalType=" + this.getOracleTypeADT().isFinalType());
        strBuf.append("\n");
        ResultSetMetaData md = this.getMetaData();
        int numCols = md.getColumnCount();
        for (int i = 0; i < numCols; ++i) {
            int tcode = md.getColumnType(i + 1);
            if (tcode == 2002 || tcode == 2008) {
                StructDescriptor adt_desc = StructDescriptor.createDescriptor(md.getColumnTypeName(i + 1), (Connection)this.connection);
                adt_desc.descType(strBuf, level + 1);
                continue;
            }
            if (tcode == 2003) {
                ArrayDescriptor array_desc = ArrayDescriptor.createDescriptor(md.getColumnTypeName(i + 1), (Connection)this.connection);
                array_desc.descType(strBuf, level + 1);
                continue;
            }
            if (tcode == 2007) {
                OpaqueDescriptor opq_desc = OpaqueDescriptor.createDescriptor(md.getColumnTypeName(i + 1), (Connection)this.connection);
                opq_desc.descType(strBuf, level + 1);
                continue;
            }
            strBuf.append(level_two);
            strBuf.append(md.getColumnTypeName(i + 1));
            strBuf.append("\n");
        }
        return strBuf.substring(0);
    }

    public byte[] toBytes(Object[] attributes) throws SQLException {
        Datum[] datums = this.toOracleArray(attributes);
        return this.toBytes(datums);
    }

    public byte[] toBytes(Datum[] attributes) throws SQLException {
        STRUCT s = new STRUCT(this, (byte[])null, this.connection);
        s.setDatumArray(attributes);
        return this.pickler.linearize(s);
    }

    public Datum[] toArray(Object[] attributes) throws SQLException {
        return this.toOracleArray(attributes);
    }

    public Datum[] toArray(byte[] bytes) throws SQLException {
        STRUCT s = new STRUCT(this, bytes, this.connection);
        return this.toOracleArray(s, s, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initMetaData3() throws SQLException {
        block12: {
            try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
                if (this.attrJavaNames != null) break block12;
                this.connection.beginNonRequestCalls();
                String[] temp_attrJavaNames = null;
                PreparedStatement pstmt = null;
                ResultSet rset = null;
                try {
                    pstmt = this.connection.prepareStatement("select EXTERNAL_ATTR_NAME, ATTR_NO from all_sqlj_type_attrs where owner = :1 and type_name = :2 order by ATTR_NO");
                    pstmt.setString(1, this.getSchemaName());
                    pstmt.setString(2, this.getTypeName());
                    rset = pstmt.executeQuery();
                    temp_attrJavaNames = new String[this.getOracleTypeADT().getAttrTypes().length];
                    int i = 0;
                    while (rset.next()) {
                        temp_attrJavaNames[rset.getInt((int)2) - 1] = rset.getString(1);
                        ++i;
                    }
                }
                finally {
                    if (rset != null) {
                        rset.close();
                    }
                    if (pstmt != null) {
                        pstmt.close();
                    }
                    this.connection.endNonRequestCalls();
                }
                this.attrJavaNames = temp_attrJavaNames;
            }
        }
    }

    @Override
    String tagName() {
        return "StructDescriptor";
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        this.debug(Level.FINEST, SecurityLabel.UNKNOWN, CLASS_NAME, "writeObject", "do nothing", null, null);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        this.debug(Level.FINEST, SecurityLabel.UNKNOWN, CLASS_NAME, "readObject", "do nothing", null, null);
    }
}

