/*
 * Decompiled with CFR 0.152.
 */
package com.webauthn4j.validator;

import com.webauthn4j.data.AuthenticatorTransport;
import com.webauthn4j.data.attestation.AttestationObject;
import com.webauthn4j.data.client.CollectedClientData;
import com.webauthn4j.data.extension.client.AuthenticationExtensionsClientOutputs;
import com.webauthn4j.data.extension.client.RegistrationExtensionClientOutput;
import com.webauthn4j.server.ServerProperty;
import com.webauthn4j.util.ArrayUtil;
import com.webauthn4j.util.AssertUtil;
import com.webauthn4j.util.CollectionUtil;
import com.webauthn4j.util.MessageDigestUtil;
import com.webauthn4j.validator.CoreRegistrationObject;
import java.time.Instant;
import java.util.Arrays;
import java.util.Objects;
import java.util.Set;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public class RegistrationObject
extends CoreRegistrationObject {
    private final CollectedClientData collectedClientData;
    private final byte[] collectedClientDataBytes;
    private final AuthenticationExtensionsClientOutputs<RegistrationExtensionClientOutput> clientExtensions;
    private final Set<AuthenticatorTransport> transports;

    public RegistrationObject(@NonNull AttestationObject attestationObject, @NonNull byte[] attestationObjectBytes, @NonNull CollectedClientData collectedClientData, @NonNull byte[] collectedClientDataBytes, @Nullable AuthenticationExtensionsClientOutputs<RegistrationExtensionClientOutput> clientExtensions, @Nullable Set<AuthenticatorTransport> transports, @NonNull ServerProperty serverProperty, @NonNull Instant timestamp) {
        super(attestationObject, attestationObjectBytes, MessageDigestUtil.createSHA256().digest(collectedClientDataBytes), serverProperty, timestamp);
        AssertUtil.notNull((Object)collectedClientData, (String)"collectedClientData must not be null");
        AssertUtil.notNull((Object)collectedClientDataBytes, (String)"collectedClientDataBytes must not be null");
        this.collectedClientData = collectedClientData;
        this.collectedClientDataBytes = ArrayUtil.clone((byte[])collectedClientDataBytes);
        this.clientExtensions = clientExtensions;
        this.transports = CollectionUtil.unmodifiableSet(transports);
    }

    public RegistrationObject(@NonNull AttestationObject attestationObject, @NonNull byte[] attestationObjectBytes, @NonNull CollectedClientData collectedClientData, @NonNull byte[] collectedClientDataBytes, @Nullable AuthenticationExtensionsClientOutputs<RegistrationExtensionClientOutput> clientExtensions, @Nullable Set<AuthenticatorTransport> transports, @NonNull ServerProperty serverProperty) {
        this(attestationObject, attestationObjectBytes, collectedClientData, collectedClientDataBytes, clientExtensions, transports, serverProperty, Instant.now());
    }

    public @NonNull CollectedClientData getCollectedClientData() {
        return this.collectedClientData;
    }

    public @NonNull byte[] getCollectedClientDataBytes() {
        return ArrayUtil.clone((byte[])this.collectedClientDataBytes);
    }

    public @Nullable AuthenticationExtensionsClientOutputs<RegistrationExtensionClientOutput> getClientExtensions() {
        return this.clientExtensions;
    }

    public @Nullable Set<AuthenticatorTransport> getTransports() {
        return this.transports;
    }

    @Override
    public @NonNull ServerProperty getServerProperty() {
        return (ServerProperty)super.getServerProperty();
    }

    @Override
    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        RegistrationObject that = (RegistrationObject)o;
        return Objects.equals(this.collectedClientData, that.collectedClientData) && Arrays.equals(this.collectedClientDataBytes, that.collectedClientDataBytes) && Objects.equals(this.clientExtensions, that.clientExtensions) && Objects.equals(this.transports, that.transports);
    }

    @Override
    public int hashCode() {
        int result = Objects.hash(super.hashCode(), this.collectedClientData, this.clientExtensions, this.transports);
        result = 31 * result + Arrays.hashCode(this.collectedClientDataBytes);
        return result;
    }
}

