/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.sessions.infinispan.changes;

import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import org.keycloak.models.KeycloakSession;

public class PersistentUpdate {
    private final Consumer<KeycloakSession> task;
    private final CompletableFuture<Void> future = new CompletableFuture();

    public PersistentUpdate(Consumer<KeycloakSession> task) {
        this.task = task;
    }

    public void perform(KeycloakSession session) {
        this.task.accept(session);
    }

    public void complete() {
        this.future.complete(null);
    }

    public void fail(Throwable throwable) {
        this.future.completeExceptionally(throwable);
    }

    public CompletableFuture<Void> future() {
        return this.future;
    }
}

