/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.organization.authentication.authenticators.browser;

import jakarta.ws.rs.core.MultivaluedMap;
import java.util.List;
import org.keycloak.authentication.AuthenticationFlowContext;
import org.keycloak.authentication.AuthenticationFlowError;
import org.keycloak.authentication.authenticators.browser.IdentityProviderAuthenticator;
import org.keycloak.forms.login.LoginFormsProvider;
import org.keycloak.forms.login.freemarker.model.AuthenticationContextBean;
import org.keycloak.forms.login.freemarker.model.IdentityProviderBean;
import org.keycloak.http.HttpRequest;
import org.keycloak.models.IdentityProviderModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.OrganizationModel;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserModel;
import org.keycloak.models.utils.FormMessage;
import org.keycloak.organization.OrganizationProvider;
import org.keycloak.organization.forms.login.freemarker.model.OrganizationAwareAuthenticationContextBean;
import org.keycloak.organization.forms.login.freemarker.model.OrganizationAwareIdentityProviderBean;
import org.keycloak.organization.forms.login.freemarker.model.OrganizationAwareRealmBean;
import org.keycloak.organization.utils.Organizations;

public class OrganizationAuthenticator
extends IdentityProviderAuthenticator {
    private final KeycloakSession session;

    public OrganizationAuthenticator(KeycloakSession session) {
        this.session = session;
    }

    @Override
    public void authenticate(AuthenticationFlowContext context) {
        OrganizationProvider provider = this.getOrganizationProvider();
        if (!Organizations.isEnabledAndOrganizationsPresent(provider)) {
            context.attempted();
            return;
        }
        this.challenge(context);
    }

    @Override
    public void action(AuthenticationFlowContext context) {
        HttpRequest request = context.getHttpRequest();
        MultivaluedMap parameters = request.getDecodedFormParameters();
        String username = (String)parameters.getFirst((Object)"username");
        String emailDomain = this.getEmailDomain(username);
        if (emailDomain == null) {
            context.attempted();
            return;
        }
        RealmModel realm = context.getRealm();
        UserModel user = this.session.users().getUserByEmail(realm, username);
        if (user != null) {
            if (!user.isEnabled()) {
                context.failure(AuthenticationFlowError.INVALID_USER);
                return;
            }
            List<IdentityProviderModel> broker = Organizations.resolveBroker(this.session, user);
            if (broker.isEmpty()) {
                context.attempted();
            } else if (broker.size() == 1) {
                this.redirect(context, broker.get(0).getAlias(), user.getEmail());
            }
            return;
        }
        OrganizationProvider provider = this.getOrganizationProvider();
        OrganizationModel organization = provider.getByDomainName(emailDomain);
        if (organization == null || !organization.isEnabled()) {
            context.attempted();
            return;
        }
        List<IdentityProviderModel> brokers = organization.getIdentityProviders().toList();
        if (this.redirect(context, brokers, username, emailDomain)) {
            return;
        }
        if (!OrganizationAuthenticator.hasPublicBrokers(brokers)) {
            this.challenge(username, context);
            return;
        }
        LoginFormsProvider form = context.form().setAttributeMapper(attributes -> {
            attributes.computeIfPresent("social", (key, bean) -> new OrganizationAwareIdentityProviderBean((IdentityProviderBean)bean, this.session, true));
            attributes.computeIfPresent("auth", (key, bean) -> new OrganizationAwareAuthenticationContextBean((AuthenticationContextBean)bean, false));
            attributes.computeIfPresent("realm", (key, bean) -> new OrganizationAwareRealmBean(realm));
            return attributes;
        });
        form.addError(new FormMessage("Your email domain matches the " + organization.getName() + " organization but you don't have an account yet.", new Object[0]));
        context.challenge(form.createLoginUsername());
    }

    private static boolean hasPublicBrokers(List<IdentityProviderModel> brokers) {
        return brokers.stream().anyMatch(p -> Boolean.parseBoolean(p.getConfig().getOrDefault("kc.org.broker.public", Boolean.FALSE.toString())));
    }

    private OrganizationProvider getOrganizationProvider() {
        return (OrganizationProvider)this.session.getProvider(OrganizationProvider.class);
    }

    private void challenge(AuthenticationFlowContext context) {
        this.challenge(null, context);
    }

    private void challenge(String username, AuthenticationFlowContext context) {
        LoginFormsProvider form = context.form().setAttributeMapper(attributes -> {
            attributes.computeIfPresent("social", (key, bean) -> new OrganizationAwareIdentityProviderBean((IdentityProviderBean)bean, this.session, false, true));
            attributes.computeIfPresent("auth", (key, bean) -> new OrganizationAwareAuthenticationContextBean((AuthenticationContextBean)bean, false));
            return attributes;
        });
        if (username != null) {
            form.addError(new FormMessage("username", "invalidUserMessage"));
        }
        context.challenge(form.createLoginUsername());
    }

    private String getEmailDomain(String email) {
        if (email == null) {
            return null;
        }
        int domainSeparator = email.indexOf(64);
        if (domainSeparator == -1) {
            return null;
        }
        return email.substring(domainSeparator + 1);
    }

    @Override
    public boolean configuredFor(KeycloakSession session, RealmModel realm, UserModel user) {
        return realm.isOrganizationsEnabled();
    }

    protected boolean redirect(AuthenticationFlowContext context, List<IdentityProviderModel> brokers, String username, String emailDomain) {
        for (IdentityProviderModel broker : brokers) {
            String idpDomain;
            if (!OrganizationModel.IdentityProviderRedirectMode.EMAIL_MATCH.isSet(broker) || !emailDomain.equals(idpDomain = (String)broker.getConfig().get("kc.org.domain"))) continue;
            this.redirect(context, broker.getAlias(), username);
            return true;
        }
        return false;
    }
}

