/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.services.util;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jboss.logging.Logger;
import org.keycloak.common.Profile;
import org.keycloak.models.AuthenticatedClientSessionModel;
import org.keycloak.models.ClientModel;
import org.keycloak.models.ClientScopeModel;
import org.keycloak.models.ClientSessionContext;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.ProtocolMapperModel;
import org.keycloak.models.RealmModel;
import org.keycloak.models.RoleModel;
import org.keycloak.models.UserModel;
import org.keycloak.models.utils.KeycloakModelUtils;
import org.keycloak.models.utils.RoleUtils;
import org.keycloak.protocol.ProtocolMapperUtils;
import org.keycloak.protocol.oidc.TokenManager;
import org.keycloak.rar.AuthorizationRequestContext;
import org.keycloak.rar.AuthorizationRequestSource;
import org.keycloak.services.util.AuthorizationContextUtil;
import org.keycloak.util.TokenUtil;

public class DefaultClientSessionContext
implements ClientSessionContext {
    private static Logger logger = Logger.getLogger(DefaultClientSessionContext.class);
    private final AuthenticatedClientSessionModel clientSession;
    private final Set<String> clientScopeIds;
    private final KeycloakSession session;
    private Set<ClientScopeModel> clientScopes;
    private Set<RoleModel> roles;
    private Set<ProtocolMapperModel> protocolMappers;
    private Set<RoleModel> userRoles;
    private Map<String, Object> attributes = new HashMap<String, Object>();

    private DefaultClientSessionContext(AuthenticatedClientSessionModel clientSession, Set<String> clientScopeIds, KeycloakSession session) {
        this.clientScopeIds = clientScopeIds;
        this.clientSession = clientSession;
        this.session = session;
    }

    public static DefaultClientSessionContext fromClientSessionScopeParameter(AuthenticatedClientSessionModel clientSession, KeycloakSession session) {
        return DefaultClientSessionContext.fromClientSessionAndScopeParameter(clientSession, clientSession.getNote("scope"), session);
    }

    public static DefaultClientSessionContext fromClientSessionAndScopeParameter(AuthenticatedClientSessionModel clientSession, String scopeParam, KeycloakSession session) {
        Stream<ClientScopeModel> requestedClientScopes;
        if (Profile.isFeatureEnabled((Profile.Feature)Profile.Feature.DYNAMIC_SCOPES)) {
            session.getContext().setClient(clientSession.getClient());
            requestedClientScopes = AuthorizationContextUtil.getClientScopesStreamFromAuthorizationRequestContextWithClient(session, scopeParam);
        } else {
            requestedClientScopes = TokenManager.getRequestedClientScopes(scopeParam, clientSession.getClient());
        }
        return DefaultClientSessionContext.fromClientSessionAndClientScopes(clientSession, requestedClientScopes, session);
    }

    public static DefaultClientSessionContext fromClientSessionAndClientScopeIds(AuthenticatedClientSessionModel clientSession, Set<String> clientScopeIds, KeycloakSession session) {
        return new DefaultClientSessionContext(clientSession, clientScopeIds, session);
    }

    private static DefaultClientSessionContext fromClientSessionAndClientScopes(AuthenticatedClientSessionModel clientSession, Stream<ClientScopeModel> clientScopes, KeycloakSession session) {
        Set<String> clientScopeIds = clientScopes.map(ClientScopeModel::getId).collect(Collectors.toSet());
        return new DefaultClientSessionContext(clientSession, clientScopeIds, session);
    }

    public AuthenticatedClientSessionModel getClientSession() {
        return this.clientSession;
    }

    public Set<String> getClientScopeIds() {
        return this.clientScopeIds;
    }

    public Stream<ClientScopeModel> getClientScopesStream() {
        if (this.clientScopes == null) {
            this.clientScopes = this.loadClientScopes();
        }
        return this.clientScopes.stream();
    }

    public Stream<RoleModel> getRolesStream() {
        if (this.roles == null) {
            this.roles = this.loadRoles();
        }
        return this.roles.stream();
    }

    public Stream<ProtocolMapperModel> getProtocolMappersStream() {
        if (this.protocolMappers == null) {
            this.protocolMappers = this.loadProtocolMappers();
        }
        return this.protocolMappers.stream();
    }

    private Set<RoleModel> getUserRoles() {
        if (this.userRoles == null) {
            this.userRoles = this.loadUserRoles();
        }
        return this.userRoles;
    }

    public String getScopeString() {
        return this.getScopeString(false);
    }

    public String getScopeString(boolean ignoreIncludeInTokenScope) {
        if (Profile.isFeatureEnabled((Profile.Feature)Profile.Feature.DYNAMIC_SCOPES)) {
            String scopeParam = this.buildScopesStringFromAuthorizationRequest(ignoreIncludeInTokenScope);
            logger.tracef("Generated scope param with Dynamic Scopes enabled: %1s", (Object)scopeParam);
            String scopeSent = this.clientSession.getNote("scope");
            if (TokenUtil.isOIDCRequest((String)scopeSent)) {
                scopeParam = TokenUtil.attachOIDCScope((String)scopeParam);
            }
            return scopeParam;
        }
        String scopeParam = this.getClientScopesStream().filter(((Predicate<ClientScopeModel>)ClientModel.class::isInstance).negate()).filter(scope -> scope.isIncludeInTokenScope() || ignoreIncludeInTokenScope).map(ClientScopeModel::getName).collect(Collectors.joining(" "));
        String scopeSent = this.clientSession.getNote("scope");
        if (TokenUtil.isOIDCRequest((String)scopeSent)) {
            scopeParam = TokenUtil.attachOIDCScope((String)scopeParam);
        }
        return scopeParam;
    }

    private String buildScopesStringFromAuthorizationRequest(boolean ignoreIncludeInTokenScope) {
        return AuthorizationContextUtil.getAuthorizationRequestContextFromScopes(this.session, this.clientSession.getNote("scope")).getAuthorizationDetailEntries().stream().filter(authorizationDetails -> authorizationDetails.getSource().equals((Object)AuthorizationRequestSource.SCOPE)).filter(authorizationDetails -> authorizationDetails.getClientScope().isIncludeInTokenScope() || ignoreIncludeInTokenScope).filter(authorizationDetails -> this.isClientScopePermittedForUser(authorizationDetails.getClientScope())).map(authorizationDetails -> authorizationDetails.getAuthorizationDetails().getScopeNameFromCustomData()).collect(Collectors.joining(" "));
    }

    public void setAttribute(String name, Object value) {
        this.attributes.put(name, value);
    }

    public <T> T getAttribute(String name, Class<T> clazz) {
        Object value = this.attributes.get(name);
        return clazz.cast(value);
    }

    public AuthorizationRequestContext getAuthorizationRequestContext() {
        return AuthorizationContextUtil.getAuthorizationRequestContextFromScopes(this.session, this.clientSession.getNote("scope"));
    }

    private Set<ClientScopeModel> loadClientScopes() {
        HashSet<ClientScopeModel> clientScopes = new HashSet<ClientScopeModel>();
        for (String scopeId : this.clientScopeIds) {
            ClientScopeModel clientScope = KeycloakModelUtils.findClientScopeById((RealmModel)this.clientSession.getClient().getRealm(), (ClientModel)this.getClientSession().getClient(), (String)scopeId);
            if (clientScope == null) continue;
            if (this.isClientScopePermittedForUser(clientScope)) {
                clientScopes.add(clientScope);
                continue;
            }
            if (!logger.isTraceEnabled()) continue;
            logger.tracef("User '%s' not permitted to have client scope '%s'", (Object)this.clientSession.getUserSession().getUser().getUsername(), (Object)clientScope.getName());
        }
        return clientScopes;
    }

    private boolean isClientScopePermittedForUser(ClientScopeModel clientScope) {
        if (clientScope instanceof ClientModel) {
            return true;
        }
        Set clientScopeRoles = clientScope.getScopeMappingsStream().collect(Collectors.toSet());
        if (clientScopeRoles.isEmpty()) {
            return true;
        }
        clientScopeRoles = RoleUtils.expandCompositeRoles(clientScopeRoles);
        clientScopeRoles.retainAll(this.getUserRoles());
        return !clientScopeRoles.isEmpty();
    }

    private Set<RoleModel> loadRoles() {
        UserModel user = this.clientSession.getUserSession().getUser();
        ClientModel client = this.clientSession.getClient();
        return TokenManager.getAccess(user, client, this.getClientScopesStream());
    }

    private Set<ProtocolMapperModel> loadProtocolMappers() {
        String protocol = this.clientSession.getClient().getProtocol();
        if (protocol == null) {
            logger.warnf("Client '%s' doesn't have protocol set. Fallback to openid-connect. Please fix client configuration", (Object)this.clientSession.getClient().getClientId());
            protocol = "openid-connect";
        }
        String finalProtocol = protocol;
        return this.getClientScopesStream().flatMap(clientScope -> clientScope.getProtocolMappersStream().filter(mapper -> Objects.equals(finalProtocol, mapper.getProtocol()) && ProtocolMapperUtils.isEnabled(this.session, mapper))).collect(Collectors.toSet());
    }

    private Set<RoleModel> loadUserRoles() {
        UserModel user = this.clientSession.getUserSession().getUser();
        return RoleUtils.getDeepUserRoleMappings((UserModel)user);
    }
}

