/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.reactive.common.processor.transformation;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.DotName;
import org.jboss.jandex.FieldInfo;
import org.jboss.resteasy.reactive.common.processor.transformation.Annotations;
import org.jboss.resteasy.reactive.common.processor.transformation.AnnotationsTransformationContext;
import org.jboss.resteasy.reactive.common.processor.transformation.AnnotationsTransformer;
import org.jboss.resteasy.reactive.common.processor.transformation.Transformation;

public final class AnnotationStore {
    private final ConcurrentMap<AnnotationTargetKey, Collection<AnnotationInstance>> transformed;
    private final EnumMap<AnnotationTarget.Kind, List<AnnotationsTransformer>> transformersMap;

    public AnnotationStore(Collection<AnnotationsTransformer> transformers) {
        if (transformers == null || transformers.isEmpty()) {
            this.transformed = null;
            this.transformersMap = null;
        } else {
            this.transformed = new ConcurrentHashMap<AnnotationTargetKey, Collection<AnnotationInstance>>();
            this.transformersMap = new EnumMap(AnnotationTarget.Kind.class);
            this.transformersMap.put(AnnotationTarget.Kind.CLASS, this.initTransformers(AnnotationTarget.Kind.CLASS, transformers));
            this.transformersMap.put(AnnotationTarget.Kind.METHOD, this.initTransformers(AnnotationTarget.Kind.METHOD, transformers));
            this.transformersMap.put(AnnotationTarget.Kind.FIELD, this.initTransformers(AnnotationTarget.Kind.FIELD, transformers));
        }
    }

    public Collection<AnnotationInstance> getAnnotations(AnnotationTarget target) {
        if (this.transformed != null) {
            return this.transformed.computeIfAbsent(new AnnotationTargetKey(target), this::transform);
        }
        return this.getOriginalAnnotations(target);
    }

    public AnnotationInstance getAnnotation(AnnotationTarget target, DotName name) {
        return Annotations.find(this.getAnnotations(target), name);
    }

    public boolean hasAnnotation(AnnotationTarget target, DotName name) {
        return Annotations.contains(this.getAnnotations(target), name);
    }

    public boolean hasAnyAnnotation(AnnotationTarget target, Iterable<DotName> names) {
        return Annotations.containsAny(this.getAnnotations(target), names);
    }

    private Collection<AnnotationInstance> transform(AnnotationTargetKey key) {
        AnnotationTarget target = key.target;
        Collection<AnnotationInstance> annotations = this.getOriginalAnnotations(target);
        List<AnnotationsTransformer> transformers = this.transformersMap.get(target.kind());
        if (transformers.isEmpty()) {
            return annotations;
        }
        TransformationContextImpl transformationContext = new TransformationContextImpl(target, annotations);
        for (AnnotationsTransformer transformer : transformers) {
            transformer.transform(transformationContext);
        }
        return transformationContext.getAnnotations();
    }

    private Collection<AnnotationInstance> getOriginalAnnotations(AnnotationTarget target) {
        switch (target.kind()) {
            case CLASS: {
                return target.asClass().declaredAnnotations();
            }
            case METHOD: {
                return target.asMethod().annotations();
            }
            case FIELD: {
                return target.asField().annotations();
            }
        }
        throw new IllegalArgumentException("Unsupported annotation target");
    }

    private List<AnnotationsTransformer> initTransformers(AnnotationTarget.Kind kind, Collection<AnnotationsTransformer> transformers) {
        ArrayList<AnnotationsTransformer> found = new ArrayList<AnnotationsTransformer>();
        for (AnnotationsTransformer transformer : transformers) {
            if (!transformer.appliesTo(kind)) continue;
            found.add(transformer);
        }
        if (found.isEmpty()) {
            return Collections.emptyList();
        }
        found.sort(AnnotationsTransformer::compare);
        return found;
    }

    private static IllegalArgumentException unsupportedAnnotationTarget(AnnotationTarget target) {
        return new IllegalArgumentException("Unsupported annotation target: " + target.kind());
    }

    static final class AnnotationTargetKey {
        final AnnotationTarget target;

        public AnnotationTargetKey(AnnotationTarget target) {
            this.target = target;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            AnnotationTargetKey other = (AnnotationTargetKey)obj;
            if (this.target.kind() != other.target.kind()) {
                return false;
            }
            switch (this.target.kind()) {
                case METHOD: {
                    return this.target.asMethod().equals((Object)other.target);
                }
                case FIELD: {
                    FieldInfo field = this.target.asField();
                    FieldInfo otherField = other.target.asField();
                    return Objects.equals(field.name(), otherField.name()) && Objects.equals(field.declaringClass().name(), otherField.declaringClass().name());
                }
                case CLASS: {
                    return this.target.asClass().name().equals((Object)other.target.asClass().name());
                }
            }
            throw AnnotationStore.unsupportedAnnotationTarget(this.target);
        }

        public int hashCode() {
            switch (this.target.kind()) {
                case METHOD: {
                    return this.target.asMethod().hashCode();
                }
                case FIELD: {
                    return Objects.hash(this.target.asField().name(), this.target.asField().declaringClass().name());
                }
                case CLASS: {
                    return this.target.asClass().name().hashCode();
                }
            }
            throw AnnotationStore.unsupportedAnnotationTarget(this.target);
        }
    }

    static class TransformationContextImpl
    extends AnnotationsTransformationContext<Collection<AnnotationInstance>>
    implements AnnotationsTransformer.TransformationContext {
        public TransformationContextImpl(AnnotationTarget target, Collection<AnnotationInstance> annotations) {
            super(target, annotations);
        }

        @Override
        public Transformation transform() {
            return new Transformation((Collection<AnnotationInstance>)new ArrayList<AnnotationInstance>((Collection<AnnotationInstance>)this.getAnnotations()), this.getTarget(), this::setAnnotations);
        }
    }
}

