/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.protostream.descriptors;

import org.infinispan.protostream.descriptors.FieldDescriptor;
import org.infinispan.protostream.descriptors.JavaType;
import org.infinispan.protostream.descriptors.Label;
import org.infinispan.protostream.descriptors.Type;
import org.infinispan.protostream.descriptors.WireType;

public class MapDescriptor
extends FieldDescriptor {
    private final String keyTypeName;
    private final Type keyType;

    private MapDescriptor(Builder builder) {
        super(builder);
        this.keyTypeName = builder.keyTypeName;
        this.keyType = Type.primitiveFromString(this.keyTypeName);
    }

    @Override
    public boolean isRepeated() {
        return true;
    }

    public Type getKeyType() {
        return this.keyType;
    }

    public String getKeyTypeName() {
        return this.keyTypeName;
    }

    public JavaType getKeyJavaType() {
        return this.getKeyType().getJavaType();
    }

    @Override
    public int getWireTag() {
        return WireType.makeTag(this.number, WireType.LENGTH_DELIMITED);
    }

    public int getKeyWireTag() {
        return WireType.makeTag(1, this.keyType.getWireType());
    }

    public int getValueWireTag() {
        return WireType.makeTag(2, this.type.getWireType());
    }

    @Override
    public Label getLabel() {
        return Label.OPTIONAL;
    }

    @Override
    public String toString() {
        return "MapDescriptor{keyTypeName='" + this.keyTypeName + "', valueTypeName='" + this.typeName + "', name='" + this.name + "', number='" + this.number + "'}";
    }

    public static class Builder
    extends FieldDescriptor.Builder {
        String keyTypeName;

        @Override
        public Builder withName(String name) {
            super.withName(name);
            return this;
        }

        public Builder withKeyTypeName(String keyTypeName) {
            this.keyTypeName = keyTypeName;
            return this;
        }

        public Builder withValueTypeName(String valueTypeName) {
            this.withTypeName(valueTypeName);
            return this;
        }

        @Override
        public MapDescriptor build() {
            return new MapDescriptor(this);
        }
    }
}

