/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.client.registration.cli.commands;

import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import org.keycloak.client.cli.config.ConfigData;
import org.keycloak.client.cli.util.ConfigUtil;
import org.keycloak.client.cli.util.HttpUtil;
import org.keycloak.client.cli.util.IoUtil;
import org.keycloak.client.cli.util.OsUtil;
import org.keycloak.client.registration.cli.EndpointType;
import org.keycloak.client.registration.cli.KcRegMain;
import org.keycloak.client.registration.cli.commands.AbstractAuthOptionsCmd;
import org.keycloak.representations.adapters.config.AdapterConfig;
import org.keycloak.representations.idm.ClientRepresentation;
import org.keycloak.representations.oidc.OIDCClientRepresentation;
import org.keycloak.util.JsonSerialization;
import picocli.CommandLine;

@CommandLine.Command(name="get", description={"[ARGUMENTS]"})
public class GetCmd
extends AbstractAuthOptionsCmd {
    @CommandLine.Option(names={"-c", "--compressed"}, description={"Print full stack trace when exiting with error"})
    private boolean compressed = false;
    @CommandLine.Option(names={"-e", "--endpoint"}, description={"Endpoint type to use"})
    private String endpoint;
    @CommandLine.Parameters(arity="0..1")
    String clientId;

    @Override
    protected void process() {
        EndpointType regType;
        if (this.clientId == null) {
            throw new IllegalArgumentException("CLIENT not specified");
        }
        EndpointType endpointType = regType = this.endpoint != null ? EndpointType.of(this.endpoint) : EndpointType.DEFAULT;
        if (this.clientId.startsWith("-")) {
            IoUtil.warnfErr("You're using what looks like an OPTION as CLIENT: %s", this.clientId);
        }
        ConfigData config = ConfigUtil.loadConfig();
        config = this.copyWithServerInfo(config);
        if (this.externalToken == null) {
            this.externalToken = ConfigUtil.getRegistrationToken(config.sessionRealmConfigData(), this.clientId);
        }
        this.setupTruststore(config);
        String auth = this.externalToken;
        if (auth == null) {
            config = this.ensureAuthInfo(config);
            if (ConfigUtil.credentialsAvailable(config = this.copyWithServerInfo(config))) {
                auth = this.ensureToken(config);
            }
        }
        auth = auth != null ? "Bearer " + auth : null;
        String server = config.getServerUrl();
        String realm = config.getRealm();
        InputStream response = HttpUtil.doGet(server + "/realms/" + realm + "/clients-registrations/" + regType.getEndpoint() + "/" + HttpUtil.urlencode(this.clientId), "application/json", auth);
        try {
            String json = IoUtil.readFully(response);
            Object result = null;
            switch (regType) {
                case DEFAULT: {
                    ClientRepresentation client = JsonSerialization.readValue(json, ClientRepresentation.class);
                    result = client;
                    ConfigUtil.saveMergeConfig(cfg -> ConfigUtil.setRegistrationToken(cfg.ensureRealmConfigData(server, realm), client.getClientId(), client.getRegistrationAccessToken()));
                    break;
                }
                case OIDC: {
                    OIDCClientRepresentation client = JsonSerialization.readValue(json, OIDCClientRepresentation.class);
                    result = client;
                    ConfigUtil.saveMergeConfig(cfg -> ConfigUtil.setRegistrationToken(cfg.ensureRealmConfigData(server, realm), client.getClientId(), client.getRegistrationAccessToken()));
                    break;
                }
                case INSTALL: {
                    result = JsonSerialization.readValue(json, AdapterConfig.class);
                    break;
                }
                case SAML2: {
                    break;
                }
                default: {
                    throw new RuntimeException("Unexpected type: " + (Object)((Object)regType));
                }
            }
            if (!this.compressed && result != null) {
                json = JsonSerialization.writeValueAsPrettyString(result);
            }
            IoUtil.printOut(json);
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to process HTTP response", e);
        }
    }

    @Override
    protected boolean nothingToDo() {
        return super.nothingToDo() && this.endpoint == null && this.clientId == null;
    }

    @Override
    protected String help() {
        StringWriter sb = new StringWriter();
        PrintWriter out = new PrintWriter(sb);
        out.println("Usage: " + KcRegMain.CMD + " get CLIENT [ARGUMENTS]");
        out.println();
        out.println("Command to retrieve a client configuration description for a specified client. If registration access token");
        out.println("is specified or is available in configuration file, then it is used. Otherwise, current active session is used.");
        this.globalOptions(out);
        out.println("    CLIENT                ClientId of the client to display");
        out.println("    -t, --token TOKEN     Use the specified Registration Access Token for authorization");
        out.println("    -c, --compressed      Don't pretty print the output");
        out.println("    -e, --endpoint TYPE   Endpoint type to use - one of: 'default', 'oidc', 'install'");
        out.println();
        out.println("Examples:");
        out.println();
        out.println("Get configuration in default format:");
        out.println("  " + OsUtil.PROMPT + " " + KcRegMain.CMD + " get my_client");
        out.println();
        out.println("Get configuration in OIDC format:");
        out.println("  " + OsUtil.PROMPT + " " + KcRegMain.CMD + " get my_client -e oidc");
        out.println();
        out.println("Get adapter configuration for the client:");
        out.println("  " + OsUtil.PROMPT + " " + KcRegMain.CMD + " get my_client -e install");
        out.println();
        out.println();
        out.println("Use '" + KcRegMain.CMD + " help' for general information and a list of commands");
        return sb.toString();
    }
}

