/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.keys;

import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.interfaces.ECPublicKey;
import java.security.spec.X509EncodedKeySpec;
import java.util.List;
import org.jboss.logging.Logger;
import org.keycloak.common.util.Base64;
import org.keycloak.common.util.MultivaluedHashMap;
import org.keycloak.component.ComponentModel;
import org.keycloak.component.ComponentValidationException;
import org.keycloak.crypto.KeyUse;
import org.keycloak.keys.AbstractEcdsaKeyProviderFactory;
import org.keycloak.keys.GeneratedEcdsaKeyProvider;
import org.keycloak.keys.KeyProvider;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.provider.ConfigurationValidationHelper;
import org.keycloak.provider.ProviderConfigProperty;

public class GeneratedEcdsaKeyProviderFactory
extends AbstractEcdsaKeyProviderFactory {
    private static final Logger logger = Logger.getLogger(GeneratedEcdsaKeyProviderFactory.class);
    public static final String ID = "ecdsa-generated";
    private static final String HELP_TEXT = "Generates ECDSA keys";
    public static final String DEFAULT_ECDSA_ELLIPTIC_CURVE = "P-256";
    private static final List<ProviderConfigProperty> CONFIG_PROPERTIES = AbstractEcdsaKeyProviderFactory.configurationBuilder().property(ECDSA_ELLIPTIC_CURVE_PROPERTY).build();

    public KeyProvider create(KeycloakSession session, ComponentModel model) {
        return new GeneratedEcdsaKeyProvider(session.getContext().getRealm(), model);
    }

    public boolean createFallbackKeys(KeycloakSession session, KeyUse keyUse, String algorithm) {
        if (keyUse.equals((Object)KeyUse.SIG) && (algorithm.equals("ES256") || algorithm.equals("ES384") || algorithm.equals("ES512"))) {
            RealmModel realm = session.getContext().getRealm();
            ComponentModel generated = new ComponentModel();
            generated.setName("fallback-" + algorithm);
            generated.setParentId(realm.getId());
            generated.setProviderId(ID);
            generated.setProviderType(KeyProvider.class.getName());
            MultivaluedHashMap config = new MultivaluedHashMap();
            config.putSingle((Object)"priority", (Object)"-100");
            config.putSingle((Object)"ecdsaEllipticCurveKey", (Object)GeneratedEcdsaKeyProviderFactory.convertAlgorithmToECDomainParmNistRep(algorithm));
            generated.setConfig(config);
            realm.addComponentModel(generated);
            return true;
        }
        return false;
    }

    public String getHelpText() {
        return HELP_TEXT;
    }

    public List<ProviderConfigProperty> getConfigProperties() {
        return CONFIG_PROPERTIES;
    }

    public String getId() {
        return ID;
    }

    @Override
    public void validateConfiguration(KeycloakSession session, RealmModel realm, ComponentModel model) throws ComponentValidationException {
        super.validateConfiguration(session, realm, model);
        ConfigurationValidationHelper.check((ComponentModel)model).checkList(ECDSA_ELLIPTIC_CURVE_PROPERTY, false);
        String ecInNistRep = model.get("ecdsaEllipticCurveKey");
        if (ecInNistRep == null) {
            ecInNistRep = DEFAULT_ECDSA_ELLIPTIC_CURVE;
        }
        if (!model.contains("ecdsaPrivateKey") || !model.contains("ecdsaPublicKey")) {
            this.generateKeys(model, ecInNistRep);
            logger.debugv("Generated keys for {0}", (Object)realm.getName());
        } else {
            String currentEc = this.getCurveFromPublicKey((String)model.getConfig().getFirst((Object)"ecdsaPublicKey"));
            if (!ecInNistRep.equals(currentEc)) {
                this.generateKeys(model, ecInNistRep);
                logger.debugv("Elliptic Curve changed, generating new keys for {0}", (Object)realm.getName());
            }
        }
    }

    private void generateKeys(ComponentModel model, String ecInNistRep) {
        try {
            KeyPair keyPair = GeneratedEcdsaKeyProviderFactory.generateEcdsaKeyPair(GeneratedEcdsaKeyProviderFactory.convertECDomainParmNistRepToSecRep(ecInNistRep));
            model.put("ecdsaPrivateKey", Base64.encodeBytes((byte[])keyPair.getPrivate().getEncoded()));
            model.put("ecdsaPublicKey", Base64.encodeBytes((byte[])keyPair.getPublic().getEncoded()));
            model.put("ecdsaEllipticCurveKey", ecInNistRep);
        }
        catch (Throwable t) {
            throw new ComponentValidationException("Failed to generate ECDSA keys", t);
        }
    }

    private String getCurveFromPublicKey(String publicEcdsaKeyBase64Encoded) {
        try {
            KeyFactory kf = KeyFactory.getInstance("EC");
            X509EncodedKeySpec publicKeySpec = new X509EncodedKeySpec(Base64.decode((String)publicEcdsaKeyBase64Encoded));
            ECPublicKey ecKey = (ECPublicKey)kf.generatePublic(publicKeySpec);
            return "P-" + ecKey.getParams().getCurve().getField().getFieldSize();
        }
        catch (Throwable t) {
            throw new ComponentValidationException("Failed to get EC from its public key", t);
        }
    }
}

