/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.services.x509;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.security.GeneralSecurityException;
import java.security.cert.X509Certificate;
import org.jboss.logging.Logger;
import org.keycloak.common.util.PemException;
import org.keycloak.common.util.PemUtils;
import org.keycloak.http.HttpRequest;
import org.keycloak.services.x509.AbstractClientCertificateFromHttpHeadersLookup;

public class NginxProxyTrustedClientCertificateLookup
extends AbstractClientCertificateFromHttpHeadersLookup {
    private static final Logger log = Logger.getLogger(NginxProxyTrustedClientCertificateLookup.class);

    public NginxProxyTrustedClientCertificateLookup(String sslCientCertHttpHeader, String sslCertChainHttpHeaderPrefix, int certificateChainLength) {
        super(sslCientCertHttpHeader, sslCertChainHttpHeaderPrefix, certificateChainLength);
    }

    @Override
    protected X509Certificate getCertificateFromHttpHeader(HttpRequest request, String httpHeader) throws GeneralSecurityException {
        X509Certificate certificate = super.getCertificateFromHttpHeader(request, httpHeader);
        if (certificate == null) {
            return null;
        }
        String validCertificateResult = NginxProxyTrustedClientCertificateLookup.getHeaderValue(request, "ssl-client-verify");
        if ("SUCCESS".equals(validCertificateResult)) {
            return certificate;
        }
        log.warn((Object)("nginx could not verify the certificate: ssl-client-verify: " + validCertificateResult));
        return null;
    }

    @Override
    protected X509Certificate decodeCertificateFromPem(String pem) throws PemException {
        if (pem == null) {
            log.warn((Object)"End user TLS Certificate is NULL! ");
            return null;
        }
        try {
            pem = URLDecoder.decode(pem, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            log.error((Object)("Cannot URL decode the end user TLS Certificate : " + pem), (Throwable)e);
        }
        return PemUtils.decodeCertificate((String)pem);
    }
}

