/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.quarkus.runtime.configuration.mappers;

import io.smallrye.config.ConfigSourceInterceptorContext;
import java.util.Optional;
import org.keycloak.config.HttpOptions;
import org.keycloak.config.ManagementOptions;
import org.keycloak.config.Option;
import org.keycloak.quarkus.runtime.Messages;
import org.keycloak.quarkus.runtime.cli.PropertyException;
import org.keycloak.quarkus.runtime.configuration.Configuration;
import org.keycloak.quarkus.runtime.configuration.mappers.PropertyMapper;

public class ManagementPropertyMappers {
    private static final String MANAGEMENT_ENABLED_MSG = "Management interface is enabled";

    private ManagementPropertyMappers() {
    }

    public static PropertyMapper<?>[] getManagementPropertyMappers() {
        return new PropertyMapper[]{PropertyMapper.fromOption(ManagementOptions.LEGACY_OBSERVABILITY_INTERFACE).to("quarkus.management.enabled").paramLabel(Boolean.TRUE + "|" + Boolean.FALSE).transformer(ManagementPropertyMappers::managementEnabledTransformer).build(), PropertyMapper.fromOption(ManagementOptions.HTTP_MANAGEMENT_RELATIVE_PATH).isEnabled(ManagementPropertyMappers::isManagementEnabled, MANAGEMENT_ENABLED_MSG).mapFrom(HttpOptions.HTTP_RELATIVE_PATH.getKey()).to("quarkus.management.root-path").paramLabel("path").build(), PropertyMapper.fromOption(ManagementOptions.HTTP_MANAGEMENT_PORT).isEnabled(ManagementPropertyMappers::isManagementEnabled, MANAGEMENT_ENABLED_MSG).to("quarkus.management.port").paramLabel("port").build(), PropertyMapper.fromOption(ManagementOptions.HTTP_MANAGEMENT_HOST).isEnabled(ManagementPropertyMappers::isManagementEnabled, MANAGEMENT_ENABLED_MSG).mapFrom(HttpOptions.HTTP_HOST.getKey()).to("quarkus.management.host").paramLabel("host").build(), PropertyMapper.fromOption(ManagementOptions.HTTPS_MANAGEMENT_CLIENT_AUTH).isEnabled(ManagementPropertyMappers::isManagementEnabled, MANAGEMENT_ENABLED_MSG).mapFrom(HttpOptions.HTTPS_CLIENT_AUTH.getKey()).to("quarkus.management.ssl.client-auth").paramLabel("auth").build(), PropertyMapper.fromOption(ManagementOptions.HTTPS_MANAGEMENT_CIPHER_SUITES).isEnabled(ManagementPropertyMappers::isManagementEnabled, MANAGEMENT_ENABLED_MSG).mapFrom(HttpOptions.HTTPS_CIPHER_SUITES.getKey()).to("quarkus.management.ssl.cipher-suites").paramLabel("ciphers").build(), PropertyMapper.fromOption(ManagementOptions.HTTPS_MANAGEMENT_PROTOCOLS).isEnabled(ManagementPropertyMappers::isManagementEnabled, MANAGEMENT_ENABLED_MSG).mapFrom(HttpOptions.HTTPS_PROTOCOLS.getKey()).to("quarkus.management.ssl.protocols").paramLabel("protocols").build(), PropertyMapper.fromOption(ManagementOptions.HTTPS_MANAGEMENT_CERTIFICATE_FILE).isEnabled(ManagementPropertyMappers::isManagementEnabled, MANAGEMENT_ENABLED_MSG).mapFrom(HttpOptions.HTTPS_CERTIFICATE_FILE.getKey()).to("quarkus.management.ssl.certificate.files").validator((mapper, value) -> ManagementPropertyMappers.validateTlsProperties()).paramLabel("file").build(), PropertyMapper.fromOption(ManagementOptions.HTTPS_MANAGEMENT_CERTIFICATE_KEY_FILE).isEnabled(ManagementPropertyMappers::isManagementEnabled, MANAGEMENT_ENABLED_MSG).mapFrom(HttpOptions.HTTPS_CERTIFICATE_KEY_FILE.getKey()).to("quarkus.management.ssl.certificate.key-files").validator((mapper, value) -> ManagementPropertyMappers.validateTlsProperties()).paramLabel("file").build(), PropertyMapper.fromOption(ManagementOptions.HTTPS_MANAGEMENT_KEY_STORE_FILE).isEnabled(ManagementPropertyMappers::isManagementEnabled, MANAGEMENT_ENABLED_MSG).mapFrom(HttpOptions.HTTPS_KEY_STORE_FILE.getKey()).to("quarkus.management.ssl.certificate.key-store-file").validator((mapper, value) -> ManagementPropertyMappers.validateTlsProperties()).paramLabel("file").build(), PropertyMapper.fromOption(ManagementOptions.HTTPS_MANAGEMENT_KEY_STORE_PASSWORD).isEnabled(ManagementPropertyMappers::isManagementEnabled, MANAGEMENT_ENABLED_MSG).mapFrom(HttpOptions.HTTPS_KEY_STORE_PASSWORD.getKey()).to("quarkus.management.ssl.certificate.key-store-password").validator((mapper, value) -> ManagementPropertyMappers.validateTlsProperties()).paramLabel("password").isMasked(true).build(), PropertyMapper.fromOption(ManagementOptions.HTTPS_MANAGEMENT_KEY_STORE_TYPE).isEnabled(ManagementPropertyMappers::isManagementEnabled, MANAGEMENT_ENABLED_MSG).mapFrom(HttpOptions.HTTPS_KEY_STORE_TYPE.getKey()).to("quarkus.management.ssl.certificate.key-store-file-type").transformer((value, config) -> value.or(() -> Configuration.getOptionalKcValue(HttpOptions.HTTPS_KEY_STORE_TYPE.getKey()))).paramLabel("type").build()};
    }

    public static boolean isManagementEnabled() {
        return Configuration.isTrue("quarkus.management.enabled");
    }

    public static boolean isManagementTlsEnabled() {
        Optional<String> key = Configuration.getOptionalKcValue(ManagementOptions.HTTPS_MANAGEMENT_CERTIFICATE_KEY_FILE.getKey());
        Optional<String> cert = Configuration.getOptionalKcValue(ManagementOptions.HTTPS_MANAGEMENT_CERTIFICATE_FILE.getKey());
        if (key.isPresent() && cert.isPresent()) {
            return true;
        }
        Optional<String> keystore = Configuration.getOptionalKcValue(ManagementOptions.HTTPS_MANAGEMENT_KEY_STORE_FILE.getKey());
        return keystore.isPresent();
    }

    private static void validateTlsProperties() {
        boolean isHttpEnabled = Configuration.isTrue((Option<Boolean>)HttpOptions.HTTP_ENABLED);
        if (!isHttpEnabled && !ManagementPropertyMappers.isManagementTlsEnabled()) {
            throw new PropertyException(Messages.httpsConfigurationNotSet());
        }
    }

    private static Optional<String> managementEnabledTransformer(Optional<String> value, ConfigSourceInterceptorContext ctx) {
        if (value.isPresent()) {
            boolean b = Boolean.parseBoolean(value.get());
            return Optional.of(Boolean.toString(!b));
        }
        return Optional.of(Boolean.TRUE.toString());
    }
}

