/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.jose.jwk;

import java.math.BigInteger;
import java.security.Key;
import java.security.interfaces.EdECPublicKey;
import java.security.spec.EdECPoint;
import java.util.Arrays;
import java.util.Optional;
import org.keycloak.common.util.Base64Url;
import org.keycloak.common.util.KeyUtils;
import org.keycloak.crypto.KeyUse;
import org.keycloak.jose.jwk.AbstractJWKBuilder;
import org.keycloak.jose.jwk.JWK;
import org.keycloak.jose.jwk.OKPPublicJWK;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public class JWKBuilder
extends AbstractJWKBuilder {
    private JWKBuilder() {
    }

    public static JWKBuilder create() {
        return new JWKBuilder();
    }

    public JWKBuilder kid(String kid) {
        this.kid = kid;
        return this;
    }

    public JWKBuilder algorithm(String algorithm) {
        this.algorithm = algorithm;
        return this;
    }

    @Override
    public JWK okp(Key key) {
        return this.okp(key, DEFAULT_PUBLIC_KEY_USE);
    }

    @Override
    public JWK okp(Key key, KeyUse keyUse) {
        EdECPublicKey eddsaPublicKey = (EdECPublicKey)key;
        OKPPublicJWK k = new OKPPublicJWK();
        String kid = this.kid != null ? this.kid : KeyUtils.createKeyId((Key)key);
        k.setKeyId(kid);
        k.setKeyType("OKP");
        k.setAlgorithm(this.algorithm);
        k.setPublicKeyUse(keyUse == null ? DEFAULT_PUBLIC_KEY_USE.getSpecName() : keyUse.getSpecName());
        k.setCrv(eddsaPublicKey.getParams().getName());
        Optional<String> x = this.edPublicKeyInJwkRepresentation(eddsaPublicKey);
        k.setX(x.orElse(""));
        return k;
    }

    private Optional<String> edPublicKeyInJwkRepresentation(EdECPublicKey eddsaPublicKey) {
        EdECPoint edEcPoint = eddsaPublicKey.getPoint();
        BigInteger yCoordinate = edEcPoint.getY();
        int bytesLength = 0;
        if ("Ed25519".equals(eddsaPublicKey.getParams().getName())) {
            bytesLength = 32;
        } else if ("Ed448".equals(eddsaPublicKey.getParams().getName())) {
            bytesLength = 57;
        } else {
            return Optional.ofNullable(null);
        }
        byte[] yCoordinateLittleEndianBytes = new byte[bytesLength];
        yCoordinateLittleEndianBytes = Arrays.copyOf(JWKBuilder.reverseBytes(yCoordinate.toByteArray()), bytesLength);
        if (edEcPoint.isXOdd()) {
            int n = yCoordinateLittleEndianBytes.length - 1;
            yCoordinateLittleEndianBytes[n] = (byte)(yCoordinateLittleEndianBytes[n] | 0xFFFFFF80);
        }
        return Optional.ofNullable(Base64Url.encode((byte[])yCoordinateLittleEndianBytes));
    }
}

