/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.client.admin.cli.commands;

import com.fasterxml.jackson.databind.JsonNode;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.keycloak.client.admin.cli.CmdStdinContext;
import org.keycloak.client.admin.cli.KcAdmMain;
import org.keycloak.client.admin.cli.commands.GlobalOptionsCmdHelper;
import org.keycloak.client.cli.common.AttributeOperation;
import org.keycloak.client.cli.common.BaseGlobalOptionsCmd;
import org.keycloak.client.cli.util.AccessibleBufferOutputStream;
import org.keycloak.client.cli.util.IoUtil;
import org.keycloak.client.cli.util.OsUtil;
import org.keycloak.client.cli.util.OutputUtil;
import org.keycloak.client.cli.util.ParseUtil;
import picocli.CommandLine;

@CommandLine.Command(name="new-object", description={"Command to create new JSON objects locally"})
public class NewObjectCmd
extends BaseGlobalOptionsCmd
implements GlobalOptionsCmdHelper {
    @CommandLine.Option(names={"-f", "--file"}, description={"Read object from file or standard input if FILENAME is set to '-'"})
    String file;
    @CommandLine.Option(names={"-c", "--compressed"}, description={"Don't pretty print the output"})
    boolean compressed;
    @CommandLine.Option(names={"-s", "--set"}, description={"Set a specific attribute NAME to a specified value VALUE"})
    List<String> values = new ArrayList<String>();

    @Override
    public void process() {
        List<AttributeOperation> attrs = this.values.stream().map(it -> {
            String[] keyVal = ParseUtil.parseKeyVal(it);
            return new AttributeOperation(AttributeOperation.Type.SET, keyVal[0], keyVal[1]);
        }).collect(Collectors.toList());
        ByteArrayInputStream body = null;
        CmdStdinContext<Object> ctx = new CmdStdinContext();
        if (this.file != null) {
            ctx = CmdStdinContext.parseFileOrStdin(this.file);
        }
        if (attrs.size() > 0) {
            ctx = CmdStdinContext.mergeAttributes(ctx, OutputUtil.MAPPER.createObjectNode(), attrs);
        }
        if (body == null && ctx.getContent() != null) {
            body = new ByteArrayInputStream(ctx.getContent().getBytes(StandardCharsets.UTF_8));
        }
        AccessibleBufferOutputStream abos = new AccessibleBufferOutputStream(System.out);
        if (!this.compressed) {
            ByteArrayOutputStream buffer = new ByteArrayOutputStream();
            IoUtil.copyStream(body, buffer);
            try {
                JsonNode rootNode = OutputUtil.MAPPER.readValue(buffer.toByteArray(), JsonNode.class);
                OutputUtil.MAPPER.writeValue(abos, (Object)rootNode);
            }
            catch (Exception ignored) {
                IoUtil.copyStream(new ByteArrayInputStream(buffer.toByteArray()), abos);
            }
        } else {
            IoUtil.copyStream(body, System.out);
        }
        int lastByte = abos.getLastByte();
        if (lastByte != -1 && lastByte != 13 && lastByte != 10) {
            IoUtil.printErr("");
        }
    }

    @Override
    protected boolean nothingToDo() {
        return this.file == null && this.values.isEmpty();
    }

    @Override
    protected String help() {
        return NewObjectCmd.usage();
    }

    public static String usage() {
        StringWriter sb = new StringWriter();
        PrintWriter out = new PrintWriter(sb);
        out.println("Usage: " + KcAdmMain.CMD + " new-object [ARGUMENTS]");
        out.println();
        out.println("Command to compose JSON objects from attributes, and merge changes into existing JSON documents.");
        out.println();
        out.println("This is a local command that does not perform any server requests. Its functionality is fully ");
        out.println("integrated into 'create', 'update' and 'delete' commands. It's supposed to be a helper tool only.");
        out.println();
        out.println("Arguments:");
        out.println();
        out.println("  Global options:");
        out.println("    -x                    Print full stack trace when exiting with error");
        out.println();
        out.println("  Command specific options:");
        out.println("    -s, --set NAME=VALUE  Set a specific attribute NAME to a specified value VALUE");
        out.println("    -f, --file FILENAME   Read object from file or standard input if FILENAME is set to '-'");
        out.println("    -c, --compressed      Don't pretty print the output");
        out.println();
        out.println("Examples:");
        out.println();
        out.println("Create a new JSON document with two top level attributes:");
        out.println("  " + OsUtil.PROMPT + " " + KcAdmMain.CMD + " new-object -s realm=demorealm -s enabled=true");
        out.println();
        out.println("Read a JSON document and apply changes on top of it:");
        if (OsUtil.OS_ARCH.isWindows()) {
            out.println("  " + OsUtil.PROMPT + " echo { \"clientId\": \"my_client\" } | " + KcAdmMain.CMD + " new-object -s enabled=true -f -");
        } else {
            out.println("  " + OsUtil.PROMPT + " " + KcAdmMain.CMD + " new-object -s enabled=true -f - << EOF");
            out.println("  {");
            out.println("    \"clientId\": \"my_client\"");
            out.println("  }");
            out.println("  EOF");
        }
        out.println();
        out.println();
        out.println("Use '" + KcAdmMain.CMD + " help' for general information and a list of commands");
        return sb.toString();
    }
}

