/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.metamodel.mapping;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;
import org.hibernate.AssertionFailure;
import org.hibernate.HibernateException;
import org.hibernate.internal.util.collections.CollectionHelper;
import org.hibernate.metamodel.mapping.DiscriminatorConverter;
import org.hibernate.metamodel.mapping.DiscriminatorValueDetails;
import org.hibernate.metamodel.mapping.internal.DiscriminatorValueDetailsImpl;
import org.hibernate.metamodel.model.domain.NavigableRole;
import org.hibernate.metamodel.spi.MappingMetamodelImplementor;
import org.hibernate.persister.entity.DiscriminatorHelper;
import org.hibernate.type.BasicType;
import org.hibernate.type.descriptor.java.JavaType;

public class MappedDiscriminatorConverter<O, R>
extends DiscriminatorConverter<O, R> {
    private final Map<Object, DiscriminatorValueDetails> discriminatorValueToEntityNameMap;
    private final Map<String, DiscriminatorValueDetails> entityNameToDiscriminatorValueMap;

    public static <O, R> MappedDiscriminatorConverter<O, R> fromValueMappings(NavigableRole role, JavaType<O> domainJavaType, BasicType<R> underlyingJdbcMapping, Map<Object, String> valueMappings, MappingMetamodelImplementor mappingMetamodel) {
        ArrayList<DiscriminatorValueDetails> valueDetailsList = CollectionHelper.arrayList(valueMappings.size());
        valueMappings.forEach((value, entityName) -> {
            DiscriminatorValueDetailsImpl valueDetails = new DiscriminatorValueDetailsImpl(value, mappingMetamodel.getEntityDescriptor((String)entityName));
            valueDetailsList.add(valueDetails);
        });
        return new MappedDiscriminatorConverter<O, R>(role, domainJavaType, underlyingJdbcMapping.getJavaTypeDescriptor(), valueDetailsList);
    }

    public MappedDiscriminatorConverter(NavigableRole discriminatorRole, JavaType<O> domainJavaType, JavaType<R> relationalJavaType, List<DiscriminatorValueDetails> valueMappings) {
        super(discriminatorRole.getFullPath(), domainJavaType, relationalJavaType);
        this.discriminatorValueToEntityNameMap = CollectionHelper.concurrentMap(valueMappings.size());
        this.entityNameToDiscriminatorValueMap = CollectionHelper.concurrentMap(valueMappings.size());
        valueMappings.forEach(valueDetails -> {
            this.discriminatorValueToEntityNameMap.put(valueDetails.getValue(), (DiscriminatorValueDetails)valueDetails);
            this.entityNameToDiscriminatorValueMap.put(valueDetails.getIndicatedEntityName(), (DiscriminatorValueDetails)valueDetails);
        });
    }

    @Override
    public DiscriminatorValueDetails getDetailsForRelationalForm(R relationalForm) {
        return this.getDetailsForDiscriminatorValue(relationalForm);
    }

    @Override
    public DiscriminatorValueDetails getDetailsForEntityName(String entityName) {
        DiscriminatorValueDetails valueDetails = this.entityNameToDiscriminatorValueMap.get(entityName);
        if (valueDetails != null) {
            return valueDetails;
        }
        throw new AssertionFailure("Unrecognized entity name: " + entityName);
    }

    @Override
    public DiscriminatorValueDetails getDetailsForDiscriminatorValue(Object value) {
        if (value == null) {
            return this.discriminatorValueToEntityNameMap.get(DiscriminatorHelper.NULL_DISCRIMINATOR);
        }
        DiscriminatorValueDetails valueMatch = this.discriminatorValueToEntityNameMap.get(value);
        if (valueMatch != null) {
            return valueMatch;
        }
        DiscriminatorValueDetails notNullMatch = this.discriminatorValueToEntityNameMap.get(DiscriminatorHelper.NOT_NULL_DISCRIMINATOR);
        if (notNullMatch != null) {
            return notNullMatch;
        }
        throw new HibernateException("Unrecognized discriminator value: " + value);
    }

    @Override
    public void forEachValueDetail(Consumer<DiscriminatorValueDetails> consumer) {
        this.discriminatorValueToEntityNameMap.forEach((value, detail) -> consumer.accept((DiscriminatorValueDetails)detail));
    }

    @Override
    public <X> X fromValueDetails(Function<DiscriminatorValueDetails, X> handler) {
        for (DiscriminatorValueDetails detail : this.discriminatorValueToEntityNameMap.values()) {
            X result = handler.apply(detail);
            if (result == null) continue;
            return result;
        }
        return null;
    }
}

