/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.authorization.policy.provider.role;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.stream.Collectors;
import org.keycloak.Config;
import org.keycloak.authorization.AuthorizationProvider;
import org.keycloak.authorization.model.Policy;
import org.keycloak.authorization.policy.provider.PolicyProvider;
import org.keycloak.authorization.policy.provider.PolicyProviderFactory;
import org.keycloak.authorization.policy.provider.role.RolePolicyProvider;
import org.keycloak.models.ClientModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.KeycloakSessionFactory;
import org.keycloak.models.RealmModel;
import org.keycloak.models.RoleModel;
import org.keycloak.representations.idm.authorization.PolicyRepresentation;
import org.keycloak.representations.idm.authorization.RolePolicyRepresentation;
import org.keycloak.util.JsonSerialization;
import org.keycloak.utils.StringUtil;

public class RolePolicyProviderFactory
implements PolicyProviderFactory<RolePolicyRepresentation> {
    private RolePolicyProvider provider = new RolePolicyProvider(this::toRepresentation);

    public String getName() {
        return "Role";
    }

    public String getGroup() {
        return "Identity Based";
    }

    public PolicyProvider create(AuthorizationProvider authorization) {
        return this.provider;
    }

    public PolicyProvider create(KeycloakSession session) {
        return this.provider;
    }

    public RolePolicyRepresentation toRepresentation(Policy policy, AuthorizationProvider authorization) {
        RolePolicyRepresentation representation = new RolePolicyRepresentation();
        String roles = (String)policy.getConfig().get("roles");
        representation.setRoles(this.getRoles(roles, authorization.getRealm()));
        String fetchRoles = (String)policy.getConfig().get("fetchRoles");
        if (StringUtil.isNotBlank((String)fetchRoles)) {
            representation.setFetchRoles(Boolean.valueOf(Boolean.parseBoolean(fetchRoles)));
        }
        return representation;
    }

    public Class<RolePolicyRepresentation> getRepresentationType() {
        return RolePolicyRepresentation.class;
    }

    public void onCreate(Policy policy, RolePolicyRepresentation representation, AuthorizationProvider authorization) {
        this.updateRoles(policy, representation, authorization);
    }

    public void onUpdate(Policy policy, RolePolicyRepresentation representation, AuthorizationProvider authorization) {
        this.updateRoles(policy, representation, authorization);
    }

    public void onImport(Policy policy, PolicyRepresentation representation, AuthorizationProvider authorization) {
        this.updateRoles(policy, authorization, this.getRoles((String)representation.getConfig().get("roles"), authorization.getRealm()));
        String fetchRoles = (String)representation.getConfig().get("fetchRoles");
        if (StringUtil.isNotBlank((String)fetchRoles)) {
            policy.putConfig("fetchRoles", fetchRoles);
        }
    }

    public void onExport(Policy policy, PolicyRepresentation representation, AuthorizationProvider authorizationProvider) {
        HashMap<String, String> config = new HashMap<String, String>();
        Set roles = this.toRepresentation(policy, authorizationProvider).getRoles();
        for (RolePolicyRepresentation.RoleDefinition roleDefinition : roles) {
            RoleModel role = authorizationProvider.getRealm().getRoleById(roleDefinition.getId());
            if (role.isClientRole()) {
                roleDefinition.setId(((ClientModel)ClientModel.class.cast(role.getContainer())).getClientId() + "/" + role.getName());
                continue;
            }
            roleDefinition.setId(role.getName());
        }
        try {
            config.put("roles", JsonSerialization.writeValueAsString((Object)roles));
        }
        catch (IOException cause) {
            throw new RuntimeException("Failed to export role policy [" + policy.getName() + "]", cause);
        }
        String fetchRoles = (String)policy.getConfig().get("fetchRoles");
        if (StringUtil.isNotBlank((String)fetchRoles)) {
            config.put("fetchRoles", fetchRoles);
        }
        representation.setConfig(config);
    }

    private void updateRoles(Policy policy, RolePolicyRepresentation representation, AuthorizationProvider authorization) {
        if (representation.isFetchRoles() != null) {
            policy.putConfig("fetchRoles", String.valueOf(representation.isFetchRoles()));
        }
        this.updateRoles(policy, authorization, representation.getRoles());
    }

    private void updateRoles(Policy policy, AuthorizationProvider authorization, Set<RolePolicyRepresentation.RoleDefinition> roles) {
        HashSet<RolePolicyRepresentation.RoleDefinition> updatedRoles = new HashSet<RolePolicyRepresentation.RoleDefinition>();
        if (roles != null) {
            RealmModel realm = authorization.getRealm();
            for (RolePolicyRepresentation.RoleDefinition definition : roles) {
                RoleModel role = this.getRole(definition, realm);
                if (role == null) continue;
                definition.setId(role.getId());
                updatedRoles.add(definition);
            }
        }
        try {
            policy.putConfig("roles", JsonSerialization.writeValueAsString(updatedRoles));
        }
        catch (IOException cause) {
            throw new RuntimeException("Failed to serialize roles", cause);
        }
    }

    public void init(Config.Scope config) {
    }

    public void postInit(KeycloakSessionFactory factory) {
    }

    public void close() {
    }

    public String getId() {
        return "role";
    }

    private Set<RolePolicyRepresentation.RoleDefinition> getRoles(String rawRoles, RealmModel realm) {
        if (rawRoles != null) {
            try {
                return Arrays.stream((RolePolicyRepresentation.RoleDefinition[])JsonSerialization.readValue((String)rawRoles, RolePolicyRepresentation.RoleDefinition[].class)).filter(definition -> this.getRole((RolePolicyRepresentation.RoleDefinition)definition, realm) != null).sorted().collect(Collectors.toCollection(LinkedHashSet::new));
            }
            catch (IOException e) {
                throw new RuntimeException("Could not parse roles from config: [" + rawRoles + "]", e);
            }
        }
        return Collections.emptySet();
    }

    private RoleModel getRole(RolePolicyRepresentation.RoleDefinition definition, RealmModel realm) {
        RoleModel role;
        String roleName = definition.getId();
        String clientId = null;
        int clientIdSeparator = roleName.indexOf("/");
        if (clientIdSeparator != -1) {
            clientId = roleName.substring(0, clientIdSeparator);
            roleName = roleName.substring(clientIdSeparator + 1);
        }
        if (clientId == null) {
            role = realm.getRole(roleName);
            if (role == null) {
                role = realm.getRoleById(roleName);
            }
        } else {
            ClientModel client = realm.getClientByClientId(clientId);
            if (client == null) {
                throw new RuntimeException("Client with id [" + clientId + "] not found.");
            }
            role = client.getRole(roleName);
        }
        return role;
    }
}

