/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.organization.admin.resource;

import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DefaultValue;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.core.UriInfo;
import jakarta.ws.rs.ext.Provider;
import java.net.URI;
import java.util.Map;
import java.util.stream.Stream;
import org.eclipse.microprofile.openapi.annotations.Operation;
import org.eclipse.microprofile.openapi.annotations.extensions.Extension;
import org.eclipse.microprofile.openapi.annotations.parameters.Parameter;
import org.eclipse.microprofile.openapi.annotations.tags.Tag;
import org.jboss.logging.Logger;
import org.jboss.resteasy.reactive.NoCache;
import org.keycloak.events.admin.OperationType;
import org.keycloak.events.admin.ResourceType;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.ModelDuplicateException;
import org.keycloak.models.ModelValidationException;
import org.keycloak.models.OrganizationModel;
import org.keycloak.models.utils.ModelToRepresentation;
import org.keycloak.models.utils.RepresentationToModel;
import org.keycloak.organization.OrganizationProvider;
import org.keycloak.organization.admin.resource.OrganizationMemberResource;
import org.keycloak.organization.admin.resource.OrganizationResource;
import org.keycloak.organization.utils.Organizations;
import org.keycloak.organization.validation.OrganizationsValidation;
import org.keycloak.representations.idm.OrganizationRepresentation;
import org.keycloak.services.ErrorResponse;
import org.keycloak.services.resources.admin.AdminEventBuilder;
import org.keycloak.services.resources.admin.permissions.AdminPermissionEvaluator;
import org.keycloak.utils.ReservedCharValidator;
import org.keycloak.utils.SearchQueryUtils;
import org.keycloak.utils.StringUtil;

@Provider
@Extension(name="x-smallrye-profile-admin", value="")
public class OrganizationsResource {
    private final KeycloakSession session;
    private final OrganizationProvider provider;
    private final AdminPermissionEvaluator auth;
    private final AdminEventBuilder adminEvent;
    private static final Logger logger = Logger.getLogger(OrganizationsResource.class);

    public OrganizationsResource() {
        this(null, null, null);
    }

    public OrganizationsResource(KeycloakSession session, AdminPermissionEvaluator auth, AdminEventBuilder adminEvent) {
        this.session = session;
        this.provider = session == null ? null : (OrganizationProvider)session.getProvider(OrganizationProvider.class);
        this.auth = auth;
        this.adminEvent = adminEvent.resource(ResourceType.ORGANIZATION);
    }

    @POST
    @Consumes(value={"application/json"})
    @Tag(name="Organizations")
    @Operation(summary="Creates a new organization")
    public Response create(OrganizationRepresentation organization) {
        this.auth.realm().requireManageRealm();
        Organizations.checkEnabled(this.provider);
        if (organization == null) {
            throw ErrorResponse.error("Organization cannot be null.", Response.Status.BAD_REQUEST);
        }
        ReservedCharValidator.validateNoSpace((String)organization.getAlias());
        try {
            OrganizationsValidation.validateUrl((String)organization.getRedirectUrl());
            OrganizationModel model = this.provider.create(organization.getName(), organization.getAlias());
            RepresentationToModel.toModel((OrganizationRepresentation)organization, (OrganizationModel)model);
            organization.setId(model.getId());
            this.adminEvent.operation(OperationType.CREATE).resourcePath((UriInfo)this.session.getContext().getUri(), model.getId()).representation(organization).success();
            return Response.created((URI)this.session.getContext().getUri().getAbsolutePathBuilder().path(model.getId()).build(new Object[0])).build();
        }
        catch (ModelValidationException | OrganizationsValidation.OrganizationValidationException ex) {
            throw ErrorResponse.error(ex.getMessage(), Response.Status.BAD_REQUEST);
        }
        catch (ModelDuplicateException mde) {
            throw ErrorResponse.error(mde.getMessage(), Response.Status.CONFLICT);
        }
    }

    @GET
    @Produces(value={"application/json"})
    @NoCache
    @Tag(name="Organizations")
    @Operation(summary="Returns a paginated list of organizations filtered according to the specified parameters")
    public Stream<OrganizationRepresentation> search(@Parameter(description="A String representing either an organization name or domain") @QueryParam(value="search") String search, @Parameter(description="A query to search for custom attributes, in the format 'key1:value2 key2:value2'") @QueryParam(value="q") String searchQuery, @Parameter(description="Boolean which defines whether the param 'search' must match exactly or not") @QueryParam(value="exact") Boolean exact, @Parameter(description="The position of the first result to be processed (pagination offset)") @QueryParam(value="first") @DefaultValue(value="0") Integer first, @Parameter(description="The maximum number of results to be returned - defaults to 10") @QueryParam(value="max") @DefaultValue(value="10") Integer max) {
        this.auth.realm().requireManageRealm();
        Organizations.checkEnabled(this.provider);
        if (StringUtil.isNotBlank((String)searchQuery)) {
            Map<String, String> attributes = SearchQueryUtils.getFields(searchQuery);
            return this.provider.getAllStream(attributes, first, max).map(ModelToRepresentation::toBriefRepresentation);
        }
        return this.provider.getAllStream(search, exact, first, max).map(ModelToRepresentation::toBriefRepresentation);
    }

    @Path(value="{id}")
    public OrganizationResource get(@PathParam(value="id") String id) {
        this.auth.realm().requireManageRealm();
        Organizations.checkEnabled(this.provider);
        if (StringUtil.isBlank((String)id)) {
            throw ErrorResponse.error("Id cannot be null.", Response.Status.BAD_REQUEST);
        }
        OrganizationModel organizationModel = this.provider.getById(id);
        if (organizationModel == null) {
            throw ErrorResponse.error("Organization not found.", Response.Status.NOT_FOUND);
        }
        this.session.getContext().setOrganization(organizationModel);
        return new OrganizationResource(this.session, organizationModel, this.adminEvent);
    }

    @Path(value="members/{id}/organizations")
    @GET
    @Produces(value={"application/json"})
    @NoCache
    @Tag(name="Organizations")
    @Operation(summary="Returns the organizations associated with the user that has the specified id")
    public Stream<OrganizationRepresentation> getOrganizations(@PathParam(value="id") String id) {
        return new OrganizationMemberResource(this.session, null, this.adminEvent).getOrganizations(id);
    }
}

