/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.quarkus.runtime.cli.command;

import java.util.Optional;
import org.keycloak.quarkus.runtime.Environment;
import org.keycloak.quarkus.runtime.Messages;
import org.keycloak.quarkus.runtime.cli.command.AbstractStartCommand;
import org.keycloak.quarkus.runtime.cli.command.HelpAllMixin;
import org.keycloak.quarkus.runtime.cli.command.ImportRealmMixin;
import org.keycloak.quarkus.runtime.cli.command.OptimizedMixin;
import org.keycloak.quarkus.runtime.configuration.Configuration;
import picocli.CommandLine;

@CommandLine.Command(name="start", header={"Start the server."}, description={"%nUse this command to run the server in production."}, footer={"%nBy default, this command tries to update the server configuration by running a 'build' before starting the server. You can disable this behavior by using the '--optimized' option:%n%n      $ ${PARENT-COMMAND-FULL-NAME:-$PARENTCOMMAND} ${COMMAND-NAME} '--optimized'%n%nBy doing that, the server should start faster based on any previous configuration you have set when manually running the 'build' command."})
public final class Start
extends AbstractStartCommand
implements Runnable {
    public static final String NAME = "start";
    @CommandLine.Mixin
    OptimizedMixin optimizedMixin;
    @CommandLine.Mixin
    ImportRealmMixin importRealmMixin;
    @CommandLine.Mixin
    HelpAllMixin helpAllMixin;

    @Override
    protected void doBeforeRun() {
        this.devProfileNotAllowedError();
    }

    private void devProfileNotAllowedError() {
        if (Start.isDevProfileNotAllowed()) {
            this.executionError(this.spec.commandLine(), Messages.devProfileNotAllowedError(NAME));
        }
    }

    public static boolean isDevProfileNotAllowed() {
        Optional<String> currentProfile = Optional.ofNullable(org.keycloak.common.util.Environment.getProfile());
        Optional<String> persistedProfile = Configuration.getRawPersistedProperty("kc.profile");
        Environment.setProfile(currentProfile.orElse(persistedProfile.orElse("prod")));
        return Environment.isDevProfile();
    }

    @Override
    public boolean includeRuntime() {
        return true;
    }

    @Override
    public String getName() {
        return NAME;
    }
}

