/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.crypto.def;

import java.security.InvalidAlgorithmParameterException;
import java.security.KeyFactory;
import java.security.KeyPairGenerator;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Provider;
import java.security.Security;
import java.security.Signature;
import java.security.cert.CertPathBuilder;
import java.security.cert.CertStore;
import java.security.cert.CertStoreParameters;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.CollectionCertStoreParameters;
import java.security.spec.ECParameterSpec;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.crypto.Cipher;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKeyFactory;
import javax.net.ssl.SSLSocketFactory;
import org.bouncycastle.jce.ECNamedCurveTable;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.jce.spec.ECNamedCurveParameterSpec;
import org.bouncycastle.jce.spec.ECNamedCurveSpec;
import org.jboss.logging.Logger;
import org.keycloak.common.crypto.CertificateUtilsProvider;
import org.keycloak.common.crypto.CryptoProvider;
import org.keycloak.common.crypto.ECDSACryptoProvider;
import org.keycloak.common.crypto.PemUtilsProvider;
import org.keycloak.common.crypto.UserIdentityExtractorProvider;
import org.keycloak.common.util.BouncyIntegration;
import org.keycloak.common.util.KeystoreUtil;
import org.keycloak.crypto.JavaAlgorithm;
import org.keycloak.crypto.def.AesKeyWrapAlgorithmProvider;
import org.keycloak.crypto.def.BCCertificateUtilsProvider;
import org.keycloak.crypto.def.BCECDSACryptoProvider;
import org.keycloak.crypto.def.BCEcdhEsAlgorithmProvider;
import org.keycloak.crypto.def.BCOCSPProvider;
import org.keycloak.crypto.def.BCPemUtilsProvider;
import org.keycloak.crypto.def.BCUserIdentityExtractorProvider;
import org.keycloak.crypto.def.DefaultRsaKeyEncryption256JWEAlgorithmProvider;
import org.keycloak.crypto.def.DefaultRsaKeyEncryptionJWEAlgorithmProvider;

public class DefaultCryptoProvider
implements CryptoProvider {
    private static final Logger log = Logger.getLogger(DefaultCryptoProvider.class);
    private final Provider bcProvider;
    private Map<String, Object> providers = new ConcurrentHashMap<String, Object>();

    public DefaultCryptoProvider() {
        Provider existingBc = Security.getProvider("BC");
        this.bcProvider = existingBc == null ? new BouncyCastleProvider() : existingBc;
        this.providers.put("A128KW", new AesKeyWrapAlgorithmProvider());
        this.providers.put("RSA1_5", new DefaultRsaKeyEncryptionJWEAlgorithmProvider("RSA/ECB/PKCS1Padding"));
        this.providers.put("RSA-OAEP", new DefaultRsaKeyEncryptionJWEAlgorithmProvider("RSA/ECB/OAEPWithSHA-1AndMGF1Padding"));
        this.providers.put("RSA-OAEP-256", new DefaultRsaKeyEncryption256JWEAlgorithmProvider("RSA/ECB/OAEPWithSHA-256AndMGF1Padding"));
        this.providers.put("ECDH-ES", new BCEcdhEsAlgorithmProvider());
        this.providers.put("ECDH-ES+A128KW", new BCEcdhEsAlgorithmProvider());
        this.providers.put("ECDH-ES+A192KW", new BCEcdhEsAlgorithmProvider());
        this.providers.put("ECDH-ES+A256KW", new BCEcdhEsAlgorithmProvider());
        if (existingBc == null) {
            Security.addProvider(this.bcProvider);
            log.debugv("Loaded {0} security provider", (Object)this.bcProvider.getClass().getName());
        } else {
            log.debugv("Security provider {0} already loaded", (Object)this.bcProvider.getClass().getName());
        }
    }

    public Provider getBouncyCastleProvider() {
        return this.bcProvider;
    }

    public <T> T getAlgorithmProvider(Class<T> clazz, String algorithmType) {
        Object o = this.providers.get(algorithmType);
        if (o == null) {
            throw new IllegalArgumentException("Not found provider of algorithm type: " + algorithmType);
        }
        return clazz.cast(o);
    }

    public CertificateUtilsProvider getCertificateUtils() {
        return new BCCertificateUtilsProvider();
    }

    public PemUtilsProvider getPemUtils() {
        return new BCPemUtilsProvider();
    }

    public ECParameterSpec createECParams(String curveName) {
        ECNamedCurveParameterSpec spec = ECNamedCurveTable.getParameterSpec((String)curveName);
        return new ECNamedCurveSpec("prime256v1", spec.getCurve(), spec.getG(), spec.getN());
    }

    public UserIdentityExtractorProvider getIdentityExtractorProvider() {
        return new BCUserIdentityExtractorProvider();
    }

    public ECDSACryptoProvider getEcdsaCryptoProvider() {
        return new BCECDSACryptoProvider();
    }

    public <T> T getOCSPProver(Class<T> clazz) {
        return clazz.cast((Object)new BCOCSPProvider());
    }

    public KeyPairGenerator getKeyPairGen(String algorithm) throws NoSuchAlgorithmException, NoSuchProviderException {
        return KeyPairGenerator.getInstance(algorithm, BouncyIntegration.PROVIDER);
    }

    public KeyFactory getKeyFactory(String algorithm) throws NoSuchAlgorithmException, NoSuchProviderException {
        return KeyFactory.getInstance(algorithm, BouncyIntegration.PROVIDER);
    }

    public Cipher getAesCbcCipher() throws NoSuchAlgorithmException, NoSuchProviderException, NoSuchPaddingException {
        return Cipher.getInstance("AES/CBC/PKCS7Padding", BouncyIntegration.PROVIDER);
    }

    public Cipher getAesGcmCipher() throws NoSuchAlgorithmException, NoSuchProviderException, NoSuchPaddingException {
        return Cipher.getInstance("AES/GCM/NoPadding", BouncyIntegration.PROVIDER);
    }

    public SecretKeyFactory getSecretKeyFact(String keyAlgorithm) throws NoSuchAlgorithmException, NoSuchProviderException {
        return SecretKeyFactory.getInstance(keyAlgorithm, BouncyIntegration.PROVIDER);
    }

    public KeyStore getKeyStore(KeystoreUtil.KeystoreFormat format) throws KeyStoreException, NoSuchProviderException {
        if (format == KeystoreUtil.KeystoreFormat.JKS) {
            return KeyStore.getInstance(format.toString());
        }
        return KeyStore.getInstance(format.toString(), BouncyIntegration.PROVIDER);
    }

    public CertificateFactory getX509CertFactory() throws CertificateException, NoSuchProviderException {
        return CertificateFactory.getInstance("X.509", BouncyIntegration.PROVIDER);
    }

    public CertStore getCertStore(CollectionCertStoreParameters certStoreParams) throws InvalidAlgorithmParameterException, NoSuchAlgorithmException, NoSuchProviderException {
        return CertStore.getInstance("Collection", (CertStoreParameters)certStoreParams, BouncyIntegration.PROVIDER);
    }

    public CertPathBuilder getCertPathBuilder() throws NoSuchAlgorithmException, NoSuchProviderException {
        return CertPathBuilder.getInstance("PKIX", BouncyIntegration.PROVIDER);
    }

    public Signature getSignature(String sigAlgName) throws NoSuchAlgorithmException, NoSuchProviderException {
        return Signature.getInstance(JavaAlgorithm.getJavaAlgorithm((String)sigAlgName), BouncyIntegration.PROVIDER);
    }

    public SSLSocketFactory wrapFactoryForTruststore(SSLSocketFactory delegate) {
        return delegate;
    }
}

