/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.dialect.function.array;

import java.util.List;
import java.util.function.Supplier;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.hibernate.metamodel.mapping.BasicValuedMapping;
import org.hibernate.metamodel.mapping.MappingModelExpressible;
import org.hibernate.metamodel.model.domain.DomainType;
import org.hibernate.query.ReturnableType;
import org.hibernate.query.sqm.SqmExpressible;
import org.hibernate.query.sqm.produce.function.FunctionReturnTypeResolver;
import org.hibernate.query.sqm.sql.SqmToSqlAstConverter;
import org.hibernate.query.sqm.tree.SqmTypedNode;
import org.hibernate.sql.ast.tree.SqlAstNode;
import org.hibernate.type.BasicPluralType;
import org.hibernate.type.spi.TypeConfiguration;

public class ArrayViaArgumentReturnTypeResolver
implements FunctionReturnTypeResolver {
    public static final FunctionReturnTypeResolver DEFAULT_INSTANCE = new ArrayViaArgumentReturnTypeResolver(0);
    private final int arrayIndex;

    public ArrayViaArgumentReturnTypeResolver(int arrayIndex) {
        this.arrayIndex = arrayIndex;
    }

    @Override
    public ReturnableType<?> resolveFunctionReturnType(ReturnableType<?> impliedType, @Nullable SqmToSqlAstConverter converter, List<? extends SqmTypedNode<?>> arguments, TypeConfiguration typeConfiguration) {
        DomainType<?> type;
        MappingModelExpressible<?> inferredType;
        MappingModelExpressible<?> mappingModelExpressible = inferredType = converter == null ? null : converter.resolveFunctionImpliedReturnType();
        if (inferredType != null) {
            if (inferredType instanceof ReturnableType) {
                return (ReturnableType)((Object)inferredType);
            }
            if (inferredType instanceof BasicValuedMapping) {
                return (ReturnableType)((Object)((BasicValuedMapping)inferredType).getJdbcMapping());
            }
        }
        if (impliedType != null) {
            return impliedType;
        }
        SqmExpressible<?> expressible = arguments.get(this.arrayIndex).getExpressible();
        if (expressible != null && (type = expressible.getSqmType()) instanceof BasicPluralType) {
            return (ReturnableType)type;
        }
        return null;
    }

    @Override
    public BasicValuedMapping resolveFunctionReturnType(Supplier<BasicValuedMapping> impliedTypeAccess, List<? extends SqlAstNode> arguments) {
        return null;
    }
}

