/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.sql.results.graph.collection.internal;

import java.util.List;
import java.util.function.BiConsumer;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.hibernate.LockMode;
import org.hibernate.collection.spi.PersistentSet;
import org.hibernate.internal.log.LoggingHelper;
import org.hibernate.metamodel.mapping.PluralAttributeMapping;
import org.hibernate.spi.NavigablePath;
import org.hibernate.sql.results.graph.AssemblerCreationState;
import org.hibernate.sql.results.graph.DomainResult;
import org.hibernate.sql.results.graph.DomainResultAssembler;
import org.hibernate.sql.results.graph.Fetch;
import org.hibernate.sql.results.graph.Initializer;
import org.hibernate.sql.results.graph.InitializerData;
import org.hibernate.sql.results.graph.InitializerParent;
import org.hibernate.sql.results.graph.collection.internal.AbstractImmediateCollectionInitializer;
import org.hibernate.sql.results.jdbc.spi.RowProcessingState;

public class SetInitializer
extends AbstractImmediateCollectionInitializer<AbstractImmediateCollectionInitializer.ImmediateCollectionInitializerData> {
    private final DomainResultAssembler<?> elementAssembler;

    public SetInitializer(NavigablePath navigablePath, PluralAttributeMapping setDescriptor, InitializerParent<?> parent, LockMode lockMode, DomainResult<?> collectionKeyResult, DomainResult<?> collectionValueKeyResult, boolean isResultInitializer, AssemblerCreationState creationState, Fetch elementFetch) {
        super(navigablePath, setDescriptor, parent, lockMode, collectionKeyResult, collectionValueKeyResult, isResultInitializer, creationState);
        this.elementAssembler = elementFetch.createAssembler(this, creationState);
    }

    @Override
    protected void forEachSubInitializer(BiConsumer<Initializer<?>, RowProcessingState> consumer, InitializerData data) {
        super.forEachSubInitializer(consumer, data);
        Initializer<?> initializer = this.elementAssembler.getInitializer();
        if (initializer != null) {
            consumer.accept(initializer, data.getRowProcessingState());
        }
    }

    @Override
    public @Nullable PersistentSet<?> getCollectionInstance(AbstractImmediateCollectionInitializer.ImmediateCollectionInitializerData data) {
        return (PersistentSet)super.getCollectionInstance(data);
    }

    @Override
    protected void readCollectionRow(AbstractImmediateCollectionInitializer.ImmediateCollectionInitializerData data, List<Object> loadingState) {
        RowProcessingState rowProcessingState = data.getRowProcessingState();
        Object element = this.elementAssembler.assemble(rowProcessingState);
        if (element == null) {
            return;
        }
        loadingState.add(element);
    }

    @Override
    protected void initializeSubInstancesFromParent(AbstractImmediateCollectionInitializer.ImmediateCollectionInitializerData data) {
        Initializer<?> initializer = this.elementAssembler.getInitializer();
        if (initializer != null) {
            RowProcessingState rowProcessingState = data.getRowProcessingState();
            PersistentSet<?> set = this.getCollectionInstance(data);
            assert (set != null);
            for (Object element : set) {
                initializer.initializeInstanceFromParent(element, rowProcessingState);
            }
        }
    }

    @Override
    protected void resolveInstanceSubInitializers(AbstractImmediateCollectionInitializer.ImmediateCollectionInitializerData data) {
        Initializer<?> initializer = this.elementAssembler.getInitializer();
        if (initializer != null) {
            RowProcessingState rowProcessingState = data.getRowProcessingState();
            PersistentSet<?> set = this.getCollectionInstance(data);
            assert (set != null);
            for (Object element : set) {
                initializer.resolveInstance(element, rowProcessingState);
            }
        }
    }

    @Override
    public DomainResultAssembler<?> getIndexAssembler() {
        return null;
    }

    @Override
    public DomainResultAssembler<?> getElementAssembler() {
        return this.elementAssembler;
    }

    public String toString() {
        return "SetInitializer(" + LoggingHelper.toLoggableString(this.getNavigablePath()) + ")";
    }
}

