/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.vertx.http.runtime;

import io.netty.util.AsciiString;
import io.quarkus.vertx.http.runtime.ProxyConfig;
import io.quarkus.vertx.http.runtime.TrustedProxyCheck;
import java.util.Collection;
import java.util.List;

public class ForwardingProxyOptions {
    public final boolean proxyAddressForwarding;
    final boolean allowForwarded;
    final boolean allowXForwarded;
    final boolean enableForwardedHost;
    final boolean enableForwardedPrefix;
    final AsciiString forwardedHostHeader;
    final AsciiString forwardedPrefixHeader;
    public final TrustedProxyCheck.TrustedProxyCheckBuilder trustedProxyCheckBuilder;

    public ForwardingProxyOptions(boolean proxyAddressForwarding, boolean allowForwarded, boolean allowXForwarded, boolean enableForwardedHost, AsciiString forwardedHostHeader, boolean enableForwardedPrefix, AsciiString forwardedPrefixHeader, TrustedProxyCheck.TrustedProxyCheckBuilder trustedProxyCheckBuilder) {
        this.proxyAddressForwarding = proxyAddressForwarding;
        this.allowForwarded = allowForwarded;
        this.allowXForwarded = allowXForwarded;
        this.enableForwardedHost = enableForwardedHost;
        this.enableForwardedPrefix = enableForwardedPrefix;
        this.forwardedHostHeader = forwardedHostHeader;
        this.forwardedPrefixHeader = forwardedPrefixHeader;
        this.trustedProxyCheckBuilder = trustedProxyCheckBuilder;
    }

    public static ForwardingProxyOptions from(ProxyConfig proxy) {
        boolean proxyAddressForwarding = proxy.proxyAddressForwarding;
        boolean allowForwarded = proxy.allowForwarded;
        boolean allowXForwarded = proxy.allowXForwarded.orElse(!allowForwarded);
        boolean enableForwardedHost = proxy.enableForwardedHost;
        boolean enableForwardedPrefix = proxy.enableForwardedPrefix;
        AsciiString forwardedPrefixHeader = AsciiString.cached((String)proxy.forwardedPrefixHeader);
        AsciiString forwardedHostHeader = AsciiString.cached((String)proxy.forwardedHostHeader);
        List<TrustedProxyCheck.TrustedProxyCheckPart> parts = proxy.trustedProxies.isPresent() ? List.copyOf((Collection)proxy.trustedProxies.get()) : List.of();
        TrustedProxyCheck.TrustedProxyCheckBuilder proxyCheckBuilder = !allowXForwarded && !allowForwarded || parts.isEmpty() ? null : TrustedProxyCheck.TrustedProxyCheckBuilder.builder(parts);
        return new ForwardingProxyOptions(proxyAddressForwarding, allowForwarded, allowXForwarded, enableForwardedHost, forwardedHostHeader, enableForwardedPrefix, forwardedPrefixHeader, proxyCheckBuilder);
    }
}

