/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.arc.processor.bcextensions;

import io.quarkus.arc.processor.Annotations;
import io.quarkus.arc.processor.bcextensions.AnnotationInfoImpl;
import jakarta.enterprise.inject.build.compatible.spi.DeclarationConfig;
import jakarta.enterprise.lang.model.AnnotationInfo;
import java.lang.annotation.Annotation;
import java.util.function.Predicate;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.Declaration;
import org.jboss.jandex.IndexView;
import org.jboss.jandex.MutableAnnotationOverlay;

abstract class DeclarationConfigImpl<JandexDeclaration extends Declaration, THIS extends DeclarationConfigImpl<JandexDeclaration, THIS>>
implements DeclarationConfig {
    final IndexView jandexIndex;
    final MutableAnnotationOverlay annotationOverlay;
    final JandexDeclaration jandexDeclaration;

    DeclarationConfigImpl(IndexView jandexIndex, MutableAnnotationOverlay annotationOverlay, JandexDeclaration jandexDeclaration) {
        this.jandexIndex = jandexIndex;
        this.annotationOverlay = annotationOverlay;
        this.jandexDeclaration = jandexDeclaration;
    }

    public THIS addAnnotation(Class<? extends Annotation> annotationType) {
        this.annotationOverlay.addAnnotation(this.jandexDeclaration, AnnotationInstance.builder(annotationType).build());
        return (THIS)this;
    }

    public THIS addAnnotation(AnnotationInfo annotation) {
        this.annotationOverlay.addAnnotation(this.jandexDeclaration, ((AnnotationInfoImpl)annotation).jandexAnnotation);
        return (THIS)this;
    }

    public THIS addAnnotation(Annotation annotation) {
        this.annotationOverlay.addAnnotation(this.jandexDeclaration, Annotations.jandexAnnotation(annotation));
        return (THIS)this;
    }

    public THIS removeAnnotation(final Predicate<AnnotationInfo> predicate) {
        this.annotationOverlay.removeAnnotations(this.jandexDeclaration, (Predicate)new Predicate<AnnotationInstance>(){

            @Override
            public boolean test(AnnotationInstance annotationInstance) {
                return predicate.test(new AnnotationInfoImpl(DeclarationConfigImpl.this.jandexIndex, DeclarationConfigImpl.this.annotationOverlay, annotationInstance));
            }
        });
        return (THIS)this;
    }

    public THIS removeAllAnnotations() {
        this.annotationOverlay.removeAnnotations(this.jandexDeclaration, ignored -> true);
        return (THIS)this;
    }
}

