/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.sessions.infinispan.remote;

import io.reactivex.rxjava3.core.Flowable;
import java.lang.invoke.MethodHandles;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CompletionStage;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.infinispan.client.hotrod.RemoteCache;
import org.infinispan.commons.api.query.Query;
import org.infinispan.commons.util.concurrent.AggregateCompletionStage;
import org.infinispan.commons.util.concurrent.CompletionStages;
import org.jboss.logging.Logger;
import org.keycloak.cluster.ClusterProvider;
import org.keycloak.common.Profile;
import org.keycloak.models.AuthenticatedClientSessionModel;
import org.keycloak.models.ClientModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.KeycloakSessionFactory;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserModel;
import org.keycloak.models.UserSessionModel;
import org.keycloak.models.UserSessionProvider;
import org.keycloak.models.light.LightweightUserAdapter;
import org.keycloak.models.session.UserSessionPersisterProvider;
import org.keycloak.models.sessions.infinispan.changes.remote.updater.BaseUpdater;
import org.keycloak.models.sessions.infinispan.changes.remote.updater.Expiration;
import org.keycloak.models.sessions.infinispan.changes.remote.updater.client.AuthenticatedClientSessionUpdater;
import org.keycloak.models.sessions.infinispan.changes.remote.updater.user.UserSessionUpdater;
import org.keycloak.models.sessions.infinispan.entities.ClientSessionKey;
import org.keycloak.models.sessions.infinispan.entities.RemoteAuthenticatedClientSessionEntity;
import org.keycloak.models.sessions.infinispan.entities.RemoteUserSessionEntity;
import org.keycloak.models.sessions.infinispan.query.ClientSessionQueries;
import org.keycloak.models.sessions.infinispan.query.QueryHelper;
import org.keycloak.models.sessions.infinispan.query.UserSessionQueries;
import org.keycloak.models.sessions.infinispan.remote.transaction.ClientSessionChangeLogTransaction;
import org.keycloak.models.sessions.infinispan.remote.transaction.UserSessionChangeLogTransaction;
import org.keycloak.models.sessions.infinispan.remote.transaction.UserSessionTransaction;
import org.keycloak.models.utils.KeycloakModelUtils;
import org.keycloak.utils.StreamsUtil;

public class RemoteUserSessionProvider
implements UserSessionProvider {
    private static final Logger log = Logger.getLogger(MethodHandles.lookup().lookupClass());
    private static final int MAX_CONCURRENT_REQUESTS = 16;
    private final KeycloakSession session;
    private final UserSessionTransaction transaction;
    private final int batchSize;

    public RemoteUserSessionProvider(KeycloakSession session, UserSessionTransaction transaction, int batchSize) {
        this.session = session;
        this.transaction = transaction;
        this.batchSize = batchSize;
    }

    public AuthenticatedClientSessionModel createClientSession(RealmModel realm, ClientModel client, UserSessionModel userSession) {
        RemoteAuthenticatedClientSessionEntity entity;
        ClientSessionKey key;
        ClientSessionChangeLogTransaction clientTx = this.getClientSessionTransaction(false);
        AuthenticatedClientSessionUpdater model = (AuthenticatedClientSessionUpdater)clientTx.create(key = new ClientSessionKey(userSession.getId(), client.getId()), entity = RemoteAuthenticatedClientSessionEntity.create(key, realm.getId(), userSession));
        if (!model.isInitialized()) {
            model.initialize(userSession, client, clientTx);
        }
        return model;
    }

    public AuthenticatedClientSessionModel getClientSession(UserSessionModel userSession, ClientModel client, String clientSessionId, boolean offline) {
        if (clientSessionId == null) {
            return null;
        }
        ClientSessionChangeLogTransaction clientTx = this.getClientSessionTransaction(offline);
        AuthenticatedClientSessionUpdater updater = (AuthenticatedClientSessionUpdater)clientTx.get(new ClientSessionKey(userSession.getId(), client.getId()));
        if (updater == null) {
            return null;
        }
        if (!updater.isInitialized()) {
            updater.initialize(userSession, client, clientTx);
        }
        return updater;
    }

    public UserSessionModel createUserSession(String id, RealmModel realm, UserModel user, String loginUsername, String ipAddress, String authMethod, boolean rememberMe, String brokerSessionId, String brokerUserId, UserSessionModel.SessionPersistenceState persistenceState) {
        if (id == null) {
            id = KeycloakModelUtils.generateId();
        }
        RemoteUserSessionEntity entity = RemoteUserSessionEntity.create(id, realm, user, loginUsername, ipAddress, authMethod, rememberMe, brokerSessionId, brokerUserId);
        UserSessionUpdater updater = (UserSessionUpdater)this.getUserSessionTransaction(false).create(id, entity);
        return this.initUserSessionUpdater(updater, persistenceState, realm, user, false);
    }

    public UserSessionModel getUserSession(RealmModel realm, String id) {
        return this.getUserSession(realm, id, false);
    }

    public Stream<UserSessionModel> getUserSessionsStream(RealmModel realm, UserModel user) {
        return StreamsUtil.closing(this.streamUserSessionByUserId(realm, user, false));
    }

    public Stream<UserSessionModel> getUserSessionsStream(RealmModel realm, ClientModel client) {
        return StreamsUtil.closing(this.streamUserSessionByClientId(realm, client.getId(), false, null, null));
    }

    public Stream<UserSessionModel> getUserSessionsStream(RealmModel realm, ClientModel client, Integer firstResult, Integer maxResults) {
        return StreamsUtil.closing(this.streamUserSessionByClientId(realm, client.getId(), false, firstResult, maxResults));
    }

    public Stream<UserSessionModel> getUserSessionByBrokerUserIdStream(RealmModel realm, String brokerUserId) {
        return StreamsUtil.closing(this.streamUserSessionByBrokerUserId(realm, brokerUserId, false));
    }

    public UserSessionModel getUserSessionByBrokerSessionId(RealmModel realm, String brokerSessionId) {
        UserSessionChangeLogTransaction userTx = this.getUserSessionTransaction(false);
        Query<RemoteUserSessionEntity> query = UserSessionQueries.searchByBrokerSessionId(userTx.getCache(), realm.getId(), brokerSessionId);
        return QueryHelper.fetchSingle(query, userTx::wrapFromProjection).map(session -> this.initUserSessionFromQuery((UserSessionUpdater)session, realm, null, false)).orElse(null);
    }

    public UserSessionModel getUserSessionWithPredicate(RealmModel realm, String id, boolean offline, Predicate<UserSessionModel> predicate) {
        UserSessionUpdater updater = this.getUserSession(realm, id, offline);
        return updater != null && predicate.test(updater) ? updater : null;
    }

    public long getActiveUserSessions(RealmModel realm, ClientModel client) {
        return this.computeUserSessionCount(realm, client, false);
    }

    public Map<String, Long> getActiveClientSessionStats(RealmModel realm, boolean offline) {
        Query<Object[]> query = ClientSessionQueries.activeClientCount(this.getClientSessionTransaction(offline).getCache());
        return QueryHelper.streamAll(query, this.batchSize, QueryHelper.PROJECTION_TO_STRING_LONG_ENTRY).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    public void removeUserSession(RealmModel realm, UserSessionModel userSession) {
        this.internalRemoveUserSession(userSession, false);
    }

    public void removeUserSessions(RealmModel realm, UserModel user) {
        this.transaction.removeAllSessionByUserId(realm.getId(), user.getId());
    }

    public void removeAllExpired() {
    }

    public void removeExpired(RealmModel realm) {
    }

    public void removeUserSessions(RealmModel realm) {
        this.transaction.removeOnlineSessionsByRealmId(realm.getId());
    }

    public void onRealmRemoved(RealmModel realm) {
        this.transaction.removeAllSessionsByRealmId(realm.getId());
        UserSessionPersisterProvider database = (UserSessionPersisterProvider)this.session.getProvider(UserSessionPersisterProvider.class);
        if (database != null) {
            database.onRealmRemoved(realm);
        }
    }

    public void onClientRemoved(RealmModel realm, ClientModel client) {
        UserSessionPersisterProvider database = (UserSessionPersisterProvider)this.session.getProvider(UserSessionPersisterProvider.class);
        if (database != null) {
            database.onClientRemoved(realm, client);
        }
    }

    public UserSessionModel createOfflineUserSession(UserSessionModel userSession) {
        RemoteUserSessionEntity entity = RemoteUserSessionEntity.createFromModel(userSession);
        UserSessionUpdater updater = (UserSessionUpdater)this.getUserSessionTransaction(true).create(userSession.getId(), entity);
        return this.initUserSessionUpdater(updater, userSession.getPersistenceState(), userSession.getRealm(), userSession.getUser(), true);
    }

    public UserSessionModel getOfflineUserSession(RealmModel realm, String userSessionId) {
        return this.getUserSession(realm, userSessionId, true);
    }

    public void removeOfflineUserSession(RealmModel realm, UserSessionModel userSession) {
        this.internalRemoveUserSession(userSession, true);
    }

    public AuthenticatedClientSessionModel createOfflineClientSession(AuthenticatedClientSessionModel clientSession, UserSessionModel offlineUserSession) {
        RemoteAuthenticatedClientSessionEntity entity;
        ClientSessionKey key;
        ClientSessionChangeLogTransaction clientTx = this.getClientSessionTransaction(true);
        AuthenticatedClientSessionUpdater model = (AuthenticatedClientSessionUpdater)clientTx.create(key = new ClientSessionKey(offlineUserSession.getId(), clientSession.getClient().getId()), entity = RemoteAuthenticatedClientSessionEntity.createFromModel(key, clientSession));
        if (!model.isInitialized()) {
            model.initialize(offlineUserSession, clientSession.getClient(), clientTx);
        }
        return model;
    }

    public Stream<UserSessionModel> getOfflineUserSessionsStream(RealmModel realm, UserModel user) {
        return StreamsUtil.closing(this.streamUserSessionByUserId(realm, user, true));
    }

    public Stream<UserSessionModel> getOfflineUserSessionByBrokerUserIdStream(RealmModel realm, String brokerUserId) {
        return StreamsUtil.closing(this.streamUserSessionByBrokerUserId(realm, brokerUserId, true));
    }

    public long getOfflineSessionsCount(RealmModel realm, ClientModel client) {
        return this.computeUserSessionCount(realm, client, true);
    }

    public Stream<UserSessionModel> getOfflineUserSessionsStream(RealmModel realm, ClientModel client, Integer firstResult, Integer maxResults) {
        return StreamsUtil.closing(this.streamUserSessionByClientId(realm, client.getId(), true, firstResult, maxResults));
    }

    public int getStartupTime(RealmModel realm) {
        return ((ClusterProvider)this.session.getProvider(ClusterProvider.class)).getClusterStartupTime();
    }

    public KeycloakSession getKeycloakSession() {
        return this.session;
    }

    public void close() {
    }

    public void migrate(String modelVersion) {
        if ("25.0.0".equals(modelVersion)) {
            this.migrateUserSessions(true);
            this.migrateUserSessions(false);
        }
    }

    private void migrateUserSessions(boolean offline) {
        boolean hasSessions;
        log.info((Object)"Migrate user sessions from database to the remote cache");
        List<String> userSessionIds = Collections.synchronizedList(new ArrayList(this.batchSize));
        List<Map.Entry<String, String>> clientSessionIds = Collections.synchronizedList(new ArrayList(this.batchSize));
        while (hasSessions = this.migrateUserSessionBatch(this.session.getKeycloakSessionFactory(), offline, userSessionIds, clientSessionIds)) {
        }
        log.info((Object)"All sessions migrated.");
    }

    private boolean migrateUserSessionBatch(KeycloakSessionFactory factory, boolean offline, List<String> userSessionBuffer, List<Map.Entry<String, String>> clientSessionBuffer) {
        RemoteCache userSessionCache = this.getUserSessionTransaction(offline).getCache();
        RemoteCache clientSessionCache = this.getClientSessionTransaction(offline).getCache();
        log.infof("Migrating %s user(s) session(s) from database.", (Object)this.batchSize);
        return (Boolean)KeycloakModelUtils.runJobInTransactionWithResult((KeycloakSessionFactory)factory, kcSession -> {
            UserSessionPersisterProvider database = (UserSessionPersisterProvider)kcSession.getProvider(UserSessionPersisterProvider.class);
            AggregateCompletionStage stage = CompletionStages.aggregateCompletionStage();
            database.loadUserSessionsStream(Integer.valueOf(-1), Integer.valueOf(this.batchSize), offline, "").forEach(userSessionModel -> {
                RemoteUserSessionEntity userSessionEntity = RemoteUserSessionEntity.createFromModel(userSessionModel);
                stage.dependsOn((CompletionStage)userSessionCache.putIfAbsentAsync((Object)userSessionModel.getId(), (Object)userSessionEntity));
                userSessionBuffer.add(userSessionModel.getId());
                for (AuthenticatedClientSessionModel clientSessionModel : userSessionModel.getAuthenticatedClientSessions().values()) {
                    ClientSessionKey clientSessionKey = new ClientSessionKey(userSessionModel.getId(), clientSessionModel.getClient().getId());
                    clientSessionBuffer.add(Map.entry(userSessionModel.getId(), clientSessionModel.getId()));
                    RemoteAuthenticatedClientSessionEntity clientSessionEntity = RemoteAuthenticatedClientSessionEntity.createFromModel(clientSessionKey, clientSessionModel);
                    stage.dependsOn((CompletionStage)clientSessionCache.putIfAbsentAsync((Object)clientSessionKey, (Object)clientSessionEntity));
                }
            });
            CompletionStages.join((CompletionStage)stage.freeze());
            if (userSessionBuffer.isEmpty() && clientSessionBuffer.isEmpty()) {
                return false;
            }
            log.infof("%s user(s) session(s) stored in the remote cache. Removing them from database.", (Object)userSessionBuffer.size());
            userSessionBuffer.forEach(s -> database.removeUserSession(s, offline));
            userSessionBuffer.clear();
            clientSessionBuffer.forEach(e -> database.removeClientSession((String)e.getKey(), (String)e.getValue(), offline));
            clientSessionBuffer.clear();
            return true;
        });
    }

    private UserSessionUpdater getUserSession(RealmModel realm, String id, boolean offline) {
        if (id == null) {
            return null;
        }
        UserSessionUpdater updater = (UserSessionUpdater)this.getUserSessionTransaction(offline).get(id);
        if (updater == null || !((RemoteUserSessionEntity)updater.getValue()).getRealmId().equals(realm.getId())) {
            return null;
        }
        if (updater.isInitialized()) {
            return updater;
        }
        UserModel user = this.session.users().getUserById(realm, ((RemoteUserSessionEntity)updater.getValue()).getUserId());
        return this.initUserSessionUpdater(updater, UserSessionModel.SessionPersistenceState.PERSISTENT, realm, user, offline);
    }

    private void internalRemoveUserSession(UserSessionModel userSession, boolean offline) {
        this.transaction.removeUserSessionById(userSession.getId(), offline);
    }

    private UserSessionChangeLogTransaction getUserSessionTransaction(boolean offline) {
        return this.transaction.getUserSessions(offline);
    }

    private ClientSessionChangeLogTransaction getClientSessionTransaction(boolean offline) {
        return this.transaction.getClientSessions(offline);
    }

    private UserSessionUpdater initUserSessionFromQuery(UserSessionUpdater updater, RealmModel realm, UserModel user, boolean offline) {
        assert (updater != null);
        assert (realm != null);
        if (updater.isDeleted()) {
            return null;
        }
        if (updater.isInitialized()) {
            return updater;
        }
        if (user == null) {
            user = this.session.users().getUserById(realm, ((RemoteUserSessionEntity)updater.getValue()).getUserId());
        }
        return this.initUserSessionUpdater(updater, UserSessionModel.SessionPersistenceState.PERSISTENT, realm, user, offline);
    }

    private UserSessionUpdater initUserSessionUpdater(UserSessionUpdater updater, UserSessionModel.SessionPersistenceState persistenceState, RealmModel realm, UserModel user, boolean offline) {
        if (user instanceof LightweightUserAdapter) {
            updater.initialize(persistenceState, realm, user, new ClientSessionMapping(updater));
            return RemoteUserSessionProvider.checkExpiration(updater);
        }
        if (Profile.isFeatureEnabled((Profile.Feature)Profile.Feature.TRANSIENT_USERS) && updater.getNotes().containsKey("keycloak.userModel")) {
            LightweightUserAdapter lua = LightweightUserAdapter.fromString((KeycloakSession)this.session, (RealmModel)realm, (String)updater.getNotes().get("keycloak.userModel"));
            updater.initialize(persistenceState, realm, (UserModel)lua, new ClientSessionMapping(updater));
            lua.setUpdateHandler(lua1 -> {
                if (lua == lua1) {
                    updater.setNote("keycloak.userModel", lua1.serialize());
                }
            });
            return RemoteUserSessionProvider.checkExpiration(updater);
        }
        if (user == null) {
            this.internalRemoveUserSession(updater, offline);
            return null;
        }
        updater.initialize(persistenceState, realm, user, new ClientSessionMapping(updater));
        return RemoteUserSessionProvider.checkExpiration(updater);
    }

    private AuthenticatedClientSessionModel initClientSessionUpdater(AuthenticatedClientSessionUpdater updater, UserSessionUpdater userSession) {
        if (updater == null || updater.isDeleted()) {
            return null;
        }
        ClientModel client = userSession.getRealm().getClientById(((ClientSessionKey)updater.getKey()).clientId());
        if (client == null) {
            updater.markDeleted();
            return null;
        }
        if (updater.isInitialized()) {
            return updater;
        }
        updater.initialize(userSession, client, this.getClientSessionTransaction(userSession.isOffline()));
        return RemoteUserSessionProvider.checkExpiration(updater);
    }

    private long computeUserSessionCount(RealmModel realm, ClientModel client, boolean offline) {
        Query<Object[]> query = ClientSessionQueries.countClientSessions(this.getClientSessionTransaction(offline).getCache(), realm.getId(), client.getId());
        return QueryHelper.fetchSingle(query, QueryHelper.SINGLE_PROJECTION_TO_LONG).orElse(0L);
    }

    private Stream<UserSessionModel> streamUserSessionByUserId(RealmModel realm, UserModel user, boolean offline) {
        UserSessionChangeLogTransaction userTx = this.getUserSessionTransaction(offline);
        Query<RemoteUserSessionEntity> query = UserSessionQueries.searchByUserId(userTx.getCache(), realm.getId(), user.getId());
        return QueryHelper.streamAll(query, this.batchSize, userTx::wrapFromProjection).map(session -> this.initUserSessionFromQuery((UserSessionUpdater)session, realm, user, offline)).filter(Objects::nonNull).map(UserSessionModel.class::cast);
    }

    private Stream<UserSessionModel> streamUserSessionByBrokerUserId(RealmModel realm, String brokerUserId, boolean offline) {
        UserSessionChangeLogTransaction userTx = this.getUserSessionTransaction(offline);
        Query<RemoteUserSessionEntity> query = UserSessionQueries.searchByBrokerUserId(userTx.getCache(), realm.getId(), brokerUserId);
        return QueryHelper.streamAll(query, this.batchSize, userTx::wrapFromProjection).map(session -> this.initUserSessionFromQuery((UserSessionUpdater)session, realm, null, offline)).filter(Objects::nonNull).map(UserSessionModel.class::cast);
    }

    private Stream<UserSessionModel> streamUserSessionByClientId(RealmModel realm, String clientId, boolean offline, Integer offset, Integer maxResults) {
        Query<Object[]> userSessionIdQuery = ClientSessionQueries.fetchUserSessionIdForClientId(this.getClientSessionTransaction(offline).getCache(), realm.getId(), clientId);
        if (offset != null) {
            userSessionIdQuery.startOffset((long)offset.intValue());
        }
        userSessionIdQuery.maxResults(maxResults == null ? Integer.MAX_VALUE : maxResults);
        UserSessionChangeLogTransaction userSessionTx = this.getUserSessionTransaction(offline);
        return Flowable.fromIterable(QueryHelper.toCollection(userSessionIdQuery, QueryHelper.SINGLE_PROJECTION_TO_STRING)).flatMapMaybe(userSessionTx::maybeGet, false, 16).blockingStream(this.batchSize).map(session -> this.initUserSessionFromQuery((UserSessionUpdater)session, realm, null, offline)).filter(Objects::nonNull).map(UserSessionModel.class::cast);
    }

    private static <K, V, T extends BaseUpdater<K, V>> T checkExpiration(T updater) {
        Expiration expiration = updater.computeExpiration();
        if (expiration.isExpired()) {
            updater.markDeleted();
            return null;
        }
        return updater;
    }

    private static Map.Entry<String, AuthenticatedClientSessionModel> toMapEntry(AuthenticatedClientSessionModel model) {
        return Map.entry(model.getClient().getId(), model);
    }

    private class ClientSessionMapping
    extends AbstractMap<String, AuthenticatedClientSessionModel>
    implements Consumer<RemoteAuthenticatedClientSessionEntity> {
        private final UserSessionUpdater userSession;
        private boolean coldCache = true;

        ClientSessionMapping(UserSessionUpdater userSession) {
            this.userSession = userSession;
        }

        @Override
        public void clear() {
            this.getTransaction().removeByUserSessionId(this.getUserSessionId());
        }

        @Override
        public AuthenticatedClientSessionModel get(Object key) {
            AuthenticatedClientSessionUpdater updater = (AuthenticatedClientSessionUpdater)this.getTransaction().get(this.keyForClientId(key));
            return RemoteUserSessionProvider.this.initClientSessionUpdater(updater, this.userSession);
        }

        @Override
        public AuthenticatedClientSessionModel remove(Object key) {
            this.getTransaction().remove(this.keyForClientId(key));
            return null;
        }

        @Override
        public boolean containsKey(Object key) {
            return this.get(key) != null;
        }

        @Override
        public Set<Map.Entry<String, AuthenticatedClientSessionModel>> entrySet() {
            if (this.coldCache) {
                this.fetchAndCacheClientSessions();
                this.coldCache = false;
            }
            return this.getTransaction().getClientSessions().filter(this::isFromUserSession).map(this::initialize).filter(Objects::nonNull).map(RemoteUserSessionProvider::toMapEntry).collect(Collectors.toSet());
        }

        private ClientSessionKey keyForClientId(String clientId) {
            return new ClientSessionKey(this.getUserSessionId(), clientId);
        }

        private ClientSessionKey keyForClientId(Object clientId) {
            return this.keyForClientId(String.valueOf(clientId));
        }

        private void fetchAndCacheClientSessions() {
            Query<RemoteAuthenticatedClientSessionEntity> query = ClientSessionQueries.fetchClientSessions(this.getTransaction().getCache(), this.getUserSessionId());
            QueryHelper.streamAll(query, RemoteUserSessionProvider.this.batchSize, Function.identity()).forEach(this);
        }

        @Override
        public void accept(RemoteAuthenticatedClientSessionEntity entity) {
            this.getTransaction().wrapFromProjection(entity);
        }

        private ClientSessionChangeLogTransaction getTransaction() {
            return RemoteUserSessionProvider.this.getClientSessionTransaction(this.userSession.isOffline());
        }

        private String getUserSessionId() {
            return (String)this.userSession.getKey();
        }

        private boolean isFromUserSession(AuthenticatedClientSessionUpdater updater) {
            return Objects.equals(this.getUserSessionId(), ((RemoteAuthenticatedClientSessionEntity)updater.getValue()).getUserSessionId());
        }

        private AuthenticatedClientSessionModel initialize(AuthenticatedClientSessionUpdater updater) {
            return RemoteUserSessionProvider.this.initClientSessionUpdater(updater, this.userSession);
        }
    }
}

