/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.persistence.remote.upgrade;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Set;
import java.util.function.Function;
import org.infinispan.Cache;
import org.infinispan.commons.CacheException;
import org.infinispan.commons.marshall.AbstractExternalizer;
import org.infinispan.factories.ComponentRegistry;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.persistence.manager.PersistenceManager;
import org.infinispan.persistence.remote.RemoteStore;

public class CheckRemoteStoreTask
implements Function<EmbeddedCacheManager, Boolean> {
    private final String cacheName;

    public CheckRemoteStoreTask(String cacheName) {
        this.cacheName = cacheName;
    }

    @Override
    public Boolean apply(EmbeddedCacheManager embeddedCacheManager) {
        PersistenceManager persistenceManager = (PersistenceManager)ComponentRegistry.componentOf((Cache)embeddedCacheManager.getCache(this.cacheName), PersistenceManager.class);
        try {
            ArrayList stores = new ArrayList(persistenceManager.getStores(RemoteStore.class));
            return stores.size() == 1;
        }
        catch (Exception e) {
            throw new CacheException((Throwable)e);
        }
    }

    public static class Externalizer
    extends AbstractExternalizer<CheckRemoteStoreTask> {
        public Set<Class<? extends CheckRemoteStoreTask>> getTypeClasses() {
            return Collections.singleton(CheckRemoteStoreTask.class);
        }

        public void writeObject(ObjectOutput output, CheckRemoteStoreTask task) throws IOException {
            output.writeObject(task.cacheName);
        }

        public CheckRemoteStoreTask readObject(ObjectInput input) throws IOException, ClassNotFoundException {
            String cacheName = (String)input.readObject();
            return new CheckRemoteStoreTask(cacheName);
        }
    }
}

