/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.geom.util;

import java.util.ArrayList;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.CoordinateSequence;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryCollection;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.LinearRing;
import org.locationtech.jts.geom.MultiLineString;
import org.locationtech.jts.geom.MultiPoint;
import org.locationtech.jts.geom.MultiPolygon;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.Polygon;

public class GeometryTransformer {
    private Geometry inputGeom;
    protected GeometryFactory factory = null;
    private boolean pruneEmptyGeometry = true;
    private boolean preserveGeometryCollectionType = true;
    private boolean preserveCollections = false;
    private boolean preserveType = false;

    public Geometry getInputGeometry() {
        return this.inputGeom;
    }

    public final Geometry transform(Geometry inputGeom) {
        this.inputGeom = inputGeom;
        this.factory = inputGeom.getFactory();
        if (inputGeom instanceof Point) {
            return this.transformPoint((Point)inputGeom, null);
        }
        if (inputGeom instanceof MultiPoint) {
            return this.transformMultiPoint((MultiPoint)inputGeom, null);
        }
        if (inputGeom instanceof LinearRing) {
            return this.transformLinearRing((LinearRing)inputGeom, null);
        }
        if (inputGeom instanceof LineString) {
            return this.transformLineString((LineString)inputGeom, null);
        }
        if (inputGeom instanceof MultiLineString) {
            return this.transformMultiLineString((MultiLineString)inputGeom, null);
        }
        if (inputGeom instanceof Polygon) {
            return this.transformPolygon((Polygon)inputGeom, null);
        }
        if (inputGeom instanceof MultiPolygon) {
            return this.transformMultiPolygon((MultiPolygon)inputGeom, null);
        }
        if (inputGeom instanceof GeometryCollection) {
            return this.transformGeometryCollection((GeometryCollection)inputGeom, null);
        }
        throw new IllegalArgumentException("Unknown Geometry subtype: " + inputGeom.getClass().getName());
    }

    protected final CoordinateSequence createCoordinateSequence(Coordinate[] coords) {
        return this.factory.getCoordinateSequenceFactory().create(coords);
    }

    protected final CoordinateSequence copy(CoordinateSequence seq) {
        return seq.copy();
    }

    protected CoordinateSequence transformCoordinates(CoordinateSequence coords, Geometry parent) {
        return this.copy(coords);
    }

    protected Geometry transformPoint(Point geom, Geometry parent) {
        return this.factory.createPoint(this.transformCoordinates(geom.getCoordinateSequence(), geom));
    }

    protected Geometry transformMultiPoint(MultiPoint geom, Geometry parent) {
        ArrayList<Geometry> transGeomList = new ArrayList<Geometry>();
        for (int i = 0; i < geom.getNumGeometries(); ++i) {
            Geometry transformGeom = this.transformPoint((Point)geom.getGeometryN(i), geom);
            if (transformGeom == null || transformGeom.isEmpty()) continue;
            transGeomList.add(transformGeom);
        }
        if (transGeomList.isEmpty()) {
            return this.factory.createMultiPoint();
        }
        return this.factory.buildGeometry(transGeomList);
    }

    protected Geometry transformLinearRing(LinearRing geom, Geometry parent) {
        CoordinateSequence seq = this.transformCoordinates(geom.getCoordinateSequence(), geom);
        if (seq == null) {
            return this.factory.createLinearRing((CoordinateSequence)null);
        }
        int seqSize = seq.size();
        if (seqSize > 0 && seqSize < 4 && !this.preserveType) {
            return this.factory.createLineString(seq);
        }
        return this.factory.createLinearRing(seq);
    }

    protected Geometry transformLineString(LineString geom, Geometry parent) {
        return this.factory.createLineString(this.transformCoordinates(geom.getCoordinateSequence(), geom));
    }

    protected Geometry transformMultiLineString(MultiLineString geom, Geometry parent) {
        ArrayList<Geometry> transGeomList = new ArrayList<Geometry>();
        for (int i = 0; i < geom.getNumGeometries(); ++i) {
            Geometry transformGeom = this.transformLineString((LineString)geom.getGeometryN(i), geom);
            if (transformGeom == null || transformGeom.isEmpty()) continue;
            transGeomList.add(transformGeom);
        }
        if (transGeomList.isEmpty()) {
            return this.factory.createMultiLineString();
        }
        return this.factory.buildGeometry(transGeomList);
    }

    protected Geometry transformPolygon(Polygon geom, Geometry parent) {
        boolean shellIsNullOrEmpty;
        boolean isAllValidLinearRings = true;
        Geometry shell = this.transformLinearRing(geom.getExteriorRing(), geom);
        boolean bl = shellIsNullOrEmpty = shell == null || shell.isEmpty();
        if (geom.isEmpty() && shellIsNullOrEmpty) {
            return this.factory.createPolygon();
        }
        if (shellIsNullOrEmpty || !(shell instanceof LinearRing)) {
            isAllValidLinearRings = false;
        }
        ArrayList<Geometry> holes = new ArrayList<Geometry>();
        for (int i = 0; i < geom.getNumInteriorRing(); ++i) {
            Geometry hole = this.transformLinearRing(geom.getInteriorRingN(i), geom);
            if (hole == null || hole.isEmpty()) continue;
            if (!(hole instanceof LinearRing)) {
                isAllValidLinearRings = false;
            }
            holes.add(hole);
        }
        if (isAllValidLinearRings) {
            return this.factory.createPolygon((LinearRing)shell, holes.toArray(new LinearRing[0]));
        }
        ArrayList<Geometry> components = new ArrayList<Geometry>();
        if (shell != null) {
            components.add(shell);
        }
        components.addAll(holes);
        return this.factory.buildGeometry(components);
    }

    protected Geometry transformMultiPolygon(MultiPolygon geom, Geometry parent) {
        ArrayList<Geometry> transGeomList = new ArrayList<Geometry>();
        for (int i = 0; i < geom.getNumGeometries(); ++i) {
            Geometry transformGeom = this.transformPolygon((Polygon)geom.getGeometryN(i), geom);
            if (transformGeom == null || transformGeom.isEmpty()) continue;
            transGeomList.add(transformGeom);
        }
        if (transGeomList.isEmpty()) {
            return this.factory.createMultiPolygon();
        }
        return this.factory.buildGeometry(transGeomList);
    }

    protected Geometry transformGeometryCollection(GeometryCollection geom, Geometry parent) {
        ArrayList<Geometry> transGeomList = new ArrayList<Geometry>();
        for (int i = 0; i < geom.getNumGeometries(); ++i) {
            Geometry transformGeom = this.transform(geom.getGeometryN(i));
            if (transformGeom == null || this.pruneEmptyGeometry && transformGeom.isEmpty()) continue;
            transGeomList.add(transformGeom);
        }
        if (this.preserveGeometryCollectionType) {
            return this.factory.createGeometryCollection(GeometryFactory.toGeometryArray(transGeomList));
        }
        return this.factory.buildGeometry(transGeomList);
    }
}

