/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.services.util;

import java.util.HashMap;
import org.keycloak.models.ClientModel;
import org.keycloak.representations.idm.CertificateRepresentation;
import org.keycloak.representations.idm.ClientRepresentation;

public class CertificateInfoHelper {
    public static final String PRIVATE_KEY = "private.key";
    public static final String X509CERTIFICATE = "certificate";
    public static final String PUBLIC_KEY = "public.key";
    public static final String KID = "kid";

    public static CertificateRepresentation getCertificateFromClient(ClientModel client, String attributePrefix) {
        String privateKeyAttribute = attributePrefix + ".private.key";
        String certificateAttribute = attributePrefix + ".certificate";
        String publicKeyAttribute = attributePrefix + ".public.key";
        String kidAttribute = attributePrefix + ".kid";
        CertificateRepresentation rep = new CertificateRepresentation();
        rep.setCertificate(client.getAttribute(certificateAttribute));
        rep.setPublicKey(client.getAttribute(publicKeyAttribute));
        rep.setPrivateKey(client.getAttribute(privateKeyAttribute));
        rep.setKid(client.getAttribute(kidAttribute));
        return rep;
    }

    public static void updateClientModelCertificateInfo(ClientModel client, CertificateRepresentation rep, String attributePrefix) {
        String privateKeyAttribute = attributePrefix + ".private.key";
        String certificateAttribute = attributePrefix + ".certificate";
        String publicKeyAttribute = attributePrefix + ".public.key";
        String kidAttribute = attributePrefix + ".kid";
        if (rep.getPublicKey() == null && rep.getCertificate() == null) {
            throw new IllegalStateException("Both certificate and publicKey are null!");
        }
        if (rep.getPublicKey() != null && rep.getCertificate() != null) {
            throw new IllegalStateException("Both certificate and publicKey are not null!");
        }
        CertificateInfoHelper.setOrRemoveAttr(client, privateKeyAttribute, rep.getPrivateKey());
        CertificateInfoHelper.setOrRemoveAttr(client, publicKeyAttribute, rep.getPublicKey());
        CertificateInfoHelper.setOrRemoveAttr(client, certificateAttribute, rep.getCertificate());
        CertificateInfoHelper.setOrRemoveAttr(client, kidAttribute, rep.getKid());
    }

    private static void setOrRemoveAttr(ClientModel client, String attrName, String attrValue) {
        if (attrValue != null) {
            client.setAttribute(attrName, attrValue);
        } else {
            client.removeAttribute(attrName);
        }
    }

    public static void updateClientRepresentationCertificateInfo(ClientRepresentation client, CertificateRepresentation rep, String attributePrefix) {
        String privateKeyAttribute = attributePrefix + ".private.key";
        String certificateAttribute = attributePrefix + ".certificate";
        String publicKeyAttribute = attributePrefix + ".public.key";
        String kidAttribute = attributePrefix + ".kid";
        if (rep.getPublicKey() == null && rep.getCertificate() == null) {
            throw new IllegalStateException("Both certificate and publicKey are null!");
        }
        if (rep.getPublicKey() != null && rep.getCertificate() != null) {
            throw new IllegalStateException("Both certificate and publicKey are not null!");
        }
        CertificateInfoHelper.setOrRemoveAttr(client, privateKeyAttribute, rep.getPrivateKey());
        CertificateInfoHelper.setOrRemoveAttr(client, publicKeyAttribute, rep.getPublicKey());
        CertificateInfoHelper.setOrRemoveAttr(client, certificateAttribute, rep.getCertificate());
        CertificateInfoHelper.setOrRemoveAttr(client, kidAttribute, rep.getKid());
    }

    private static void setOrRemoveAttr(ClientRepresentation client, String attrName, String attrValue) {
        if (attrValue != null) {
            if (client.getAttributes() == null) {
                client.setAttributes(new HashMap());
            }
            client.getAttributes().put(attrName, attrValue);
        } else if (client.getAttributes() != null) {
            client.getAttributes().remove(attrName);
        }
    }
}

