/*
 * Decompiled with CFR 0.152.
 */
package io.mvnpm.importmap;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.mvnpm.importmap.model.Imports;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.UncheckedIOException;
import java.net.URL;
import java.net.URLClassLoader;
import java.net.URLConnection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class Aggregator {
    private final ObjectMapper objectMapper = new ObjectMapper();
    private final Map<String, String> userProvidedImports = new HashMap<String, String>();
    private final Set<URL> userProvidedJarUrls = new HashSet<URL>();

    public Aggregator() {
    }

    public Aggregator(Set<URL> urls) {
        this.userProvidedJarUrls.addAll(urls);
    }

    public Aggregator(Map<String, String> importMapings) {
        this.userProvidedImports.putAll(importMapings);
    }

    public Aggregator(Set<URL> urls, Map<String, String> importMapings) {
        this.userProvidedJarUrls.addAll(urls);
        this.userProvidedImports.putAll(importMapings);
    }

    public void addMapping(String key, String value) {
        this.userProvidedImports.put(key, value);
    }

    public void addMappings(Map<String, String> all) {
        this.userProvidedImports.putAll(all);
    }

    public void addJarUrl(URL url) {
        this.userProvidedJarUrls.add(url);
    }

    public void addJarUrls(Set<URL> urls) {
        this.userProvidedJarUrls.addAll(urls);
    }

    public Imports aggregate() {
        return this.aggregate(true);
    }

    public Imports aggregate(boolean scanClassPath) {
        return this.aggregate("", scanClassPath);
    }

    public Imports aggregate(String root) {
        return this.aggregate(root, true);
    }

    public Imports aggregate(String root, boolean scanClassPath) {
        if (root.endsWith("/")) {
            root = root.substring(0, root.length() - 1);
        }
        HashMap<String, String> allimports = new HashMap<String, String>();
        allimports.putAll(this.userProvidedImports);
        allimports.putAll(this.scanUserProviderUrls(root));
        if (scanClassPath) {
            allimports.putAll(this.scanClassPath(root));
        }
        return new Imports(allimports);
    }

    public String aggregateAsJson() {
        return this.aggregateAsJson(true);
    }

    public String aggregateAsJs() {
        return this.aggregateAsJs(true);
    }

    public String aggregateAsJson(boolean scanClassPath) {
        return this.aggregateAsJson("", scanClassPath);
    }

    public String aggregateAsJs(boolean scanClassPath) {
        return this.aggregateAsJs("", scanClassPath);
    }

    public String aggregateAsJson(String root) {
        return this.aggregateAsJson(root, true);
    }

    public String aggregateAsJs(String root) {
        return this.aggregateAsJs(root, true);
    }

    public String aggregateAsJson(String root, boolean scanClassPath) {
        try {
            Imports i = this.aggregate(root, scanClassPath);
            return this.objectMapper.writerWithDefaultPrettyPrinter().writeValueAsString((Object)i);
        }
        catch (JsonProcessingException ex) {
            throw new RuntimeException(ex);
        }
    }

    public String aggregateAsJson(Imports imports) {
        try {
            return this.objectMapper.writerWithDefaultPrettyPrinter().writeValueAsString((Object)imports);
        }
        catch (JsonProcessingException ex) {
            throw new RuntimeException(ex);
        }
    }

    public String aggregateAsJs(String root, boolean scanClassPath) {
        String string;
        Imports i = this.aggregate(root, scanClassPath);
        Map<String, String> imports = i.getImports();
        StringWriter sw = new StringWriter();
        try {
            for (Map.Entry<String, String> e : imports.entrySet()) {
                sw.write("import '" + e.getValue() + "';");
                sw.write("\n");
            }
            string = sw.toString();
        }
        catch (Throwable throwable) {
            try {
                try {
                    sw.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException ex) {
                throw new UncheckedIOException(ex);
            }
        }
        sw.close();
        return string;
    }

    public void reset() {
        this.userProvidedImports.clear();
        this.userProvidedJarUrls.clear();
    }

    private Map<String, String> scanUserProviderUrls(String root) {
        if (!this.userProvidedJarUrls.isEmpty()) {
            HashMap<String, String> hashMap;
            URLClassLoader urlClassLoader = new URLClassLoader(this.userProvidedJarUrls.toArray(new URL[0]));
            try {
                Enumeration<URL> enumer = urlClassLoader.getResources("META-INF/importmap.json");
                HashMap<String, String> m = new HashMap<String, String>();
                while (enumer.hasMoreElements()) {
                    URL importmapFile = enumer.nextElement();
                    InputStream importmapInputStream = Aggregator.getInputStream(importmapFile);
                    try {
                        Imports importsForPackage = (Imports)this.objectMapper.readValue(importmapInputStream, Imports.class);
                        Map<String, String> importForPackage = importsForPackage.getImports();
                        for (Map.Entry<String, String> kv : importForPackage.entrySet()) {
                            m.put(kv.getKey(), root + kv.getValue());
                        }
                    }
                    finally {
                        if (importmapInputStream == null) continue;
                        importmapInputStream.close();
                    }
                }
                hashMap = m;
            }
            catch (Throwable throwable) {
                try {
                    try {
                        urlClassLoader.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (IOException ex) {
                    throw new UncheckedIOException("Could not aggregate importmaps from set of urls", ex);
                }
            }
            urlClassLoader.close();
            return hashMap;
        }
        return Map.of();
    }

    private Map<String, String> scanClassPath(String root) {
        try {
            Enumeration<URL> enumer = Thread.currentThread().getContextClassLoader().getResources("META-INF/importmap.json");
            HashMap<String, String> m = new HashMap<String, String>();
            while (enumer.hasMoreElements()) {
                URL importmapFile = enumer.nextElement();
                InputStream importmapInputStream = Aggregator.getInputStream(importmapFile);
                try {
                    Imports importsForPackage = (Imports)this.objectMapper.readValue(importmapInputStream, Imports.class);
                    Map<String, String> importForPackage = importsForPackage.getImports();
                    for (Map.Entry<String, String> kv : importForPackage.entrySet()) {
                        m.put(kv.getKey(), root + kv.getValue());
                    }
                }
                finally {
                    if (importmapInputStream == null) continue;
                    importmapInputStream.close();
                }
            }
            return m;
        }
        catch (IOException ex) {
            throw new UncheckedIOException("Could not aggregate importmaps from classpath", ex);
        }
    }

    private static InputStream getInputStream(URL importmapFile) throws IOException {
        URLConnection importmapURLConnection = importmapFile.openConnection();
        importmapURLConnection.setUseCaches(false);
        return importmapURLConnection.getInputStream();
    }
}

