/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.security.spi;

import io.quarkus.security.Authenticated;
import io.quarkus.security.PermissionsAllowed;
import jakarta.annotation.security.DenyAll;
import jakarta.annotation.security.PermitAll;
import jakarta.annotation.security.RolesAllowed;
import java.util.Set;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.jandex.MethodInfo;

public class SecurityTransformerUtils {
    public static final DotName DENY_ALL = DotName.createSimple((String)DenyAll.class.getName());
    private static final Set<DotName> SECURITY_ANNOTATIONS = Set.of(DotName.createSimple((String)RolesAllowed.class.getName()), DotName.createSimple((String)PermissionsAllowed.class.getName()), DotName.createSimple((String)Authenticated.class.getName()), DotName.createSimple((String)DenyAll.class.getName()), DotName.createSimple((String)PermitAll.class.getName()));

    public static boolean hasSecurityAnnotation(MethodInfo methodInfo) {
        for (AnnotationInstance annotation : methodInfo.annotations()) {
            if (!SECURITY_ANNOTATIONS.contains(annotation.name())) continue;
            return true;
        }
        return false;
    }

    public static boolean hasSecurityAnnotation(ClassInfo classInfo) {
        for (AnnotationInstance classAnnotation : classInfo.declaredAnnotations()) {
            if (!SECURITY_ANNOTATIONS.contains(classAnnotation.name())) continue;
            return true;
        }
        return false;
    }

    public static boolean isStandardSecurityAnnotation(AnnotationInstance annotationInstance) {
        return SECURITY_ANNOTATIONS.contains(annotationInstance.name());
    }
}

