/*
 * Decompiled with CFR 0.152.
 */
package com.webauthn4j.validator;

import com.webauthn4j.data.AuthenticationData;
import com.webauthn4j.data.CoreAuthenticationData;
import com.webauthn4j.data.CoreRegistrationData;
import com.webauthn4j.data.RegistrationData;
import com.webauthn4j.data.attestation.AttestationObject;
import com.webauthn4j.data.attestation.authenticator.AttestedCredentialData;
import com.webauthn4j.data.attestation.authenticator.AuthenticatorData;
import com.webauthn4j.data.attestation.authenticator.COSEKey;
import com.webauthn4j.data.attestation.statement.AttestationStatement;
import com.webauthn4j.data.client.CollectedClientData;
import com.webauthn4j.data.client.TokenBinding;
import com.webauthn4j.data.extension.authenticator.AuthenticationExtensionsAuthenticatorOutputs;
import com.webauthn4j.data.extension.authenticator.ExtensionAuthenticatorOutput;
import com.webauthn4j.data.extension.client.AuthenticationExtensionsClientOutputs;
import com.webauthn4j.data.extension.client.ExtensionClientOutput;
import com.webauthn4j.validator.exception.ConstraintViolationException;
import org.checkerframework.checker.nullness.qual.Nullable;

class BeanAssertUtil {
    private BeanAssertUtil() {
    }

    public static void validate(@Nullable RegistrationData registrationData) {
        BeanAssertUtil.validate((CoreRegistrationData)registrationData);
        BeanAssertUtil.validateAuthenticationExtensionsClientOutputs(registrationData.getClientExtensions());
        BeanAssertUtil.validate(registrationData.getCollectedClientData());
    }

    public static void validate(@Nullable CoreRegistrationData registrationData) {
        if (registrationData == null) {
            throw new ConstraintViolationException("registrationData must not be null");
        }
        BeanAssertUtil.validate(registrationData.getAttestationObject());
        if (registrationData.getAttestationObjectBytes() == null) {
            throw new ConstraintViolationException("attestationObjectBytes must not be null");
        }
        if (registrationData.getClientDataHash() == null) {
            throw new ConstraintViolationException("clientDataHash must not be null");
        }
    }

    public static void validate(@Nullable AuthenticationData authenticationData) {
        BeanAssertUtil.validate((CoreAuthenticationData)authenticationData);
        if (authenticationData.getCollectedClientData() == null) {
            throw new ConstraintViolationException("collectedClientData must not be null");
        }
        BeanAssertUtil.validate(authenticationData.getCollectedClientData());
        if (authenticationData.getCollectedClientDataBytes() == null) {
            throw new ConstraintViolationException("collectedClientDataBytes must not be null");
        }
        BeanAssertUtil.validateAuthenticationExtensionsClientOutputs(authenticationData.getClientExtensions());
    }

    public static void validate(@Nullable CoreAuthenticationData authenticationData) {
        if (authenticationData == null) {
            throw new ConstraintViolationException("authenticationData must not be null");
        }
        if (authenticationData.getCredentialId() == null) {
            throw new ConstraintViolationException("credentialId must not be null");
        }
        if (authenticationData.getSignature() == null) {
            throw new ConstraintViolationException("signature must not be null");
        }
        BeanAssertUtil.validate(authenticationData.getAuthenticatorData());
        if (authenticationData.getAuthenticatorDataBytes() == null) {
            throw new ConstraintViolationException("authenticatorDataBytes must not be null");
        }
    }

    public static void validate(@Nullable CollectedClientData collectedClientData) {
        if (collectedClientData == null) {
            throw new ConstraintViolationException("collectedClientData must not be null");
        }
        BeanAssertUtil.validate(collectedClientData.getTokenBinding());
    }

    public static void validate(@Nullable TokenBinding tokenBinding) {
    }

    public static void validate(@Nullable AttestationObject attestationObject) {
        if (attestationObject == null) {
            throw new ConstraintViolationException("attestationObject must not be null");
        }
        BeanAssertUtil.validate(attestationObject.getAttestationStatement());
        BeanAssertUtil.validate(attestationObject.getAuthenticatorData());
    }

    public static <T extends ExtensionAuthenticatorOutput> void validate(@Nullable AuthenticatorData<T> authenticatorData) {
        byte[] rpIdHash;
        if (authenticatorData == null) {
            throw new ConstraintViolationException("authenticatorData must not be null");
        }
        AttestedCredentialData attestedCredentialData = authenticatorData.getAttestedCredentialData();
        if (attestedCredentialData != null) {
            BeanAssertUtil.validate(attestedCredentialData);
        }
        if ((rpIdHash = authenticatorData.getRpIdHash()) == null) {
            throw new ConstraintViolationException("rpIdHash must not be null");
        }
        if (rpIdHash.length != 32) {
            throw new ConstraintViolationException("rpIdHash must be 32 bytes length");
        }
        long signCount = authenticatorData.getSignCount();
        if (signCount < 0L || signCount > 0xFFFFFFFFL) {
            throw new ConstraintViolationException("signCount must be unsigned int");
        }
        AuthenticationExtensionsAuthenticatorOutputs<T> extensions = authenticatorData.getExtensions();
        BeanAssertUtil.validateAuthenticatorExtensionsOutputs(extensions);
    }

    public static void validate(@Nullable AttestedCredentialData attestedCredentialData) {
        if (attestedCredentialData == null) {
            throw new ConstraintViolationException("attestedCredentialData must not be null");
        }
        if (attestedCredentialData.getCredentialId() == null) {
            throw new ConstraintViolationException("credentialId must not be null");
        }
        COSEKey coseKey = attestedCredentialData.getCOSEKey();
        BeanAssertUtil.validate(coseKey);
    }

    public static <T extends ExtensionClientOutput> void validateAuthenticationExtensionsClientOutputs(@Nullable AuthenticationExtensionsClientOutputs<T> authenticationExtensionsClientOutputs) {
        if (authenticationExtensionsClientOutputs == null) {
            return;
        }
        for (ExtensionClientOutput value : authenticationExtensionsClientOutputs.getExtensions().values()) {
            value.validate();
        }
    }

    public static <T extends ExtensionAuthenticatorOutput> void validateAuthenticatorExtensionsOutputs(@Nullable AuthenticationExtensionsAuthenticatorOutputs<T> authenticationExtensionsAuthenticatorOutputs) {
        if (authenticationExtensionsAuthenticatorOutputs == null) {
            return;
        }
        for (ExtensionAuthenticatorOutput value : authenticationExtensionsAuthenticatorOutputs.getExtensions().values()) {
            value.validate();
        }
    }

    public static void validate(@Nullable AttestationStatement attestationStatement) {
        if (attestationStatement == null) {
            throw new ConstraintViolationException("attestationStatement must not be null");
        }
        attestationStatement.validate();
    }

    public static void validate(@Nullable COSEKey coseKey) {
        if (coseKey == null) {
            throw new ConstraintViolationException("coseKey must not be null");
        }
        if (coseKey.getAlgorithm() == null) {
            throw new ConstraintViolationException("coseKey must not be null");
        }
        coseKey.validate();
    }
}

