/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.cache.infinispan.authorization.events;

import java.util.Objects;
import java.util.Set;
import org.keycloak.models.cache.infinispan.authorization.StoreFactoryCacheManager;
import org.keycloak.models.cache.infinispan.authorization.events.AuthorizationCacheInvalidationEvent;
import org.keycloak.models.cache.infinispan.events.InvalidationEvent;

public class PermissionTicketUpdatedEvent
extends InvalidationEvent
implements AuthorizationCacheInvalidationEvent {
    private String owner;
    private String resource;
    private String scope;
    private String serverId;
    private String requester;
    private String resourceName;

    private PermissionTicketUpdatedEvent(String id) {
        super(id);
    }

    public static PermissionTicketUpdatedEvent create(String id, String owner, String requester, String resource, String resourceName, String scope, String serverId) {
        PermissionTicketUpdatedEvent event = new PermissionTicketUpdatedEvent(id);
        event.owner = owner;
        event.requester = requester;
        event.resource = resource;
        event.resourceName = resourceName;
        event.scope = scope;
        event.serverId = serverId;
        return event;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        PermissionTicketUpdatedEvent that = (PermissionTicketUpdatedEvent)o;
        return Objects.equals(this.resource, that.resource) && Objects.equals(this.serverId, that.serverId);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.resource, this.serverId);
    }

    public String toString() {
        return String.format("PermissionTicketUpdatedEvent [ id=%s, name=%s]", this.getId(), this.resource);
    }

    @Override
    public void addInvalidations(StoreFactoryCacheManager cache, Set<String> invalidations) {
        cache.permissionTicketUpdated(this.getId(), this.owner, this.requester, this.resource, this.resourceName, this.scope, this.serverId, invalidations);
    }
}

