/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.id;

import org.hibernate.boot.spi.SessionFactoryOptions;
import org.hibernate.dialect.Dialect;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.generator.EventType;
import org.hibernate.generator.internal.NaturalIdHelper;
import org.hibernate.generator.values.internal.GeneratedValuesHelper;
import org.hibernate.id.BulkInsertionCapableIdentifierGenerator;
import org.hibernate.id.PostInsertIdentifierGenerator;
import org.hibernate.id.PostInsertIdentityPersister;
import org.hibernate.id.factory.spi.StandardGenerator;
import org.hibernate.id.insert.BasicSelectingDelegate;
import org.hibernate.id.insert.GetGeneratedKeysDelegate;
import org.hibernate.id.insert.InsertGeneratedIdentifierDelegate;
import org.hibernate.id.insert.InsertReturningDelegate;
import org.hibernate.id.insert.UniqueKeySelectingDelegate;
import org.hibernate.persister.entity.EntityPersister;

public class IdentityGenerator
implements PostInsertIdentifierGenerator,
BulkInsertionCapableIdentifierGenerator,
StandardGenerator {
    @Override
    public boolean referenceColumnsInSql(Dialect dialect) {
        return dialect.getIdentityColumnSupport().hasIdentityInsertKeyword();
    }

    @Override
    public String[] getReferencedColumnValues(Dialect dialect) {
        return new String[]{dialect.getIdentityColumnSupport().getIdentityInsertString()};
    }

    @Override
    public InsertGeneratedIdentifierDelegate getGeneratedIdentifierDelegate(PostInsertIdentityPersister persister) {
        SessionFactoryImplementor factory = persister.getFactory();
        Dialect dialect = factory.getJdbcServices().getDialect();
        SessionFactoryOptions sessionFactoryOptions = factory.getSessionFactoryOptions();
        if (dialect.supportsInsertReturningGeneratedKeys() && sessionFactoryOptions.isGetGeneratedKeysEnabled()) {
            return new GetGeneratedKeysDelegate((EntityPersister)persister, false, EventType.INSERT);
        }
        if (dialect.supportsInsertReturning() && GeneratedValuesHelper.noCustomSql(persister, EventType.INSERT)) {
            return new InsertReturningDelegate((EntityPersister)persister, EventType.INSERT);
        }
        if (sessionFactoryOptions.isGetGeneratedKeysEnabled()) {
            return dialect.getIdentityColumnSupport().buildGetGeneratedKeysDelegate(persister, dialect);
        }
        if (persister.getNaturalIdentifierProperties() != null && !persister.getEntityMetamodel().isNaturalIdentifierInsertGenerated()) {
            return new UniqueKeySelectingDelegate((EntityPersister)persister, NaturalIdHelper.getNaturalIdPropertyNames(persister), EventType.INSERT);
        }
        return new BasicSelectingDelegate((EntityPersister)persister);
    }
}

