/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.config.source.keystore;

import io.smallrye.config.AbstractLocationConfigSourceFactory;
import io.smallrye.config.ConfigSourceContext;
import io.smallrye.config.ConfigSourceFactory;
import io.smallrye.config.ConfigValue;
import io.smallrye.config.PropertiesConfigSource;
import io.smallrye.config.SmallRyeConfig;
import io.smallrye.config.SmallRyeConfigBuilder;
import io.smallrye.config._private.ConfigMessages;
import io.smallrye.config.source.keystore.KeyStoreConfig;
import java.io.IOException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.security.Key;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.Set;
import org.eclipse.microprofile.config.spi.ConfigSource;

public class KeyStoreConfigSourceFactory
implements ConfigSourceFactory {
    public Iterable<ConfigSource> getConfigSources(final ConfigSourceContext context) {
        KeyStoreConfig keyStoreConfig = KeyStoreConfigSourceFactory.getKeyStoreConfig(context);
        HashMap<String, KeyStoreConfig.KeyStore> prioritized = new HashMap<String, KeyStoreConfig.KeyStore>();
        HashMap<String, KeyStoreConfig.KeyStore> late = new HashMap<String, KeyStoreConfig.KeyStore>();
        for (Map.Entry<String, KeyStoreConfig.KeyStore> keyStoreEntry : keyStoreConfig.keystores().entrySet()) {
            if (keyStoreEntry.getValue().handler().isEmpty()) {
                prioritized.put((String)keyStoreEntry.getKey(), (KeyStoreConfig.KeyStore)keyStoreEntry.getValue());
                continue;
            }
            late.put((String)keyStoreEntry.getKey(), (KeyStoreConfig.KeyStore)keyStoreEntry.getValue());
        }
        final ArrayList<ConfigSource> keyStoreSources = new ArrayList<ConfigSource>();
        for (Map.Entry entry : prioritized.entrySet()) {
            for (ConfigSource configSource : KeyStoreConfigSourceFactory.loadKeyStoreSources(context, (String)entry.getKey(), (KeyStoreConfig.KeyStore)entry.getValue())) {
                keyStoreSources.add(configSource);
            }
        }
        ConfigSourceContext keyStoreContext = new ConfigSourceContext(){
            final SmallRyeConfig contextConfig;
            {
                this.contextConfig = new SmallRyeConfigBuilder().withSources(new ConfigSource[]{new ConfigSourceContext.ConfigSourceContextConfigSource(context)}).withSources((Collection)keyStoreSources).build();
            }

            public ConfigValue getValue(String name) {
                return this.contextConfig.getConfigValue(name);
            }

            public Iterator<String> iterateNames() {
                return this.contextConfig.getPropertyNames().iterator();
            }
        };
        for (Map.Entry keyStoreEntry : late.entrySet()) {
            for (ConfigSource configSource : KeyStoreConfigSourceFactory.loadKeyStoreSources(keyStoreContext, (String)keyStoreEntry.getKey(), (KeyStoreConfig.KeyStore)keyStoreEntry.getValue())) {
                keyStoreSources.add(configSource);
            }
        }
        return keyStoreSources;
    }

    private static KeyStoreConfig getKeyStoreConfig(ConfigSourceContext context) {
        SmallRyeConfig config = new SmallRyeConfigBuilder().withSources(new ConfigSource[]{new ConfigSourceContext.ConfigSourceContextConfigSource(context)}).withMapping(KeyStoreConfig.class).withMappingIgnore("smallrye.config.source.keystore.*.password").build();
        return (KeyStoreConfig)config.getConfigMapping(KeyStoreConfig.class);
    }

    private static Iterable<ConfigSource> loadKeyStoreSources(final ConfigSourceContext context, final String name, final KeyStoreConfig.KeyStore keyStore) {
        return new AbstractLocationConfigSourceFactory(){

            protected String[] getFileExtensions() {
                return new String[0];
            }

            protected ConfigSource loadConfigSource(URL url, int ordinal) throws IOException {
                ConfigValue password = KeyStoreConfigSourceFactory.getPassword(context, name);
                return new UrlKeyStoreConfigSource(url, ordinal).loadKeyStore(keyStore, password.getValue().toCharArray());
            }

            public Iterable<ConfigSource> getConfigSources(ConfigSourceContext context2) {
                return this.loadConfigSources(keyStore.path(), 100);
            }
        }.getConfigSources(context);
    }

    private static ConfigValue getPassword(ConfigSourceContext context, String name) {
        String passwordName = "smallrye.config.source.keystore." + name + ".password";
        ConfigValue password = context.getValue(passwordName);
        if (!(password != null && password.getValue() != null || (password = context.getValue(passwordName = "smallrye.config.source.keystore.\"" + name + "\".password")) != null && password.getValue() != null)) {
            throw new NoSuchElementException(ConfigMessages.msg.propertyNotFound(passwordName));
        }
        return password;
    }

    private static class UrlKeyStoreConfigSource
    implements ConfigSource {
        private final URL url;
        private final int ordinal;

        UrlKeyStoreConfigSource(URL url, int ordinal) {
            this.url = url;
            this.ordinal = ordinal;
        }

        ConfigSource loadKeyStore(final KeyStoreConfig.KeyStore keyStoreConfig, char[] password) throws IOException {
            try {
                KeyStore keyStore = KeyStore.getInstance(keyStoreConfig.type());
                keyStore.load(this.url.openStream(), password);
                HashMap<String, Object> properties = new HashMap<String, Object>();
                Enumeration<String> aliases = keyStore.aliases();
                while (aliases.hasMoreElements()) {
                    final String alias = aliases.nextElement();
                    KeyStoreConfig.KeyStore.Alias aliasConfig = keyStoreConfig.aliases().getOrDefault(alias, new KeyStoreConfig.KeyStore.Alias(){

                        @Override
                        public Optional<String> name() {
                            return Optional.of(alias);
                        }

                        @Override
                        public Optional<String> handler() {
                            return keyStoreConfig.handler();
                        }
                    });
                    if (keyStore.isKeyEntry(alias)) {
                        Key key = keyStore.getKey(alias, password);
                        Optional<String> handler = aliasConfig.handler();
                        Object encoded = handler.isPresent() ? "${" + handler.get() + "::" + new String(key.getEncoded(), StandardCharsets.UTF_8) + "}" : new String(key.getEncoded(), StandardCharsets.UTF_8);
                        properties.put(aliasConfig.name().orElse(alias), encoded);
                        continue;
                    }
                    if (!keyStore.isCertificateEntry(alias)) continue;
                }
                return new PropertiesConfigSource(properties, this.getName(), this.getOrdinal());
            }
            catch (KeyStoreException | NoSuchAlgorithmException | UnrecoverableKeyException | CertificateException e) {
                throw new RuntimeException(e);
            }
        }

        public int getOrdinal() {
            return this.ordinal;
        }

        public Set<String> getPropertyNames() {
            throw new UnsupportedOperationException();
        }

        public String getValue(String propertyName) {
            throw new UnsupportedOperationException();
        }

        public String getName() {
            return "KeyStoreConfigSource[source=" + this.url.toString() + "]";
        }
    }
}

