/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.hibernate.orm.deployment.xml;

import io.quarkus.hibernate.orm.runtime.boot.xml.RecordableXmlMapping;
import io.quarkus.hibernate.orm.runtime.customized.QuarkusStrategySelectorBuilder;
import io.quarkus.hibernate.orm.runtime.service.FlatClassLoaderService;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.hibernate.boot.archive.internal.ArchiveHelper;
import org.hibernate.boot.jaxb.spi.Binding;
import org.hibernate.boot.registry.BootstrapServiceRegistry;
import org.hibernate.boot.registry.BootstrapServiceRegistryBuilder;
import org.hibernate.boot.registry.classloading.spi.ClassLoaderService;
import org.hibernate.boot.registry.internal.BootstrapServiceRegistryImpl;
import org.hibernate.boot.registry.selector.spi.StrategySelector;
import org.hibernate.boot.spi.XmlMappingBinderAccess;
import org.hibernate.integrator.spi.Integrator;
import org.hibernate.integrator.spi.IntegratorService;
import org.hibernate.service.ServiceRegistry;

public final class QuarkusMappingFileParser
implements AutoCloseable {
    private final BootstrapServiceRegistry serviceRegistry;
    private final XmlMappingBinderAccess binderAccess;

    public static QuarkusMappingFileParser create() {
        BootstrapServiceRegistry serviceRegistry = QuarkusMappingFileParser.createEmptyBootstrapServiceRegistry();
        XmlMappingBinderAccess binderAccess = new XmlMappingBinderAccess((ServiceRegistry)serviceRegistry);
        return new QuarkusMappingFileParser(serviceRegistry, binderAccess);
    }

    public QuarkusMappingFileParser(BootstrapServiceRegistry serviceRegistry, XmlMappingBinderAccess binderAccess) {
        this.serviceRegistry = serviceRegistry;
        this.binderAccess = binderAccess;
    }

    @Override
    public void close() {
        BootstrapServiceRegistryBuilder.destroy((ServiceRegistry)this.serviceRegistry);
    }

    public Optional<RecordableXmlMapping> parse(String persistenceUnitName, URL persistenceUnitRootUrl, String mappingFilePath) {
        Optional<RecordableXmlMapping> optional;
        block9: {
            URL url = this.locateMappingFile(persistenceUnitName, persistenceUnitRootUrl, mappingFilePath);
            if (url == null) {
                return Optional.empty();
            }
            InputStream stream = url.openStream();
            try {
                Binding binding = this.binderAccess.bind(stream);
                optional = Optional.of(RecordableXmlMapping.create((Binding)binding));
                if (stream == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (stream != null) {
                        try {
                            stream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException | RuntimeException e) {
                    throw new IllegalStateException("Error reading mapping file '" + mappingFilePath + "' ('" + url + "'): " + e.getMessage(), e);
                }
            }
            stream.close();
        }
        return optional;
    }

    private URL locateMappingFile(String persistenceUnitName, URL persistenceUnitRootUrl, String mappingFileName) {
        List mappingFileURLs = FlatClassLoaderService.INSTANCE.locateResources(mappingFileName);
        if (mappingFileURLs.isEmpty()) {
            return null;
        }
        if (mappingFileURLs.size() == 1) {
            return (URL)mappingFileURLs.get(0);
        }
        URL urlInSameMappingFile = null;
        if (persistenceUnitRootUrl != null) {
            for (URL url : mappingFileURLs) {
                if (!persistenceUnitRootUrl.equals(ArchiveHelper.getJarURLFromURLEntry((URL)url, (String)mappingFileName))) continue;
                if (urlInSameMappingFile == null) {
                    urlInSameMappingFile = url;
                    continue;
                }
                urlInSameMappingFile = null;
                break;
            }
        }
        if (urlInSameMappingFile == null) {
            throw new IllegalStateException("Persistence unit '" + persistenceUnitName + "' references mapping file '" + mappingFileName + "', but multiple resources with this path exist in the classpath, and it is not possible to resolve the ambiguity. URLs of matching resources found in the classpath: " + mappingFileURLs);
        }
        return urlInSameMappingFile;
    }

    private static BootstrapServiceRegistry createEmptyBootstrapServiceRegistry() {
        ClassLoaderService providedClassLoaderService = FlatClassLoaderService.INSTANCE;
        IntegratorService integratorService = new IntegratorService(){

            public Iterable<Integrator> getIntegrators() {
                return Collections.emptyList();
            }
        };
        StrategySelector strategySelector = QuarkusStrategySelectorBuilder.buildSelector((ClassLoaderService)providedClassLoaderService);
        return new BootstrapServiceRegistryImpl(true, providedClassLoaderService, strategySelector, integratorService);
    }
}

