/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.sessions.infinispan.changes;

import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.infinispan.AdvancedCache;
import org.infinispan.Cache;
import org.infinispan.context.Flag;
import org.jboss.logging.Logger;
import org.keycloak.models.sessions.infinispan.CacheDecorators;
import org.keycloak.models.sessions.infinispan.changes.MergedUpdate;
import org.keycloak.models.sessions.infinispan.changes.ReplaceFunction;
import org.keycloak.models.sessions.infinispan.changes.SerializeExecutionsByKey;
import org.keycloak.models.sessions.infinispan.changes.SessionChangesPerformer;
import org.keycloak.models.sessions.infinispan.changes.SessionEntityWrapper;
import org.keycloak.models.sessions.infinispan.changes.SessionUpdateTask;
import org.keycloak.models.sessions.infinispan.changes.SessionUpdatesList;
import org.keycloak.models.sessions.infinispan.entities.SessionEntity;

public class EmbeddedCachesChangesPerformer<K, V extends SessionEntity>
implements SessionChangesPerformer<K, V> {
    private static final Logger LOG = Logger.getLogger(EmbeddedCachesChangesPerformer.class);
    private final Cache<K, SessionEntityWrapper<V>> cache;
    private final SerializeExecutionsByKey<K> serializer;
    private final List<Runnable> changes = new LinkedList<Runnable>();

    public EmbeddedCachesChangesPerformer(Cache<K, SessionEntityWrapper<V>> cache, SerializeExecutionsByKey<K> serializer) {
        this.cache = cache;
        this.serializer = serializer;
    }

    private void runOperationInCluster(K key, MergedUpdate<V> task, SessionEntityWrapper<V> sessionWrapper) {
        SessionUpdateTask.CacheOperation operation = task.getOperation();
        switch (operation) {
            case REMOVE: {
                CacheDecorators.skipCacheStoreIfRemoteCacheIsEnabled(this.cache).withFlags(Flag.IGNORE_RETURN_VALUES).remove(key);
                break;
            }
            case ADD: {
                CacheDecorators.skipCacheStoreIfRemoteCacheIsEnabled(this.cache).withFlags(Flag.IGNORE_RETURN_VALUES).put(key, sessionWrapper, task.getLifespanMs(), TimeUnit.MILLISECONDS, task.getMaxIdleTimeMs(), TimeUnit.MILLISECONDS);
                LOG.tracef("Added entity '%s' to the cache '%s' . Lifespan: %d ms, MaxIdle: %d ms", new Object[]{key, this.cache.getName(), task.getLifespanMs(), task.getMaxIdleTimeMs()});
                break;
            }
            case ADD_IF_ABSENT: {
                SessionEntityWrapper existing = (SessionEntityWrapper)CacheDecorators.skipCacheStoreIfRemoteCacheIsEnabled(this.cache).putIfAbsent(key, sessionWrapper, task.getLifespanMs(), TimeUnit.MILLISECONDS, task.getMaxIdleTimeMs(), TimeUnit.MILLISECONDS);
                if (existing != null) {
                    LOG.debugf("Existing entity in cache for key: %s . Will update it", key);
                    task.runUpdate(existing.getEntity());
                    this.replace(key, task, existing, task.getLifespanMs(), task.getMaxIdleTimeMs());
                    break;
                }
                LOG.tracef("Add_if_absent successfully called for entity '%s' to the cache '%s' . Lifespan: %d ms, MaxIdle: %d ms", new Object[]{key, this.cache.getName(), task.getLifespanMs(), task.getMaxIdleTimeMs()});
                break;
            }
            case REPLACE: {
                this.replace(key, task, sessionWrapper, task.getLifespanMs(), task.getMaxIdleTimeMs());
                break;
            }
            default: {
                throw new IllegalStateException("Unsupported state " + operation);
            }
        }
    }

    private void replace(K key, MergedUpdate<V> task, SessionEntityWrapper<V> oldVersionEntity, long lifespanMs, long maxIdleTimeMs) {
        this.serializer.runSerialized(key, () -> {
            SessionEntityWrapper oldVersion = oldVersionEntity;
            SessionEntityWrapper returnValue = null;
            int iteration = 0;
            Object session = oldVersion.getEntity();
            AdvancedCache<K, SessionEntityWrapper<V>> writeCache = CacheDecorators.skipCacheStoreIfRemoteCacheIsEnabled(this.cache);
            while (iteration++ < 25) {
                SessionEntityWrapper newVersionEntity = this.generateNewVersionAndWrapEntity(session, oldVersion.getLocalMetadata());
                returnValue = (SessionEntityWrapper)writeCache.computeIfPresent(key, new ReplaceFunction(oldVersion.getVersion(), newVersionEntity), lifespanMs, TimeUnit.MILLISECONDS, maxIdleTimeMs, TimeUnit.MILLISECONDS);
                if (returnValue == null) {
                    LOG.debugf("Entity %s not found. Maybe removed in the meantime. Replace task will be ignored", key);
                    return;
                }
                if (returnValue.getVersion().equals(newVersionEntity.getVersion())) {
                    if (LOG.isTraceEnabled()) {
                        LOG.tracef("Replace SUCCESS for entity: %s . old version: %s, new version: %s, Lifespan: %d ms, MaxIdle: %d ms", new Object[]{key, oldVersion.getVersion(), newVersionEntity.getVersion(), task.getLifespanMs(), task.getMaxIdleTimeMs()});
                    }
                    return;
                }
                oldVersion = returnValue;
                session = oldVersion.getEntity();
                task.runUpdate(session);
            }
            LOG.warnf("Failed to replace entity '%s' in cache '%s'. Expected: %s, Current: %s", new Object[]{key, this.cache.getName(), oldVersion, returnValue});
        });
    }

    private SessionEntityWrapper<V> generateNewVersionAndWrapEntity(V entity, Map<String, String> localMetadata) {
        return new SessionEntityWrapper<V>(localMetadata, entity);
    }

    @Override
    public void registerChange(Map.Entry<K, SessionUpdatesList<V>> entry, MergedUpdate<V> merged) {
        this.changes.add(() -> this.runOperationInCluster(entry.getKey(), merged, ((SessionUpdatesList)entry.getValue()).getEntityWrapper()));
    }

    @Override
    public void applyChanges() {
        this.changes.forEach(Runnable::run);
    }
}

