/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.quarkus.runtime;

import io.agroal.api.AgroalDataSource;
import io.quarkus.agroal.DataSource;
import io.quarkus.arc.Arc;
import io.quarkus.arc.InstanceHandle;
import io.quarkus.hibernate.orm.runtime.integration.HibernateOrmIntegrationRuntimeInitListener;
import io.quarkus.runtime.RuntimeValue;
import io.quarkus.runtime.ShutdownContext;
import io.quarkus.runtime.annotations.Recorder;
import io.vertx.core.Handler;
import io.vertx.ext.web.RoutingContext;
import java.io.BufferedReader;
import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.annotation.Annotation;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import liquibase.Scope;
import liquibase.servicelocator.ServiceLocator;
import org.infinispan.commons.util.FileLookupFactory;
import org.keycloak.Config;
import org.keycloak.common.Profile;
import org.keycloak.common.crypto.CryptoIntegration;
import org.keycloak.common.crypto.CryptoProvider;
import org.keycloak.common.crypto.FipsMode;
import org.keycloak.config.TruststoreOptions;
import org.keycloak.provider.Provider;
import org.keycloak.provider.ProviderFactory;
import org.keycloak.provider.Spi;
import org.keycloak.quarkus.runtime.Environment;
import org.keycloak.quarkus.runtime.configuration.Configuration;
import org.keycloak.quarkus.runtime.configuration.MicroProfileConfigProvider;
import org.keycloak.quarkus.runtime.integration.QuarkusKeycloakSessionFactory;
import org.keycloak.quarkus.runtime.storage.database.liquibase.FastServiceLocator;
import org.keycloak.quarkus.runtime.storage.infinispan.CacheManagerFactory;
import org.keycloak.representations.userprofile.config.UPConfig;
import org.keycloak.theme.ClasspathThemeProviderFactory;
import org.keycloak.truststore.TruststoreBuilder;
import org.keycloak.userprofile.DeclarativeUserProfileProviderFactory;

@Recorder
public class KeycloakRecorder {
    public static final String DEFAULT_HEALTH_ENDPOINT = "/health";
    public static final String DEFAULT_METRICS_ENDPOINT = "/metrics";

    public void initConfig() {
        Config.init((Config.ConfigProvider)new MicroProfileConfigProvider());
    }

    public void configureProfile(Profile.ProfileName profileName, Map<Profile.Feature, Boolean> features) {
        Profile.init((Profile.ProfileName)profileName, features);
    }

    public Handler<RoutingContext> getRedirectHandler(String redirectPath) {
        return routingContext -> routingContext.redirect(redirectPath);
    }

    public Handler<RoutingContext> getManagementHandler() {
        return routingContext -> routingContext.response().end("Keycloak Management Interface");
    }

    public void configureTruststore() {
        String[] truststores = Configuration.getOptionalKcValue(TruststoreOptions.TRUSTSTORE_PATHS.getKey()).map(s -> s.split(",")).orElse(new String[0]);
        String dataDir = Environment.getDataDir();
        File truststoresDir = Optional.ofNullable(Environment.getHomePath()).map(path -> path.resolve("conf").resolve("truststores").toFile()).orElse(null);
        if (truststoresDir != null && truststoresDir.exists() && Optional.ofNullable(truststoresDir.list()).map(a -> ((String[])a).length).orElse(0) > 0) {
            truststores = (String[])Stream.concat(Stream.of(truststoresDir.getAbsolutePath()), Stream.of(truststores)).toArray(String[]::new);
        } else if (truststores.length == 0) {
            return;
        }
        TruststoreBuilder.setSystemTruststore((String[])truststores, (boolean)true, (String)dataDir);
    }

    public void configureLiquibase(Map<String, List<String>> services) {
        ServiceLocator locator = Scope.getCurrentScope().getServiceLocator();
        if (locator instanceof FastServiceLocator) {
            ((FastServiceLocator)locator).initServices(services);
        }
    }

    public void configSessionFactory(Map<Spi, Map<Class<? extends Provider>, Map<String, Class<? extends ProviderFactory>>>> factories, Map<Class<? extends Provider>, String> defaultProviders, Map<String, ProviderFactory> preConfiguredProviders, List<ClasspathThemeProviderFactory.ThemesRepresentation> themes, boolean reaugmented) {
        QuarkusKeycloakSessionFactory.setInstance(new QuarkusKeycloakSessionFactory(factories, defaultProviders, preConfiguredProviders, themes, reaugmented));
    }

    public RuntimeValue<CacheManagerFactory> createCacheInitializer(ShutdownContext shutdownContext) {
        try {
            CacheManagerFactory cacheManagerFactory = new CacheManagerFactory(this.getInfinispanConfigFile());
            shutdownContext.addShutdownTask(cacheManagerFactory::shutdown);
            return new RuntimeValue((Object)cacheManagerFactory);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private String getInfinispanConfigFile() {
        String configFile = Configuration.getKcConfigValue("spi-connections-infinispan-quarkus-config-file").getValue();
        if (configFile != null) {
            String string;
            Path configPath = Paths.get(configFile, new String[0]);
            String path = configPath.toFile().exists() ? configPath.toFile().getAbsolutePath() : configPath.getFileName().toString();
            InputStream url = FileLookupFactory.newInstance().lookupFile(path, KeycloakRecorder.class.getClassLoader());
            if (url == null) {
                throw new IllegalArgumentException("Could not load cluster configuration file at [" + configPath + "]");
            }
            BufferedReader reader = new BufferedReader(new InputStreamReader(url));
            try {
                string = reader.lines().collect(Collectors.joining("\n"));
            }
            catch (Throwable throwable) {
                try {
                    try {
                        reader.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (Exception cause) {
                    throw new RuntimeException("Failed to read clustering configuration from [" + url + "]", cause);
                }
            }
            reader.close();
            return string;
        }
        throw new IllegalArgumentException("Option 'configFile' needs to be specified");
    }

    public void setDefaultUserProfileConfiguration(UPConfig configuration) {
        DeclarativeUserProfileProviderFactory.setDefaultConfig((UPConfig)configuration);
    }

    public void registerShutdownHook(ShutdownContext shutdownContext) {
        shutdownContext.addShutdownTask(new Runnable(){

            @Override
            public void run() {
                QuarkusKeycloakSessionFactory.getInstance().close();
            }
        });
    }

    public HibernateOrmIntegrationRuntimeInitListener createUserDefinedUnitListener(final String name) {
        return new HibernateOrmIntegrationRuntimeInitListener(){

            public void contributeRuntimeProperties(BiConsumer<String, Object> propertyCollector) {
                InstanceHandle instance = Arc.container().instance(AgroalDataSource.class, new Annotation[]{new DataSource(){

                    public Class<? extends Annotation> annotationType() {
                        return DataSource.class;
                    }

                    public String value() {
                        return name;
                    }
                }});
                propertyCollector.accept("hibernate.connection.datasource", instance.get());
            }
        };
    }

    public HibernateOrmIntegrationRuntimeInitListener createDefaultUnitListener() {
        return new HibernateOrmIntegrationRuntimeInitListener(){

            public void contributeRuntimeProperties(BiConsumer<String, Object> propertyCollector) {
                propertyCollector.accept("hibernate.default_schema", Configuration.getRawValue("kc.db-schema"));
            }
        };
    }

    public void setCryptoProvider(FipsMode fipsMode) {
        String cryptoProvider = fipsMode.getProviderClassName();
        try {
            CryptoIntegration.setProvider((CryptoProvider)((CryptoProvider)Thread.currentThread().getContextClassLoader().loadClass(cryptoProvider).getDeclaredConstructor(new Class[0]).newInstance(new Object[0])));
        }
        catch (ClassNotFoundException | NoClassDefFoundError cause) {
            if (fipsMode.isFipsEnabled()) {
                throw new RuntimeException("Failed to configure FIPS. Make sure you have added the Bouncy Castle FIPS dependencies to the 'providers' directory.");
            }
            throw new RuntimeException("Unexpected error when configuring the crypto provider: " + cryptoProvider, cause);
        }
        catch (Exception cause) {
            throw new RuntimeException("Unexpected error when configuring the crypto provider: " + cryptoProvider, cause);
        }
    }
}

