/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.boot.model.internal;

import jakarta.persistence.ElementCollection;
import jakarta.persistence.Enumerated;
import jakarta.persistence.Id;
import jakarta.persistence.Lob;
import jakarta.persistence.MapKeyClass;
import jakarta.persistence.MapKeyEnumerated;
import jakarta.persistence.MapKeyTemporal;
import jakarta.persistence.Temporal;
import jakarta.persistence.TemporalType;
import jakarta.persistence.Version;
import java.io.Serializable;
import java.lang.reflect.ParameterizedType;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import org.hibernate.AnnotationException;
import org.hibernate.AssertionFailure;
import org.hibernate.MappingException;
import org.hibernate.TimeZoneStorageStrategy;
import org.hibernate.annotations.AnyDiscriminator;
import org.hibernate.annotations.AnyKeyJavaClass;
import org.hibernate.annotations.AnyKeyJavaType;
import org.hibernate.annotations.AnyKeyJdbcType;
import org.hibernate.annotations.AnyKeyJdbcTypeCode;
import org.hibernate.annotations.CollectionId;
import org.hibernate.annotations.CollectionIdJavaType;
import org.hibernate.annotations.CollectionIdJdbcType;
import org.hibernate.annotations.CollectionIdJdbcTypeCode;
import org.hibernate.annotations.CollectionIdMutability;
import org.hibernate.annotations.CollectionIdType;
import org.hibernate.annotations.Immutable;
import org.hibernate.annotations.JdbcTypeCode;
import org.hibernate.annotations.ListIndexJavaType;
import org.hibernate.annotations.ListIndexJdbcType;
import org.hibernate.annotations.ListIndexJdbcTypeCode;
import org.hibernate.annotations.MapKeyJavaType;
import org.hibernate.annotations.MapKeyJdbcType;
import org.hibernate.annotations.MapKeyJdbcTypeCode;
import org.hibernate.annotations.MapKeyMutability;
import org.hibernate.annotations.MapKeyType;
import org.hibernate.annotations.Mutability;
import org.hibernate.annotations.Nationalized;
import org.hibernate.annotations.Parameter;
import org.hibernate.annotations.PartitionKey;
import org.hibernate.annotations.Target;
import org.hibernate.annotations.TimeZoneColumn;
import org.hibernate.annotations.TimeZoneStorage;
import org.hibernate.annotations.TimeZoneStorageType;
import org.hibernate.annotations.Type;
import org.hibernate.annotations.common.reflection.XAnnotatedElement;
import org.hibernate.annotations.common.reflection.XClass;
import org.hibernate.annotations.common.reflection.XProperty;
import org.hibernate.boot.model.TypeDefinition;
import org.hibernate.boot.model.convert.spi.ConverterDescriptor;
import org.hibernate.boot.model.internal.AnnotatedColumn;
import org.hibernate.boot.model.internal.AnnotatedColumns;
import org.hibernate.boot.model.internal.AnnotatedJoinColumns;
import org.hibernate.boot.model.internal.ComponentPropertyHolder;
import org.hibernate.boot.model.internal.HCANNHelper;
import org.hibernate.boot.model.internal.PkDrivenByDefaultMapsIdSecondPass;
import org.hibernate.boot.model.internal.SetBasicValueTypeSecondPass;
import org.hibernate.boot.spi.AccessType;
import org.hibernate.boot.spi.InFlightMetadataCollector;
import org.hibernate.boot.spi.MetadataBuildingContext;
import org.hibernate.dialect.Dialect;
import org.hibernate.dialect.NationalizationSupport;
import org.hibernate.internal.CoreMessageLogger;
import org.hibernate.internal.util.ReflectHelper;
import org.hibernate.mapping.BasicValue;
import org.hibernate.mapping.Component;
import org.hibernate.mapping.Table;
import org.hibernate.resource.beans.internal.FallbackBeanInstanceProducer;
import org.hibernate.resource.beans.spi.ManagedBean;
import org.hibernate.resource.beans.spi.ManagedBeanRegistry;
import org.hibernate.type.BasicType;
import org.hibernate.type.EnumType;
import org.hibernate.type.SerializableToBlobType;
import org.hibernate.type.descriptor.java.BasicJavaType;
import org.hibernate.type.descriptor.java.Immutability;
import org.hibernate.type.descriptor.java.ImmutableMutabilityPlan;
import org.hibernate.type.descriptor.java.JavaType;
import org.hibernate.type.descriptor.java.MutabilityPlan;
import org.hibernate.type.descriptor.jdbc.JdbcType;
import org.hibernate.type.descriptor.jdbc.JdbcTypeIndicators;
import org.hibernate.type.descriptor.jdbc.spi.JdbcTypeRegistry;
import org.hibernate.type.spi.TypeConfiguration;
import org.hibernate.usertype.DynamicParameterizedType;
import org.hibernate.usertype.UserType;
import org.jboss.logging.Logger;

public class BasicValueBinder
implements JdbcTypeIndicators {
    private static final CoreMessageLogger LOG = (CoreMessageLogger)Logger.getMessageLogger(CoreMessageLogger.class, (String)BasicValueBinder.class.getName());
    private final Kind kind;
    private final Component aggregateComponent;
    private final MetadataBuildingContext buildingContext;
    private String explicitBasicTypeName;
    private Class<? extends UserType<?>> explicitCustomType;
    private Map<String, String> explicitLocalTypeParams;
    private Function<TypeConfiguration, JdbcType> explicitJdbcTypeAccess;
    private Function<TypeConfiguration, BasicJavaType> explicitJavaTypeAccess;
    private Function<TypeConfiguration, MutabilityPlan> explicitMutabilityAccess;
    private Function<TypeConfiguration, java.lang.reflect.Type> implicitJavaTypeAccess;
    private XProperty xproperty;
    private AccessType accessType;
    private ConverterDescriptor converterDescriptor;
    private boolean isNationalized;
    private boolean isLob;
    private jakarta.persistence.EnumType enumType;
    private TemporalType temporalPrecision;
    private TimeZoneStorageType timeZoneStorageType;
    private boolean partitionKey;
    private Integer jdbcTypeCode;
    private Table table;
    private AnnotatedColumns columns;
    private BasicValue basicValue;
    private String timeStampVersionType;
    private String persistentClassName;
    private String propertyName;
    private String returnedClassName;
    private String referencedEntityName;

    public BasicValueBinder(Kind kind, MetadataBuildingContext buildingContext) {
        this(kind, null, buildingContext);
    }

    public BasicValueBinder(Kind kind, Component aggregateComponent, MetadataBuildingContext buildingContext) {
        assert (kind != null);
        assert (buildingContext != null);
        this.kind = kind;
        this.aggregateComponent = aggregateComponent;
        this.buildingContext = buildingContext;
    }

    @Override
    public TypeConfiguration getTypeConfiguration() {
        return this.buildingContext.getBootstrapContext().getTypeConfiguration();
    }

    @Override
    public TimeZoneStorageStrategy getDefaultTimeZoneStorageStrategy() {
        return BasicValue.timeZoneStorageStrategy(this.timeZoneStorageType, this.buildingContext);
    }

    @Override
    public jakarta.persistence.EnumType getEnumeratedType() {
        return this.enumType;
    }

    @Override
    public boolean isLob() {
        JdbcType type;
        if (this.isLob) {
            return true;
        }
        if (this.explicitJdbcTypeAccess != null && (type = this.explicitJdbcTypeAccess.apply(this.getTypeConfiguration())) != null) {
            return type.isLob();
        }
        return false;
    }

    @Override
    public TemporalType getTemporalPrecision() {
        return this.temporalPrecision;
    }

    @Override
    public boolean isPreferJavaTimeJdbcTypesEnabled() {
        return this.buildingContext.isPreferJavaTimeJdbcTypesEnabled();
    }

    @Override
    public boolean isPreferNativeEnumTypesEnabled() {
        return this.buildingContext.isPreferNativeEnumTypesEnabled();
    }

    @Override
    public int getPreferredSqlTypeCodeForBoolean() {
        return this.resolveJdbcTypeCode(this.buildingContext.getPreferredSqlTypeCodeForBoolean());
    }

    @Override
    public int getPreferredSqlTypeCodeForDuration() {
        return this.resolveJdbcTypeCode(this.buildingContext.getPreferredSqlTypeCodeForDuration());
    }

    @Override
    public int getPreferredSqlTypeCodeForUuid() {
        return this.resolveJdbcTypeCode(this.buildingContext.getPreferredSqlTypeCodeForUuid());
    }

    @Override
    public int getPreferredSqlTypeCodeForInstant() {
        return this.resolveJdbcTypeCode(this.buildingContext.getPreferredSqlTypeCodeForInstant());
    }

    @Override
    public int getPreferredSqlTypeCodeForArray() {
        return this.resolveJdbcTypeCode(this.buildingContext.getPreferredSqlTypeCodeForArray());
    }

    @Override
    public int resolveJdbcTypeCode(int jdbcTypeCode) {
        return this.aggregateComponent == null ? jdbcTypeCode : this.buildingContext.getMetadataCollector().getDatabase().getDialect().getAggregateSupport().aggregateComponentSqlTypeCode(this.aggregateComponent.getAggregateColumn().getSqlTypeCode(), jdbcTypeCode);
    }

    @Override
    public boolean isNationalized() {
        JdbcType type;
        if (this.isNationalized) {
            return true;
        }
        if (this.explicitJdbcTypeAccess != null && (type = this.explicitJdbcTypeAccess.apply(this.getTypeConfiguration())) != null) {
            return type.isNationalized();
        }
        return false;
    }

    public void setVersion(boolean isVersion) {
        if (isVersion && this.basicValue != null) {
            this.basicValue.makeVersion();
        }
    }

    public void setTimestampVersionType(String versionType) {
        this.timeStampVersionType = versionType;
    }

    public void setReferencedEntityName(String referencedEntityName) {
        this.referencedEntityName = referencedEntityName;
    }

    public void setPropertyName(String propertyName) {
        this.propertyName = propertyName;
    }

    public void setReturnedClassName(String returnedClassName) {
        this.returnedClassName = returnedClassName;
    }

    public void setTable(Table table) {
        this.table = table;
    }

    public void setColumns(AnnotatedColumns columns) {
        this.columns = columns;
    }

    public void setPersistentClassName(String persistentClassName) {
        this.persistentClassName = persistentClassName;
    }

    public void setAccessType(AccessType accessType) {
        this.accessType = accessType;
    }

    public void setType(XProperty modelXProperty, XClass modelPropertyTypeXClass, String declaringClassName, ConverterDescriptor converterDescriptor) {
        this.xproperty = modelXProperty;
        boolean isArray = modelXProperty.isArray();
        if (modelPropertyTypeXClass == null && !isArray) {
            return;
        }
        if (this.columns == null) {
            throw new AssertionFailure("`BasicValueBinder#setColumns` should be called before `BasicValueBinder#setType`");
        }
        XClass modelTypeXClass = isArray ? modelXProperty.getElementClass() : modelPropertyTypeXClass;
        java.lang.reflect.Type modelJavaType = this.resolveJavaType(modelTypeXClass);
        if (modelJavaType == null) {
            throw new IllegalStateException("BasicType requires Java type");
        }
        if (this.kind != Kind.LIST_INDEX && this.kind != Kind.MAP_KEY) {
            this.isLob = modelXProperty.isAnnotationPresent(Lob.class);
        }
        if (this.getDialect().getNationalizationSupport() == NationalizationSupport.EXPLICIT) {
            this.isNationalized = HCANNHelper.findAnnotation((XAnnotatedElement)modelXProperty, Nationalized.class) != null || this.buildingContext.getBuildingOptions().useNationalizedCharacterData();
        }
        this.applyJpaConverter(modelXProperty, converterDescriptor);
        Class<? extends UserType<?>> userTypeImpl = this.kind.mappingAccess.customType(modelXProperty);
        if (userTypeImpl != null) {
            this.applyExplicitType(userTypeImpl, this.kind.mappingAccess.customTypeParameters(modelXProperty));
            return;
        }
        if (modelTypeXClass != null) {
            Class basicClass = this.buildingContext.getBootstrapContext().getReflectionManager().toClass(modelTypeXClass);
            Class<? extends UserType<?>> registeredUserTypeImpl = this.buildingContext.getMetadataCollector().findRegisteredUserType(basicClass);
            if (registeredUserTypeImpl != null) {
                this.applyExplicitType(registeredUserTypeImpl, new Parameter[0]);
                return;
            }
        }
        switch (this.kind) {
            case ATTRIBUTE: {
                this.prepareBasicAttribute(declaringClassName, modelXProperty, modelPropertyTypeXClass);
                break;
            }
            case ANY_DISCRIMINATOR: {
                this.prepareAnyDiscriminator(modelXProperty);
                break;
            }
            case ANY_KEY: {
                this.prepareAnyKey(modelXProperty);
                break;
            }
            case COLLECTION_ID: {
                this.prepareCollectionId(modelXProperty);
                break;
            }
            case LIST_INDEX: {
                this.prepareListIndex(modelXProperty);
                break;
            }
            case MAP_KEY: {
                this.prepareMapKey(modelXProperty, modelPropertyTypeXClass);
                break;
            }
            case COLLECTION_ELEMENT: {
                this.prepareCollectionElement(modelXProperty, modelPropertyTypeXClass);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unexpected binder type : " + this.kind);
            }
        }
    }

    private void applyExplicitType(Class<? extends UserType<?>> impl, Parameter[] params) {
        this.explicitCustomType = impl;
        this.explicitLocalTypeParams = this.extractTypeParams(params);
    }

    private Map<String, String> extractTypeParams(Parameter[] parameters) {
        if (parameters == null || parameters.length == 0) {
            return Collections.emptyMap();
        }
        if (parameters.length == 1) {
            return Collections.singletonMap(parameters[0].name(), parameters[0].value());
        }
        HashMap<String, String> map = new HashMap<String, String>();
        for (Parameter parameter : parameters) {
            map.put(parameter.name(), parameter.value());
        }
        return map;
    }

    private void prepareCollectionId(XProperty modelXProperty) {
        CollectionId collectionIdAnn = (CollectionId)modelXProperty.getAnnotation(CollectionId.class);
        if (collectionIdAnn == null) {
            throw new MappingException("idbag mapping missing @CollectionId");
        }
        boolean useDeferredBeanContainerAccess = !this.buildingContext.getBuildingOptions().isAllowExtensionsInCdi();
        ManagedBeanRegistry beanRegistry = this.getManagedBeanRegistry();
        this.explicitBasicTypeName = null;
        this.implicitJavaTypeAccess = typeConfiguration -> null;
        this.explicitJavaTypeAccess = typeConfiguration -> {
            Class<? extends BasicJavaType<?>> javaTypeClass;
            CollectionIdJavaType javaTypeAnn = HCANNHelper.findAnnotation((XAnnotatedElement)modelXProperty, CollectionIdJavaType.class);
            if (javaTypeAnn != null && (javaTypeClass = BasicValueBinder.normalizeJavaType(javaTypeAnn.value())) != null) {
                if (useDeferredBeanContainerAccess) {
                    return FallbackBeanInstanceProducer.INSTANCE.produceBeanInstance(javaTypeClass);
                }
                ManagedBean<BasicJavaType<?>> bean = beanRegistry.getBean(javaTypeClass);
                return bean.getBeanInstance();
            }
            return null;
        };
        this.explicitJdbcTypeAccess = typeConfiguration -> {
            Class<? extends JdbcType> jdbcTypeClass;
            CollectionIdJdbcType jdbcTypeAnn = HCANNHelper.findAnnotation((XAnnotatedElement)modelXProperty, CollectionIdJdbcType.class);
            if (jdbcTypeAnn != null && (jdbcTypeClass = this.normalizeJdbcType(jdbcTypeAnn.value())) != null) {
                if (useDeferredBeanContainerAccess) {
                    return FallbackBeanInstanceProducer.INSTANCE.produceBeanInstance(jdbcTypeClass);
                }
                ManagedBean<? extends JdbcType> managedBean = beanRegistry.getBean(jdbcTypeClass);
                return managedBean.getBeanInstance();
            }
            CollectionIdJdbcTypeCode jdbcTypeCodeAnn = HCANNHelper.findAnnotation((XAnnotatedElement)modelXProperty, CollectionIdJdbcTypeCode.class);
            if (jdbcTypeCodeAnn != null && jdbcTypeCodeAnn.value() != Integer.MIN_VALUE) {
                return typeConfiguration.getJdbcTypeRegistry().getDescriptor(jdbcTypeCodeAnn.value());
            }
            return null;
        };
        this.explicitMutabilityAccess = typeConfiguration -> {
            Class<UserType<?>> customTypeImpl;
            Class attributeType;
            Class<? extends MutabilityPlan<?>> mutabilityClass;
            CollectionIdMutability mutabilityAnn = HCANNHelper.findAnnotation((XAnnotatedElement)modelXProperty, CollectionIdMutability.class);
            if (mutabilityAnn != null && (mutabilityClass = mutabilityAnn.value()) != null) {
                return this.resolveMutability(mutabilityClass);
            }
            if (this.implicitJavaTypeAccess != null && (attributeType = ReflectHelper.getClass(this.implicitJavaTypeAccess.apply((TypeConfiguration)typeConfiguration))) != null) {
                Mutability attributeTypeMutabilityAnn = attributeType.getAnnotation(Mutability.class);
                if (attributeTypeMutabilityAnn != null) {
                    return this.resolveMutability(attributeTypeMutabilityAnn.value());
                }
                if (attributeType.isAnnotationPresent(Immutable.class)) {
                    return ImmutableMutabilityPlan.instance();
                }
            }
            if (this.converterDescriptor != null) {
                Mutability converterMutabilityAnn = this.converterDescriptor.getAttributeConverterClass().getAnnotation(Mutability.class);
                if (converterMutabilityAnn != null) {
                    return this.resolveMutability(converterMutabilityAnn.value());
                }
                if (this.converterDescriptor.getAttributeConverterClass().isAnnotationPresent(Immutable.class)) {
                    return ImmutableMutabilityPlan.instance();
                }
            }
            if ((customTypeImpl = Kind.ATTRIBUTE.mappingAccess.customType(modelXProperty)) != null) {
                Mutability customTypeMutabilityAnn = customTypeImpl.getAnnotation(Mutability.class);
                if (customTypeMutabilityAnn != null) {
                    return this.resolveMutability(customTypeMutabilityAnn.value());
                }
                if (customTypeImpl.isAnnotationPresent(Immutable.class)) {
                    return ImmutableMutabilityPlan.instance();
                }
            }
            return null;
        };
    }

    private ManagedBeanRegistry getManagedBeanRegistry() {
        return this.buildingContext.getBootstrapContext().getServiceRegistry().requireService(ManagedBeanRegistry.class);
    }

    private void prepareMapKey(XProperty mapAttribute, XClass modelPropertyTypeXClass) {
        MapKeyTemporal mapKeyTemporalAnn;
        XClass mapKeyClass = modelPropertyTypeXClass == null ? mapAttribute.getMapKey() : modelPropertyTypeXClass;
        java.lang.reflect.Type javaType = this.resolveJavaType(mapKeyClass);
        this.implicitJavaTypeAccess = typeConfiguration -> javaType;
        MapKeyEnumerated mapKeyEnumeratedAnn = (MapKeyEnumerated)mapAttribute.getAnnotation(MapKeyEnumerated.class);
        if (mapKeyEnumeratedAnn != null) {
            this.enumType = mapKeyEnumeratedAnn.value();
        }
        if ((mapKeyTemporalAnn = (MapKeyTemporal)mapAttribute.getAnnotation(MapKeyTemporal.class)) != null) {
            this.temporalPrecision = mapKeyTemporalAnn.value();
        }
        boolean useDeferredBeanContainerAccess = !this.buildingContext.getBuildingOptions().isAllowExtensionsInCdi();
        this.explicitJdbcTypeAccess = typeConfiguration -> {
            int jdbcTypeCode;
            Class<? extends JdbcType> jdbcTypeClass;
            MapKeyJdbcType jdbcTypeAnn = HCANNHelper.findAnnotation((XAnnotatedElement)mapAttribute, MapKeyJdbcType.class);
            if (jdbcTypeAnn != null && (jdbcTypeClass = this.normalizeJdbcType(jdbcTypeAnn.value())) != null) {
                if (useDeferredBeanContainerAccess) {
                    return FallbackBeanInstanceProducer.INSTANCE.produceBeanInstance(jdbcTypeClass);
                }
                return this.getManagedBeanRegistry().getBean(jdbcTypeClass).getBeanInstance();
            }
            MapKeyJdbcTypeCode jdbcTypeCodeAnn = HCANNHelper.findAnnotation((XAnnotatedElement)mapAttribute, MapKeyJdbcTypeCode.class);
            if (jdbcTypeCodeAnn != null && (jdbcTypeCode = jdbcTypeCodeAnn.value()) != Integer.MIN_VALUE) {
                return typeConfiguration.getJdbcTypeRegistry().getDescriptor(jdbcTypeCode);
            }
            return null;
        };
        this.explicitJavaTypeAccess = typeConfiguration -> {
            Class<? extends BasicJavaType<?>> javaTypeClass;
            MapKeyJavaType javaTypeAnn = HCANNHelper.findAnnotation((XAnnotatedElement)mapAttribute, MapKeyJavaType.class);
            if (javaTypeAnn != null && (javaTypeClass = BasicValueBinder.normalizeJavaType(javaTypeAnn.value())) != null) {
                if (useDeferredBeanContainerAccess) {
                    return FallbackBeanInstanceProducer.INSTANCE.produceBeanInstance(javaTypeClass);
                }
                return this.getManagedBeanRegistry().getBean(javaTypeClass).getBeanInstance();
            }
            MapKeyClass mapKeyClassAnn = (MapKeyClass)mapAttribute.getAnnotation(MapKeyClass.class);
            if (mapKeyClassAnn != null) {
                return (BasicJavaType)typeConfiguration.getJavaTypeRegistry().getDescriptor(mapKeyClassAnn.value());
            }
            return null;
        };
        this.explicitMutabilityAccess = typeConfiguration -> {
            Class<UserType<?>> customTypeImpl;
            Class attributeType;
            Class<? extends MutabilityPlan<?>> mutabilityClass;
            MapKeyMutability mutabilityAnn = HCANNHelper.findAnnotation((XAnnotatedElement)mapAttribute, MapKeyMutability.class);
            if (mutabilityAnn != null && (mutabilityClass = mutabilityAnn.value()) != null) {
                return this.resolveMutability(mutabilityClass);
            }
            if (this.implicitJavaTypeAccess != null && (attributeType = ReflectHelper.getClass(this.implicitJavaTypeAccess.apply((TypeConfiguration)typeConfiguration))) != null) {
                Mutability attributeTypeMutabilityAnn = attributeType.getAnnotation(Mutability.class);
                if (attributeTypeMutabilityAnn != null) {
                    return this.resolveMutability(attributeTypeMutabilityAnn.value());
                }
                if (attributeType.isAnnotationPresent(Immutable.class)) {
                    return ImmutableMutabilityPlan.instance();
                }
            }
            if (this.converterDescriptor != null) {
                Mutability converterMutabilityAnn = this.converterDescriptor.getAttributeConverterClass().getAnnotation(Mutability.class);
                if (converterMutabilityAnn != null) {
                    return this.resolveMutability(converterMutabilityAnn.value());
                }
                if (this.converterDescriptor.getAttributeConverterClass().isAnnotationPresent(Immutable.class)) {
                    return ImmutableMutabilityPlan.instance();
                }
            }
            if ((customTypeImpl = Kind.MAP_KEY.mappingAccess.customType(mapAttribute)) != null) {
                Mutability customTypeMutabilityAnn = customTypeImpl.getAnnotation(Mutability.class);
                if (customTypeMutabilityAnn != null) {
                    return this.resolveMutability(customTypeMutabilityAnn.value());
                }
                if (customTypeImpl.isAnnotationPresent(Immutable.class)) {
                    return ImmutableMutabilityPlan.instance();
                }
            }
            return null;
        };
    }

    private void prepareListIndex(XProperty listAttribute) {
        this.implicitJavaTypeAccess = typeConfiguration -> Integer.class;
        boolean useDeferredBeanContainerAccess = !this.buildingContext.getBuildingOptions().isAllowExtensionsInCdi();
        ManagedBeanRegistry beanRegistry = this.buildingContext.getBootstrapContext().getServiceRegistry().requireService(ManagedBeanRegistry.class);
        this.explicitJavaTypeAccess = typeConfiguration -> {
            Class<? extends BasicJavaType<?>> javaTypeClass;
            ListIndexJavaType javaTypeAnn = HCANNHelper.findAnnotation((XAnnotatedElement)listAttribute, ListIndexJavaType.class);
            if (javaTypeAnn != null && (javaTypeClass = BasicValueBinder.normalizeJavaType(javaTypeAnn.value())) != null) {
                if (useDeferredBeanContainerAccess) {
                    return FallbackBeanInstanceProducer.INSTANCE.produceBeanInstance(javaTypeClass);
                }
                ManagedBean<BasicJavaType<?>> bean = beanRegistry.getBean(javaTypeClass);
                return bean.getBeanInstance();
            }
            return null;
        };
        this.explicitJdbcTypeAccess = typeConfiguration -> {
            Class<? extends JdbcType> jdbcTypeClass;
            ListIndexJdbcType jdbcTypeAnn = HCANNHelper.findAnnotation((XAnnotatedElement)listAttribute, ListIndexJdbcType.class);
            if (jdbcTypeAnn != null && (jdbcTypeClass = this.normalizeJdbcType(jdbcTypeAnn.value())) != null) {
                if (useDeferredBeanContainerAccess) {
                    return FallbackBeanInstanceProducer.INSTANCE.produceBeanInstance(jdbcTypeClass);
                }
                ManagedBean<? extends JdbcType> bean = beanRegistry.getBean(jdbcTypeClass);
                return bean.getBeanInstance();
            }
            ListIndexJdbcTypeCode jdbcTypeCodeAnn = HCANNHelper.findAnnotation((XAnnotatedElement)listAttribute, ListIndexJdbcTypeCode.class);
            if (jdbcTypeCodeAnn != null) {
                return typeConfiguration.getJdbcTypeRegistry().getDescriptor(jdbcTypeCodeAnn.value());
            }
            return null;
        };
    }

    private void prepareCollectionElement(XProperty attributeXProperty, XClass elementTypeXClass) {
        XClass xclass = elementTypeXClass == null && attributeXProperty.isArray() ? attributeXProperty.getElementClass() : elementTypeXClass;
        java.lang.reflect.Type javaType = this.resolveJavaType(xclass);
        Class javaTypeClass = ReflectHelper.getClass(javaType);
        this.implicitJavaTypeAccess = typeConfiguration -> javaType;
        Temporal temporalAnn = (Temporal)attributeXProperty.getAnnotation(Temporal.class);
        if (temporalAnn != null) {
            this.temporalPrecision = temporalAnn.value();
            if (this.temporalPrecision == null) {
                throw new IllegalStateException("No jakarta.persistence.TemporalType defined for @jakarta.persistence.Temporal associated with attribute " + attributeXProperty.getDeclaringClass().getName() + "." + attributeXProperty.getName());
            }
        } else {
            this.temporalPrecision = null;
        }
        if (javaTypeClass.isEnum()) {
            Enumerated enumeratedAnn = (Enumerated)attributeXProperty.getAnnotation(Enumerated.class);
            if (enumeratedAnn != null) {
                this.enumType = enumeratedAnn.value();
                if (this.enumType == null) {
                    throw new IllegalStateException("jakarta.persistence.EnumType was null on @jakarta.persistence.Enumerated  associated with attribute " + attributeXProperty.getDeclaringClass().getName() + "." + attributeXProperty.getName());
                }
            }
        } else {
            this.enumType = null;
        }
        this.normalSupplementalDetails(attributeXProperty);
        ElementCollection elementCollectionAnn = (ElementCollection)attributeXProperty.getAnnotation(ElementCollection.class);
        if (elementCollectionAnn != null && elementCollectionAnn.targetClass() != null && elementCollectionAnn.targetClass() != Void.TYPE) {
            Function<TypeConfiguration, BasicJavaType> original = this.explicitJavaTypeAccess;
            this.explicitJavaTypeAccess = typeConfiguration -> {
                BasicJavaType originalResult = (BasicJavaType)original.apply((TypeConfiguration)typeConfiguration);
                if (originalResult != null) {
                    return originalResult;
                }
                return (BasicJavaType)typeConfiguration.getJavaTypeRegistry().getDescriptor(elementCollectionAnn.targetClass());
            };
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void prepareBasicAttribute(String declaringClassName, XProperty attributeDescriptor, XClass attributeType) {
        Enumerated enumeratedAnn;
        java.lang.reflect.Type javaType = this.resolveJavaType(attributeType);
        Class<Object> javaTypeClass = ReflectHelper.getClass(javaType);
        this.implicitJavaTypeAccess = typeConfiguration -> javaType;
        Temporal temporalAnn = (Temporal)attributeDescriptor.getAnnotation(Temporal.class);
        if (temporalAnn != null) {
            this.temporalPrecision = temporalAnn.value();
            if (this.temporalPrecision == null) {
                throw new IllegalStateException("No jakarta.persistence.TemporalType defined for @jakarta.persistence.Temporal associated with attribute " + attributeDescriptor.getDeclaringClass().getName() + "." + attributeDescriptor.getName());
            }
        } else {
            this.temporalPrecision = null;
        }
        if ((enumeratedAnn = (Enumerated)attributeDescriptor.getAnnotation(Enumerated.class)) != null) {
            this.enumType = enumeratedAnn.value();
            if (!this.canUseEnumerated(javaType, javaTypeClass)) throw new AnnotationException(String.format("Property '%s.%s' is annotated '@Enumerated' but its type '%s' is not an enum", declaringClassName, attributeDescriptor.getName(), attributeType.getName()));
            if (this.enumType == null) {
                throw new IllegalStateException("jakarta.persistence.EnumType was null on @jakarta.persistence.Enumerated  associated with attribute " + attributeDescriptor.getDeclaringClass().getName() + "." + attributeDescriptor.getName());
            }
        } else {
            this.enumType = null;
        }
        this.normalSupplementalDetails(attributeDescriptor);
    }

    private boolean canUseEnumerated(java.lang.reflect.Type javaType, Class<Object> javaTypeClass) {
        java.lang.reflect.Type[] typeArguments;
        if (javaTypeClass.isEnum() || javaTypeClass.isArray() && javaTypeClass.getComponentType().isEnum()) {
            return true;
        }
        if (Collection.class.isAssignableFrom(javaTypeClass) && (typeArguments = ((ParameterizedType)javaType).getActualTypeArguments()).length != 0) {
            return ReflectHelper.getClass(typeArguments[0]).isEnum();
        }
        return false;
    }

    private void prepareAnyDiscriminator(XProperty modelXProperty) {
        AnyDiscriminator anyDiscriminatorAnn = HCANNHelper.findAnnotation((XAnnotatedElement)modelXProperty, AnyDiscriminator.class);
        this.implicitJavaTypeAccess = typeConfiguration -> {
            if (anyDiscriminatorAnn != null) {
                switch (anyDiscriminatorAnn.value()) {
                    case CHAR: {
                        return Character.class;
                    }
                    case INTEGER: {
                        return Integer.class;
                    }
                }
                return String.class;
            }
            return String.class;
        };
        this.normalJdbcTypeDetails(modelXProperty);
        this.normalMutabilityDetails(modelXProperty);
        Function<TypeConfiguration, JdbcType> originalJdbcTypeResolution = this.explicitJdbcTypeAccess;
        this.explicitJdbcTypeAccess = typeConfiguration -> {
            JdbcType originalResolution = (JdbcType)originalJdbcTypeResolution.apply((TypeConfiguration)typeConfiguration);
            if (originalResolution != null) {
                return originalResolution;
            }
            Class hintedJavaType = (Class)this.implicitJavaTypeAccess.apply((TypeConfiguration)typeConfiguration);
            JavaType hintedDescriptor = typeConfiguration.getJavaTypeRegistry().getDescriptor(hintedJavaType);
            return hintedDescriptor.getRecommendedJdbcType(typeConfiguration.getCurrentBaseSqlTypeIndicators());
        };
    }

    private void prepareAnyKey(XProperty modelXProperty) {
        this.implicitJavaTypeAccess = typeConfiguration -> null;
        boolean useDeferredBeanContainerAccess = !this.buildingContext.getBuildingOptions().isAllowExtensionsInCdi();
        this.explicitJavaTypeAccess = typeConfiguration -> {
            Class<? extends BasicJavaType<?>> javaTypeClass;
            AnyKeyJavaType javaTypeAnn = HCANNHelper.findAnnotation((XAnnotatedElement)modelXProperty, AnyKeyJavaType.class);
            if (javaTypeAnn != null && (javaTypeClass = BasicValueBinder.normalizeJavaType(javaTypeAnn.value())) != null) {
                if (useDeferredBeanContainerAccess) {
                    return FallbackBeanInstanceProducer.INSTANCE.produceBeanInstance(javaTypeClass);
                }
                return this.getManagedBeanRegistry().getBean(javaTypeClass).getBeanInstance();
            }
            AnyKeyJavaClass javaClassAnn = HCANNHelper.findAnnotation((XAnnotatedElement)modelXProperty, AnyKeyJavaClass.class);
            if (javaClassAnn != null) {
                return (BasicJavaType)typeConfiguration.getJavaTypeRegistry().getDescriptor(javaClassAnn.value());
            }
            throw new MappingException("Could not determine key type for '@Any' mapping (specify '@AnyKeyJavaType' or '@AnyKeyJavaClass')");
        };
        this.explicitJdbcTypeAccess = typeConfiguration -> {
            Class<? extends JdbcType> jdbcTypeClass;
            AnyKeyJdbcType jdbcTypeAnn = HCANNHelper.findAnnotation((XAnnotatedElement)modelXProperty, AnyKeyJdbcType.class);
            if (jdbcTypeAnn != null && (jdbcTypeClass = this.normalizeJdbcType(jdbcTypeAnn.value())) != null) {
                if (useDeferredBeanContainerAccess) {
                    return FallbackBeanInstanceProducer.INSTANCE.produceBeanInstance(jdbcTypeClass);
                }
                ManagedBean<? extends JdbcType> jtdBean = this.getManagedBeanRegistry().getBean(jdbcTypeClass);
                return jtdBean.getBeanInstance();
            }
            AnyKeyJdbcTypeCode jdbcTypeCodeAnn = HCANNHelper.findAnnotation((XAnnotatedElement)modelXProperty, AnyKeyJdbcTypeCode.class);
            if (jdbcTypeCodeAnn != null && jdbcTypeCodeAnn.value() != Integer.MIN_VALUE) {
                return typeConfiguration.getJdbcTypeRegistry().getDescriptor(jdbcTypeCodeAnn.value());
            }
            return null;
        };
    }

    private void normalJdbcTypeDetails(XProperty attributeXProperty) {
        this.explicitJdbcTypeAccess = typeConfiguration -> {
            int jdbcTypeCode;
            Class<? extends JdbcType> jdbcTypeClass;
            org.hibernate.annotations.JdbcType jdbcTypeAnn = HCANNHelper.findAnnotation((XAnnotatedElement)attributeXProperty, org.hibernate.annotations.JdbcType.class);
            if (jdbcTypeAnn != null && (jdbcTypeClass = this.normalizeJdbcType(jdbcTypeAnn.value())) != null) {
                if (!this.buildingContext.getBuildingOptions().isAllowExtensionsInCdi()) {
                    return FallbackBeanInstanceProducer.INSTANCE.produceBeanInstance(jdbcTypeClass);
                }
                return this.getManagedBeanRegistry().getBean(jdbcTypeClass).getBeanInstance();
            }
            JdbcTypeCode jdbcTypeCodeAnn = HCANNHelper.findAnnotation((XAnnotatedElement)attributeXProperty, JdbcTypeCode.class);
            if (jdbcTypeCodeAnn != null && (jdbcTypeCode = jdbcTypeCodeAnn.value()) != Integer.MIN_VALUE) {
                JdbcTypeRegistry jdbcTypeRegistry = typeConfiguration.getJdbcTypeRegistry();
                if (jdbcTypeRegistry.getConstructor(jdbcTypeCode) != null) {
                    return null;
                }
                return jdbcTypeRegistry.getDescriptor(jdbcTypeCode);
            }
            return null;
        };
    }

    private void normalMutabilityDetails(XProperty attributeXProperty) {
        this.explicitMutabilityAccess = typeConfiguration -> {
            Class<UserType<?>> customTypeImpl;
            Class<? extends MutabilityPlan<?>> mutability;
            Class<? extends MutabilityPlan<?>> mutability2;
            Mutability mutabilityAnn = HCANNHelper.findAnnotation((XAnnotatedElement)attributeXProperty, Mutability.class);
            if (mutabilityAnn != null && (mutability2 = mutabilityAnn.value()) != null) {
                return this.resolveMutability(mutability2);
            }
            Immutable immutableAnn = (Immutable)attributeXProperty.getAnnotation(Immutable.class);
            if (immutableAnn != null) {
                return ImmutableMutabilityPlan.instance();
            }
            if (this.explicitJavaTypeAccess != null || this.implicitJavaTypeAccess != null) {
                java.lang.reflect.Type javaType;
                BasicJavaType jtd;
                Class attributeType = null;
                if (this.explicitJavaTypeAccess != null && (jtd = this.explicitJavaTypeAccess.apply((TypeConfiguration)typeConfiguration)) != null) {
                    attributeType = jtd.getJavaTypeClass();
                }
                if (attributeType == null && (javaType = this.implicitJavaTypeAccess.apply((TypeConfiguration)typeConfiguration)) != null) {
                    attributeType = ReflectHelper.getClass(javaType);
                }
                if (attributeType != null) {
                    Mutability classMutability = attributeType.getAnnotation(Mutability.class);
                    if (classMutability != null && (mutability = classMutability.value()) != null) {
                        return this.resolveMutability(mutability);
                    }
                    Immutable classImmutable = attributeType.getAnnotation(Immutable.class);
                    if (classImmutable != null) {
                        return ImmutableMutabilityPlan.instance();
                    }
                }
            }
            if (this.converterDescriptor != null) {
                Mutability converterMutabilityAnn = this.converterDescriptor.getAttributeConverterClass().getAnnotation(Mutability.class);
                if (converterMutabilityAnn != null) {
                    Class<? extends MutabilityPlan<?>> mutability3 = converterMutabilityAnn.value();
                    return this.resolveMutability(mutability3);
                }
                Immutable converterImmutableAnn = this.converterDescriptor.getAttributeConverterClass().getAnnotation(Immutable.class);
                if (converterImmutableAnn != null) {
                    return ImmutableMutabilityPlan.instance();
                }
            }
            if ((customTypeImpl = Kind.ATTRIBUTE.mappingAccess.customType(attributeXProperty)) != null) {
                Mutability customTypeMutabilityAnn = customTypeImpl.getAnnotation(Mutability.class);
                if (customTypeMutabilityAnn != null) {
                    mutability = customTypeMutabilityAnn.value();
                    return this.resolveMutability(mutability);
                }
                Immutable customTypeImmutableAnn = customTypeImpl.getAnnotation(Immutable.class);
                if (customTypeImmutableAnn != null) {
                    return ImmutableMutabilityPlan.instance();
                }
            }
            return null;
        };
    }

    private <T> MutabilityPlan<T> resolveMutability(Class<? extends MutabilityPlan> mutability) {
        if (mutability.equals(Immutability.class)) {
            return Immutability.instance();
        }
        if (mutability.equals(ImmutableMutabilityPlan.class)) {
            return ImmutableMutabilityPlan.instance();
        }
        if (!this.buildingContext.getBuildingOptions().isAllowExtensionsInCdi()) {
            return FallbackBeanInstanceProducer.INSTANCE.produceBeanInstance(mutability);
        }
        return this.getManagedBeanRegistry().getBean(mutability).getBeanInstance();
    }

    private void normalSupplementalDetails(XProperty attributeXProperty) {
        PartitionKey partitionKey;
        TimeZoneStorage timeZoneStorage;
        Temporal temporal;
        this.explicitJavaTypeAccess = typeConfiguration -> {
            Class<? extends BasicJavaType<?>> javaTypeClass;
            org.hibernate.annotations.JavaType javaType = HCANNHelper.findAnnotation((XAnnotatedElement)attributeXProperty, org.hibernate.annotations.JavaType.class);
            if (javaType != null && (javaTypeClass = BasicValueBinder.normalizeJavaType(javaType.value())) != null) {
                if (!this.buildingContext.getBuildingOptions().isAllowExtensionsInCdi()) {
                    return FallbackBeanInstanceProducer.INSTANCE.produceBeanInstance(javaTypeClass);
                }
                return this.getManagedBeanRegistry().getBean(javaTypeClass).getBeanInstance();
            }
            Target targetAnn = HCANNHelper.findAnnotation((XAnnotatedElement)attributeXProperty, Target.class);
            if (targetAnn != null) {
                return (BasicJavaType)typeConfiguration.getJavaTypeRegistry().getDescriptor(targetAnn.value());
            }
            return null;
        };
        JdbcTypeCode jdbcType = HCANNHelper.findAnnotation((XAnnotatedElement)attributeXProperty, JdbcTypeCode.class);
        if (jdbcType != null) {
            this.jdbcTypeCode = jdbcType.value();
        }
        this.normalJdbcTypeDetails(attributeXProperty);
        this.normalMutabilityDetails(attributeXProperty);
        Enumerated enumerated = (Enumerated)attributeXProperty.getAnnotation(Enumerated.class);
        if (enumerated != null) {
            this.enumType = enumerated.value();
        }
        if ((temporal = (Temporal)attributeXProperty.getAnnotation(Temporal.class)) != null) {
            this.temporalPrecision = temporal.value();
        }
        if ((timeZoneStorage = (TimeZoneStorage)attributeXProperty.getAnnotation(TimeZoneStorage.class)) != null) {
            this.timeZoneStorageType = timeZoneStorage.value();
            TimeZoneColumn timeZoneColumnAnn = (TimeZoneColumn)attributeXProperty.getAnnotation(TimeZoneColumn.class);
            if (timeZoneColumnAnn != null && this.timeZoneStorageType != TimeZoneStorageType.AUTO && this.timeZoneStorageType != TimeZoneStorageType.COLUMN) {
                throw new IllegalStateException("@TimeZoneColumn can not be used in conjunction with @TimeZoneStorage( " + this.timeZoneStorageType + " ) with attribute " + attributeXProperty.getDeclaringClass().getName() + "." + attributeXProperty.getName());
            }
        }
        if ((partitionKey = (PartitionKey)attributeXProperty.getAnnotation(PartitionKey.class)) != null) {
            this.partitionKey = true;
        }
    }

    private static Class<? extends UserType<?>> normalizeUserType(Class<? extends UserType<?>> userType) {
        return userType;
    }

    private Class<? extends JdbcType> normalizeJdbcType(Class<? extends JdbcType> jdbcType) {
        return jdbcType;
    }

    private static Class<? extends BasicJavaType<?>> normalizeJavaType(Class<? extends BasicJavaType<?>> javaType) {
        return javaType;
    }

    private java.lang.reflect.Type resolveJavaType(XClass returnedClassOrElement) {
        return this.buildingContext.getBootstrapContext().getReflectionManager().toType(returnedClassOrElement);
    }

    @Override
    public Dialect getDialect() {
        return this.buildingContext.getMetadataCollector().getDatabase().getDialect();
    }

    private void applyJpaConverter(XProperty property, ConverterDescriptor attributeConverterDescriptor) {
        if (attributeConverterDescriptor == null) {
            return;
        }
        LOG.debugf("Applying JPA converter [%s:%s]", this.persistentClassName, property.getName());
        if (property.isAnnotationPresent(Id.class)) {
            LOG.debugf("Skipping AttributeConverter checks for Id attribute [%s]", property.getName());
            return;
        }
        if (property.isAnnotationPresent(Version.class)) {
            LOG.debugf("Skipping AttributeConverter checks for version attribute [%s]", property.getName());
            return;
        }
        if (this.kind == Kind.MAP_KEY) {
            if (property.isAnnotationPresent(MapKeyTemporal.class)) {
                LOG.debugf("Skipping AttributeConverter checks for map-key annotated as MapKeyTemporal [%s]", property.getName());
                return;
            }
            if (property.isAnnotationPresent(MapKeyEnumerated.class)) {
                LOG.debugf("Skipping AttributeConverter checks for map-key annotated as MapKeyEnumerated [%s]", property.getName());
                return;
            }
        } else {
            if (property.isAnnotationPresent(Temporal.class)) {
                LOG.debugf("Skipping AttributeConverter checks for Temporal attribute [%s]", property.getName());
                return;
            }
            if (property.isAnnotationPresent(Enumerated.class)) {
                LOG.debugf("Skipping AttributeConverter checks for Enumerated attribute [%s]", property.getName());
                return;
            }
        }
        if (this.isAssociation()) {
            LOG.debugf("Skipping AttributeConverter checks for association attribute [%s]", property.getName());
            return;
        }
        this.converterDescriptor = attributeConverterDescriptor;
    }

    private boolean isAssociation() {
        return this.referencedEntityName != null;
    }

    public void setExplicitType(String explicitType) {
        this.explicitBasicTypeName = explicitType;
    }

    public BasicValue make() {
        if (this.basicValue != null) {
            return this.basicValue;
        }
        this.columns.checkPropertyConsistency();
        LOG.debugf("building BasicValue for %s", this.propertyName);
        if (this.table == null) {
            this.table = this.columns.getTable();
        }
        this.basicValue = new BasicValue(this.buildingContext, this.table);
        if (this.columns.getPropertyHolder().isComponent()) {
            ComponentPropertyHolder propertyHolder = (ComponentPropertyHolder)this.columns.getPropertyHolder();
            this.basicValue.setAggregateColumn(propertyHolder.getAggregateColumn());
        }
        if (this.isNationalized()) {
            this.basicValue.makeNationalized();
        }
        if (this.isLob()) {
            this.basicValue.makeLob();
        }
        if (this.enumType != null) {
            this.basicValue.setEnumerationStyle(this.enumType);
        }
        if (this.timeZoneStorageType != null) {
            this.basicValue.setTimeZoneStorageType(this.timeZoneStorageType);
        }
        this.basicValue.setPartitionKey(this.partitionKey);
        if (this.temporalPrecision != null) {
            this.basicValue.setTemporalPrecision(this.temporalPrecision);
        }
        if (this.jdbcTypeCode != null) {
            this.basicValue.setExplicitJdbcTypeCode(this.jdbcTypeCode);
        }
        this.linkWithValue();
        boolean isInSecondPass = this.buildingContext.getMetadataCollector().isInSecondPass();
        if (!isInSecondPass) {
            this.buildingContext.getMetadataCollector().addSecondPass(new SetBasicValueTypeSecondPass(this));
        } else {
            this.fillSimpleValue();
        }
        return this.basicValue;
    }

    public void linkWithValue() {
        InFlightMetadataCollector collector = this.buildingContext.getMetadataCollector();
        AnnotatedColumn firstColumn = this.columns.getColumns().get(0);
        if (!collector.isInSecondPass() && firstColumn.isNameDeferred() && this.referencedEntityName != null) {
            AnnotatedJoinColumns joinColumns = new AnnotatedJoinColumns();
            joinColumns.setBuildingContext(this.buildingContext);
            joinColumns.setPropertyHolder(this.columns.getPropertyHolder());
            joinColumns.setPropertyName(this.columns.getPropertyName());
            for (AnnotatedColumn column : this.columns.getColumns()) {
                column.setParent(joinColumns);
            }
            collector.addSecondPass(new PkDrivenByDefaultMapsIdSecondPass(this.referencedEntityName, joinColumns, this.basicValue));
        } else if (this.aggregateComponent != null) {
            assert (this.columns.getColumns().size() == 1);
            firstColumn.linkWithAggregateValue(this.basicValue, this.aggregateComponent);
        } else {
            for (AnnotatedColumn column : this.columns.getColumns()) {
                column.linkWithValue(this.basicValue);
            }
        }
    }

    public void fillSimpleValue() {
        LOG.debugf("Starting `BasicValueBinder#fillSimpleValue` for %s", this.propertyName);
        String explicitBasicTypeName = this.explicitBasicTypeName != null ? this.explicitBasicTypeName : this.timeStampVersionType;
        this.basicValue.setExplicitTypeName(explicitBasicTypeName);
        this.basicValue.setExplicitTypeParams(this.explicitLocalTypeParams);
        Class typeClass = null;
        if (explicitBasicTypeName != null) {
            TypeDefinition typeDefinition = this.buildingContext.getTypeDefinitionRegistry().resolve(explicitBasicTypeName);
            if (typeDefinition == null) {
                BasicType registeredType = this.getTypeConfiguration().getBasicTypeRegistry().getRegisteredType(explicitBasicTypeName);
                if (registeredType == null) {
                    typeClass = this.buildingContext.getBootstrapContext().getClassLoaderAccess().classForName(explicitBasicTypeName);
                }
            } else {
                typeClass = typeDefinition.getTypeImplementorClass();
            }
        } else if (this.enumType != null || this.isEnum()) {
            typeClass = EnumType.class;
        } else if (this.isLob || this.isSerializable()) {
            typeClass = SerializableToBlobType.class;
        }
        if (this.explicitCustomType != null && DynamicParameterizedType.class.isAssignableFrom(this.explicitCustomType) || typeClass != null && DynamicParameterizedType.class.isAssignableFrom(typeClass)) {
            this.basicValue.setTypeParameters(this.createDynamicParameterizedTypeParameters());
        }
        if (this.converterDescriptor != null) {
            this.basicValue.setJpaAttributeConverterDescriptor(this.converterDescriptor);
        }
        if (this.implicitJavaTypeAccess != null) {
            this.basicValue.setImplicitJavaTypeAccess(this.implicitJavaTypeAccess);
        }
        if (this.explicitJavaTypeAccess != null) {
            this.basicValue.setExplicitJavaTypeAccess(this.explicitJavaTypeAccess);
        }
        if (this.explicitJdbcTypeAccess != null) {
            this.basicValue.setExplicitJdbcTypeAccess(this.explicitJdbcTypeAccess);
        }
        if (this.explicitMutabilityAccess != null) {
            this.basicValue.setExplicitMutabilityPlanAccess(this.explicitMutabilityAccess);
        }
        if (this.enumType != null) {
            this.basicValue.setEnumerationStyle(this.enumType);
        }
        if (this.timeZoneStorageType != null) {
            this.basicValue.setTimeZoneStorageType(this.timeZoneStorageType);
        }
        if (this.temporalPrecision != null) {
            this.basicValue.setTemporalPrecision(this.temporalPrecision);
        }
        if (this.isLob()) {
            this.basicValue.makeLob();
        }
        if (this.isNationalized()) {
            this.basicValue.makeNationalized();
        }
        if (this.explicitCustomType != null) {
            this.basicValue.setExplicitCustomType(this.explicitCustomType);
        }
    }

    private Map<String, Object> createDynamicParameterizedTypeParameters() {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        if (this.returnedClassName == null) {
            throw new MappingException("Returned class name not specified for basic mapping: " + this.xproperty.getName());
        }
        parameters.put("org.hibernate.type.ParameterType.returnedClass", this.returnedClassName);
        parameters.put("org.hibernate.type.ParameterType.xproperty", this.xproperty);
        parameters.put("org.hibernate.type.ParameterType.propertyName", this.xproperty.getName());
        parameters.put("org.hibernate.type.ParameterType.dynamic", Boolean.toString(true));
        parameters.put("org.hibernate.type.ParameterType.primaryKey", Boolean.toString(this.kind == Kind.MAP_KEY));
        if (this.persistentClassName != null) {
            parameters.put("org.hibernate.type.ParameterType.entityClass", this.persistentClassName);
        }
        if (this.returnedClassName != null) {
            parameters.put("org.hibernate.type.ParameterType.returnedClass", this.returnedClassName);
        }
        if (this.accessType != null) {
            parameters.put("org.hibernate.type.ParameterType.accessType", this.accessType.getType());
        }
        if (this.explicitLocalTypeParams != null) {
            parameters.putAll(this.explicitLocalTypeParams);
        }
        return parameters;
    }

    private boolean isEnum() {
        Class clazz = null;
        if (this.implicitJavaTypeAccess != null) {
            java.lang.reflect.Type type = this.implicitJavaTypeAccess.apply(this.getTypeConfiguration());
            if (type instanceof ParameterizedType) {
                type = ((ParameterizedType)type).getRawType();
            }
            if (type instanceof Class) {
                clazz = (Class)type;
            }
        }
        return clazz != null && clazz.isEnum();
    }

    private boolean isSerializable() {
        Class clazz = null;
        if (this.implicitJavaTypeAccess != null) {
            java.lang.reflect.Type type = this.implicitJavaTypeAccess.apply(this.getTypeConfiguration());
            if (type instanceof ParameterizedType) {
                type = ((ParameterizedType)type).getRawType();
            }
            if (type instanceof Class) {
                clazz = (Class)type;
            }
        }
        return clazz != null && Serializable.class.isAssignableFrom(clazz);
    }

    public static enum Kind {
        ATTRIBUTE(ValueMappingAccess.INSTANCE),
        ANY_DISCRIMINATOR(AnyDiscriminatorMappingAccess.INSTANCE),
        ANY_KEY(AnyKeyMappingAccess.INSTANCE),
        MAP_KEY(MapKeyMappingAccess.INSTANCE),
        COLLECTION_ELEMENT(ValueMappingAccess.INSTANCE),
        COLLECTION_ID(CollectionIdMappingAccess.INSTANCE),
        LIST_INDEX(ListIndexMappingAccess.INSTANCE);

        private final BasicMappingAccess mappingAccess;

        private Kind(BasicMappingAccess mappingAccess) {
            this.mappingAccess = mappingAccess;
        }
    }

    private static interface BasicMappingAccess {
        public Class<? extends UserType<?>> customType(XProperty var1);

        public Parameter[] customTypeParameters(XProperty var1);
    }

    private static class ListIndexMappingAccess
    implements BasicMappingAccess {
        public static final ListIndexMappingAccess INSTANCE = new ListIndexMappingAccess();

        private ListIndexMappingAccess() {
        }

        @Override
        public Class<? extends UserType<?>> customType(XProperty xProperty) {
            return null;
        }

        @Override
        public Parameter[] customTypeParameters(XProperty xProperty) {
            return null;
        }
    }

    private static class CollectionIdMappingAccess
    implements BasicMappingAccess {
        public static final CollectionIdMappingAccess INSTANCE = new CollectionIdMappingAccess();

        private CollectionIdMappingAccess() {
        }

        @Override
        public Class<? extends UserType<?>> customType(XProperty xProperty) {
            CollectionIdType customType = HCANNHelper.findAnnotation((XAnnotatedElement)xProperty, CollectionIdType.class);
            if (customType == null) {
                return null;
            }
            return BasicValueBinder.normalizeUserType(customType.value());
        }

        @Override
        public Parameter[] customTypeParameters(XProperty xProperty) {
            CollectionIdType customType = HCANNHelper.findAnnotation((XAnnotatedElement)xProperty, CollectionIdType.class);
            if (customType == null) {
                return null;
            }
            return customType.parameters();
        }
    }

    private static class MapKeyMappingAccess
    implements BasicMappingAccess {
        public static final MapKeyMappingAccess INSTANCE = new MapKeyMappingAccess();

        private MapKeyMappingAccess() {
        }

        @Override
        public Class<? extends UserType<?>> customType(XProperty xProperty) {
            MapKeyType customType = HCANNHelper.findAnnotation((XAnnotatedElement)xProperty, MapKeyType.class);
            if (customType == null) {
                return null;
            }
            return BasicValueBinder.normalizeUserType(customType.value());
        }

        @Override
        public Parameter[] customTypeParameters(XProperty xProperty) {
            MapKeyType customType = HCANNHelper.findAnnotation((XAnnotatedElement)xProperty, MapKeyType.class);
            if (customType == null) {
                return null;
            }
            return customType.parameters();
        }
    }

    private static class AnyKeyMappingAccess
    implements BasicMappingAccess {
        public static final AnyKeyMappingAccess INSTANCE = new AnyKeyMappingAccess();
        private static final Parameter[] EMPTY_PARAMS = new Parameter[0];

        private AnyKeyMappingAccess() {
        }

        @Override
        public Class<? extends UserType<?>> customType(XProperty xProperty) {
            return null;
        }

        @Override
        public Parameter[] customTypeParameters(XProperty xProperty) {
            return EMPTY_PARAMS;
        }
    }

    private static class AnyDiscriminatorMappingAccess
    implements BasicMappingAccess {
        public static final AnyDiscriminatorMappingAccess INSTANCE = new AnyDiscriminatorMappingAccess();
        private static final Parameter[] EMPTY_PARAMS = new Parameter[0];

        private AnyDiscriminatorMappingAccess() {
        }

        @Override
        public Class<? extends UserType<?>> customType(XProperty xProperty) {
            return null;
        }

        @Override
        public Parameter[] customTypeParameters(XProperty xProperty) {
            return EMPTY_PARAMS;
        }
    }

    private static class ValueMappingAccess
    implements BasicMappingAccess {
        public static final ValueMappingAccess INSTANCE = new ValueMappingAccess();

        private ValueMappingAccess() {
        }

        @Override
        public Class<? extends UserType<?>> customType(XProperty xProperty) {
            Type customType = HCANNHelper.findAnnotation((XAnnotatedElement)xProperty, Type.class);
            if (customType == null) {
                return null;
            }
            return BasicValueBinder.normalizeUserType(customType.value());
        }

        @Override
        public Parameter[] customTypeParameters(XProperty xProperty) {
            Type customType = HCANNHelper.findAnnotation((XAnnotatedElement)xProperty, Type.class);
            if (customType == null) {
                return null;
            }
            return customType.parameters();
        }
    }
}

