/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.dialect;

import java.util.List;
import org.hibernate.LockMode;
import org.hibernate.dialect.SqlAstTranslatorWithMerge;
import org.hibernate.dialect.identity.H2IdentityColumnSupport;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.internal.util.collections.CollectionHelper;
import org.hibernate.internal.util.collections.Stack;
import org.hibernate.query.IllegalQueryOperationException;
import org.hibernate.query.sqm.ComparisonOperator;
import org.hibernate.sql.ast.Clause;
import org.hibernate.sql.ast.SqlAstNodeRenderingMode;
import org.hibernate.sql.ast.spi.SqlSelection;
import org.hibernate.sql.ast.tree.Statement;
import org.hibernate.sql.ast.tree.cte.CteContainer;
import org.hibernate.sql.ast.tree.cte.CteTableGroup;
import org.hibernate.sql.ast.tree.delete.DeleteStatement;
import org.hibernate.sql.ast.tree.expression.BinaryArithmeticExpression;
import org.hibernate.sql.ast.tree.expression.ColumnReference;
import org.hibernate.sql.ast.tree.expression.Expression;
import org.hibernate.sql.ast.tree.expression.Literal;
import org.hibernate.sql.ast.tree.expression.SqlTuple;
import org.hibernate.sql.ast.tree.expression.Summarization;
import org.hibernate.sql.ast.tree.from.NamedTableReference;
import org.hibernate.sql.ast.tree.from.QueryPartTableReference;
import org.hibernate.sql.ast.tree.from.TableGroup;
import org.hibernate.sql.ast.tree.from.TableReference;
import org.hibernate.sql.ast.tree.insert.ConflictClause;
import org.hibernate.sql.ast.tree.insert.InsertSelectStatement;
import org.hibernate.sql.ast.tree.predicate.BooleanExpressionPredicate;
import org.hibernate.sql.ast.tree.predicate.LikePredicate;
import org.hibernate.sql.ast.tree.select.QueryPart;
import org.hibernate.sql.ast.tree.select.SelectClause;
import org.hibernate.sql.ast.tree.update.UpdateStatement;
import org.hibernate.sql.exec.spi.JdbcOperation;
import org.hibernate.sql.model.internal.TableInsertStandard;
import org.hibernate.sql.model.internal.TableUpdateStandard;

public class H2SqlAstTranslator<T extends JdbcOperation>
extends SqlAstTranslatorWithMerge<T> {
    private boolean renderAsArray;

    public H2SqlAstTranslator(SessionFactoryImplementor sessionFactory, Statement statement) {
        super(sessionFactory, statement);
    }

    @Override
    public void visitStandardTableInsert(TableInsertStandard tableInsert) {
        boolean closeWrapper = this.renderReturningClause(tableInsert.getReturningColumns());
        super.visitStandardTableInsert(tableInsert);
        if (closeWrapper) {
            this.appendSql(')');
        }
    }

    @Override
    public void visitStandardTableUpdate(TableUpdateStandard tableUpdate) {
        boolean closeWrapper = this.renderReturningClause(tableUpdate.getReturningColumns());
        super.visitStandardTableUpdate(tableUpdate);
        if (closeWrapper) {
            this.appendSql(')');
        }
    }

    protected boolean renderReturningClause(List<ColumnReference> returningColumns) {
        if (CollectionHelper.isEmpty(returningColumns)) {
            return false;
        }
        this.appendSql("select ");
        for (int i = 0; i < returningColumns.size(); ++i) {
            if (i > 0) {
                this.appendSql(", ");
            }
            this.appendSql(returningColumns.get(i).getColumnExpression());
        }
        this.appendSql(" from final table (");
        return true;
    }

    @Override
    protected void visitReturningColumns(List<ColumnReference> returningColumns) {
    }

    @Deprecated(forRemoval=true, since="6.5")
    public void visitReturningInsertStatement(TableInsertStandard tableInsert) {
        assert (tableInsert.getReturningColumns() != null && !tableInsert.getReturningColumns().isEmpty());
        H2IdentityColumnSupport identitySupport = (H2IdentityColumnSupport)this.getSessionFactory().getJdbcServices().getDialect().getIdentityColumnSupport();
        identitySupport.render(tableInsert, this::appendSql, columnReference -> columnReference.accept(this), () -> super.visitStandardTableInsert(tableInsert), this.getSessionFactory());
    }

    @Override
    protected void visitInsertStatementOnly(InsertSelectStatement statement) {
        if (statement.getConflictClause() == null || statement.getConflictClause().isDoNothing()) {
            super.visitInsertStatementOnly(statement);
        } else {
            this.visitInsertStatementEmulateMerge(statement);
        }
    }

    @Override
    protected void visitDeleteStatementOnly(DeleteStatement statement) {
        if (H2SqlAstTranslator.hasNonTrivialFromClause(statement.getFromClause())) {
            this.appendSql("delete from ");
            Stack<Clause> clauseStack = this.getClauseStack();
            try {
                clauseStack.push(Clause.DELETE);
                super.renderDmlTargetTableExpression(statement.getTargetTable());
                this.append(" dml_target_");
            }
            finally {
                clauseStack.pop();
            }
            this.visitWhereClause(this.determineWhereClauseRestrictionWithJoinEmulation(statement, "dml_target_"));
            this.visitReturningColumns(statement.getReturningColumns());
        } else {
            super.visitDeleteStatementOnly(statement);
        }
    }

    @Override
    protected void visitUpdateStatementOnly(UpdateStatement statement) {
        if (H2SqlAstTranslator.hasNonTrivialFromClause(statement.getFromClause())) {
            this.visitUpdateStatementEmulateMerge(statement);
        } else {
            super.visitUpdateStatementOnly(statement);
        }
    }

    @Override
    protected void renderDmlTargetTableExpression(NamedTableReference tableReference) {
        super.renderDmlTargetTableExpression(tableReference);
        if (this.getClauseStack().getCurrent() != Clause.INSERT) {
            this.renderTableReferenceIdentificationVariable(tableReference);
        }
    }

    @Override
    protected void visitConflictClause(ConflictClause conflictClause) {
        if (conflictClause != null && conflictClause.isDoUpdate() && conflictClause.getConstraintName() != null) {
            throw new IllegalQueryOperationException("Insert conflict 'do update' clause with constraint name is not supported");
        }
    }

    @Override
    public void visitCteContainer(CteContainer cteContainer) {
        this.withParameterRenderingMode(SqlAstNodeRenderingMode.INLINE_PARAMETERS, () -> super.visitCteContainer(cteContainer));
    }

    @Override
    protected boolean needsCteInlining() {
        return true;
    }

    @Override
    protected boolean shouldInlineCte(TableGroup tableGroup) {
        return tableGroup instanceof CteTableGroup && !this.getCteStatement(tableGroup.getPrimaryTableReference().getTableId()).isRecursive();
    }

    @Override
    protected boolean supportsWithClauseInSubquery() {
        return false;
    }

    @Override
    protected boolean supportsRowConstructor() {
        return true;
    }

    @Override
    protected boolean supportsArrayConstructor() {
        return true;
    }

    @Override
    protected String getArrayContainsFunction() {
        return "array_contains";
    }

    @Override
    protected void renderExpressionAsClauseItem(Expression expression) {
        expression.accept(this);
    }

    @Override
    public void visitBooleanExpressionPredicate(BooleanExpressionPredicate booleanExpressionPredicate) {
        boolean isNegated = booleanExpressionPredicate.isNegated();
        if (isNegated) {
            this.appendSql("not(");
        }
        booleanExpressionPredicate.getExpression().accept(this);
        if (isNegated) {
            this.appendSql(')');
        }
    }

    @Override
    public void visitOffsetFetchClause(QueryPart queryPart) {
        if (this.isRowsOnlyFetchClauseType(queryPart)) {
            if (this.supportsOffsetFetchClause()) {
                this.renderOffsetFetchClause(queryPart, true);
            } else {
                this.renderLimitOffsetClause(queryPart);
            }
        } else if (this.supportsOffsetFetchClausePercentWithTies()) {
            this.renderOffsetFetchClause(queryPart, true);
        } else {
            throw new IllegalArgumentException("Can't emulate fetch clause type: " + queryPart.getFetchClauseType());
        }
    }

    @Override
    protected void renderSelectTupleComparison(List<SqlSelection> lhsExpressions, SqlTuple tuple, ComparisonOperator operator) {
        this.emulateSelectTupleComparison(lhsExpressions, tuple.getExpressions(), operator, true);
    }

    @Override
    protected void visitSqlSelections(SelectClause selectClause) {
        boolean renderAsArray = this.renderAsArray;
        this.renderAsArray = false;
        if (renderAsArray) {
            this.append('(');
        }
        super.visitSqlSelections(selectClause);
        if (renderAsArray) {
            this.append(')');
        }
    }

    @Override
    protected void renderPartitionItem(Expression expression) {
        if (expression instanceof Literal) {
            this.appendSql("'0' || '0'");
        } else {
            if (expression instanceof Summarization) {
                throw new UnsupportedOperationException("Summarization is not supported by DBMS");
            }
            expression.accept(this);
        }
    }

    @Override
    public void visitBinaryArithmeticExpression(BinaryArithmeticExpression arithmeticExpression) {
        this.appendSql('(');
        this.visitArithmeticOperand(arithmeticExpression.getLeftHandOperand());
        this.appendSql(arithmeticExpression.getOperator().getOperatorSqlTextString());
        this.visitArithmeticOperand(arithmeticExpression.getRightHandOperand());
        this.appendSql(')');
    }

    @Override
    protected void visitArithmeticOperand(Expression expression) {
        this.render(expression, SqlAstNodeRenderingMode.NO_PLAIN_PARAMETER);
    }

    @Override
    protected boolean renderPrimaryTableReference(TableGroup tableGroup, LockMode lockMode) {
        TableReference tableRef = tableGroup.getPrimaryTableReference();
        if (tableRef instanceof QueryPartTableReference || tableRef.getTableId().startsWith("(select")) {
            boolean realTableGroup;
            boolean bl = realTableGroup = tableGroup.isRealTableGroup() && (CollectionHelper.isNotEmpty(tableGroup.getTableReferenceJoins()) || this.hasNestedTableGroupsToRender(tableGroup.getNestedTableGroupJoins()));
            if (realTableGroup) {
                this.appendSql("dual cross join ");
            }
        }
        return super.renderPrimaryTableReference(tableGroup, lockMode);
    }

    @Override
    public void visitLikePredicate(LikePredicate likePredicate) {
        super.visitLikePredicate(likePredicate);
        if (likePredicate.getEscapeCharacter() == null) {
            this.appendSql(" escape ''");
        }
    }

    @Override
    protected boolean supportsRowValueConstructorSyntax() {
        return true;
    }

    @Override
    protected boolean supportsRowValueConstructorSyntaxInInList() {
        return true;
    }

    @Override
    protected boolean supportsRowValueConstructorSyntaxInQuantifiedPredicates() {
        return true;
    }

    @Override
    protected boolean supportsRowValueConstructorDistinctFromSyntax() {
        return true;
    }

    @Override
    protected boolean supportsNullPrecedence() {
        return true;
    }

    @Override
    protected String getDual() {
        return "dual";
    }

    private boolean supportsOffsetFetchClause() {
        return true;
    }

    private boolean supportsOffsetFetchClausePercentWithTies() {
        return true;
    }

    @Override
    protected boolean supportsJoinInMutationStatementSubquery() {
        return false;
    }

    @Override
    public boolean supportsFilterClause() {
        return true;
    }
}

