/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.dialect.function.array;

import java.util.List;
import org.hibernate.dialect.function.array.AbstractArrayFillFunction;
import org.hibernate.dialect.function.array.DdlTypeHelper;
import org.hibernate.query.ReturnableType;
import org.hibernate.sql.ast.SqlAstTranslator;
import org.hibernate.sql.ast.spi.SqlAppender;
import org.hibernate.sql.ast.tree.SqlAstNode;
import org.hibernate.sql.ast.tree.expression.Expression;
import org.hibernate.sql.ast.tree.expression.Literal;

public class CockroachArrayFillFunction
extends AbstractArrayFillFunction {
    public CockroachArrayFillFunction(boolean list) {
        super(list);
    }

    @Override
    public void render(SqlAppender sqlAppender, List<? extends SqlAstNode> sqlAstArguments, ReturnableType<?> returnType, SqlAstTranslator<?> walker) {
        String elementCastType;
        sqlAppender.append("coalesce(case when ");
        sqlAstArguments.get(1).accept(walker);
        sqlAppender.append("<>0 then (select array_agg(");
        Expression elementExpression = (Expression)sqlAstArguments.get(0);
        if (CockroachArrayFillFunction.needsElementCasting(elementExpression)) {
            elementCastType = DdlTypeHelper.getCastTypeName(elementExpression.getExpressionType(), walker.getSessionFactory().getTypeConfiguration());
            sqlAppender.append("cast(");
        } else {
            elementCastType = null;
        }
        sqlAstArguments.get(0).accept(walker);
        if (elementCastType != null) {
            sqlAppender.append(" as ");
            sqlAppender.append(elementCastType);
            sqlAppender.append(')');
        }
        sqlAppender.append(") from generate_series(1,");
        sqlAstArguments.get(1).accept(walker);
        sqlAppender.append(",1)) end,array[])");
    }

    private static boolean needsElementCasting(Expression elementExpression) {
        return elementExpression instanceof Literal && (elementExpression.getExpressionType().getSingleJdbcMapping().getJdbcType().isString() || ((Literal)elementExpression).getLiteralValue() == null);
    }
}

